/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.data;

import org.rapidoid.data.JSON;
import org.rapidoid.data.XML;
import org.rapidoid.data.YAML;

public class Parse {
    private static final DataFormat[] XML_FIRST = new DataFormat[]{DataFormat.XML, DataFormat.JSON, DataFormat.YAML};
    private static final DataFormat[] JSON_FIRST = new DataFormat[]{DataFormat.JSON, DataFormat.XML, DataFormat.YAML};
    private static final DataFormat[] YAML_FIRST = new DataFormat[]{DataFormat.YAML, DataFormat.JSON, DataFormat.XML};

    public static <T> T data(String data, Class<T> targetType) {
        return Parse.data(data.getBytes(), targetType);
    }

    public static <T> T data(byte[] data, Class<T> targetType) {
        if (data == null) {
            return null;
        }
        if (targetType == byte[].class) {
            return (T)data;
        }
        DataFormat[] formatsOrder = Parse.detectDataFormat(data);
        return Parse.tryToParseData(data, formatsOrder, targetType);
    }

    private static <T> T tryToParseData(byte[] data, DataFormat[] formatsOrder, Class<T> targetType) {
        Exception firstException = null;
        block11: for (DataFormat dataFormat : formatsOrder) {
            switch (dataFormat) {
                case JSON: {
                    try {
                        return JSON.parse(data, targetType);
                    }
                    catch (Exception e) {
                        if (firstException != null) continue block11;
                        firstException = e;
                        continue block11;
                    }
                }
                case XML: {
                    try {
                        return XML.parse(data, targetType);
                    }
                    catch (Exception e) {
                        if (firstException != null) continue block11;
                        firstException = e;
                        continue block11;
                    }
                }
                case YAML: {
                    try {
                        return YAML.parse(data, targetType);
                    }
                    catch (Exception e) {
                        if (firstException != null) continue block11;
                        firstException = e;
                        continue block11;
                    }
                }
            }
        }
        throw new RuntimeException("Not a valid JSON, XML nor YAML format!", firstException);
    }

    static DataFormat[] detectDataFormat(byte[] data) {
        if (data.length == 0) {
            return YAML_FIRST;
        }
        byte start = Parse.findFirstNonWhitespaceByte(data);
        if (start == 60) {
            return XML_FIRST;
        }
        if (start == 32 || start == 45 && Parse.dataStartsWithYAMLMark(data)) {
            return YAML_FIRST;
        }
        return JSON_FIRST;
    }

    private static byte findFirstNonWhitespaceByte(byte[] data) {
        int i = 0;
        while (Character.isWhitespace(data[i])) {
            if (++i < data.length) continue;
            return 32;
        }
        return data[i];
    }

    private static boolean dataStartsWithYAMLMark(byte[] data) {
        return data.length >= 3 && data[0] == 45 && data[1] == 45 && data[2] == 45;
    }

    static enum DataFormat {
        JSON,
        XML,
        YAML;

    }
}

