/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.data;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.OutputStream;
import java.util.Map;

public class JSON {
    public static final ObjectMapper MAPPER = JSON.mapper();
    public static final ObjectMapper PRETTY_MAPPER = JSON.prettyMapper();

    private static ObjectMapper mapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setBase64Variant(Base64Variants.MODIFIED_FOR_URL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new AfterburnerModule());
        return mapper;
    }

    private static ObjectMapper prettyMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setBase64Variant(Base64Variants.MODIFIED_FOR_URL);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.registerModule((Module)new AfterburnerModule());
        return mapper;
    }

    public static String stringify(Object value) {
        try {
            return MAPPER.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void stringify(Object value, OutputStream out) {
        try {
            MAPPER.writeValue(out, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String prettify(Object value) {
        try {
            return PRETTY_MAPPER.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void prettify(Object value, OutputStream out) {
        try {
            PRETTY_MAPPER.writeValue(out, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(byte[] json) {
        try {
            return (T)MAPPER.readValue(json, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(String json, Class<T> valueType) {
        try {
            return (T)MAPPER.readValue(json, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(byte[] json, Class<T> valueType) {
        try {
            return (T)MAPPER.readValue(json, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(String json, TypeReference<T> valueType) {
        try {
            return (T)MAPPER.readValue(json, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(byte[] json, TypeReference<T> valueType) {
        try {
            return (T)MAPPER.readValue(json, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> parseMap(String json) {
        return JSON.parse(json, Map.class);
    }

    public static void warmup() {
        JSON.stringify(123);
        JSON.parse("{}", Map.class);
    }

    public static byte[] parseBytes(String json) {
        return JSON.parse(json, byte[].class);
    }
}

