/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.main;

import org.rapidoid.util.U;

public class MainHelp {
    public static void processHelp(Object[] args) {
        if (args.length == 1 && args[0].equals("--help")) {
            MainHelp.show("Usage:");
            MainHelp.show("  java -cp <yourapp>.jar com.yourapp.Main [option1 option2 ...]");
            MainHelp.show("\nExample:");
            MainHelp.show("  java -cp <yourapp>.jar com.yourapp.Main port=9090 address=127.0.0.1 cpus=2 workers=4 stateless");
            MainHelp.show("\nAvailable options:");
            MainHelp.opt("mode=(dev|production)", "configure DEV or PRODUCTION mode");
            MainHelp.opt("secret=<SECRET>", "configure app-specific secret token for encryption");
            MainHelp.opt("port=<P>", "listen at port P (default: 8080)");
            MainHelp.opt("address=<ADDR>", "listen at address ADDR (default: 0.0.0.0)");
            MainHelp.opt("stateless", "Run in stateless mode, session becomes cookiepack (default: false)");
            MainHelp.opt("threads=<T>", "start T threads for the job executor service (default: 100)");
            MainHelp.opt("cpus=<C>", "optimize for C number of CPUs (default: the actual number of the CPUs)");
            MainHelp.opt("workers=<W>", "start W number of I/O workers (default: the configured number of CPUs)");
            MainHelp.opt("nodelay", "set the TCP_NODELAY flag to disable Nagle's algorithm (default: false)");
            MainHelp.opt("blockingAccept", "accept connection in BLOCKING mode (default: false)");
            MainHelp.opt("bufSizeKB=<SIZE>", "TCP socket buffer size in KB (default: 16)");
            System.exit(0);
        }
    }

    private static void opt(String opt, String desc) {
        MainHelp.show("  " + opt + U.copyNtimes((String)" ", (int)(17 - opt.length())) + " - " + desc);
    }

    private static void show(String msg) {
        System.out.println(msg);
    }
}

