/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.main;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import org.rapidoid.config.Conf;
import org.rapidoid.log.Log;
import org.rapidoid.main.AppTool;
import org.rapidoid.main.MainHelp;
import org.rapidoid.plugins.Plugin;
import org.rapidoid.plugins.Plugins;
import org.rapidoid.plugins.cache.guava.GuavaCachePlugin;
import org.rapidoid.plugins.templates.MustacheTemplatesPlugin;
import org.rapidoid.quick.Quick;
import org.rapidoid.scan.ClasspathUtil;
import org.rapidoid.util.U;
import org.rapidoid.util.UTILS;
import org.rapidoid.webapp.AppClasspathEntitiesPlugin;
import org.rapidoid.webapp.WebApp;
import org.rapidoid.webapp.WebAppGroup;
import org.slf4j.LoggerFactory;

public class Rapidoid {
    private static boolean initialized = false;

    public static synchronized WebApp run(String[] args, Object ... config) {
        return Rapidoid.initAndStart(null, args, config);
    }

    public static synchronized WebApp run(WebApp app, String[] args, Object ... config) {
        return Rapidoid.initAndStart(app, args, config);
    }

    private static WebApp initAndStart(WebApp app, String[] args, Object ... config) {
        Log.info((String)"Starting Rapidoid...");
        U.must((!initialized ? 1 : 0) != 0, (String)"Already initialized!");
        initialized = true;
        MainHelp.processHelp(args);
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        Conf.args((String[])args, (Object[])config);
        Log.info((String)("Working directory is: " + System.getProperty("user.dir")));
        Rapidoid.inferAndSetRootPackage();
        if (app == null) {
            app = AppTool.createRootApp();
        }
        Rapidoid.registerDefaultPlugins();
        Quick.run((WebApp)app, (String[])args, (Object[])config);
        System.out.println();
        StatusPrinter.print((Context)lc);
        Log.info((String)"Rapidoid is ready.");
        return app;
    }

    private static void registerDefaultPlugins() {
        Plugins.register((Plugin)new MustacheTemplatesPlugin());
        Plugins.register((Plugin)new AppClasspathEntitiesPlugin());
        Plugins.register((Plugin)new GuavaCachePlugin());
    }

    private static void inferAndSetRootPackage() {
        Class callerCls = UTILS.getCallingClassOf(Rapidoid.class);
        if (callerCls != null) {
            String rootPkg = callerCls.getPackage().getName();
            Log.info((String)("Setting root application package: " + rootPkg));
            ClasspathUtil.setRootPackage((String)rootPkg);
        } else {
            Log.warn((String)"Couldn't calculate the application root package!");
        }
    }

    public static void register(WebApp app) {
        WebAppGroup.main().register(app);
    }

    public static void unregister(WebApp app) {
        WebAppGroup.main().unregister(app);
    }
}

