/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.main;

import java.util.Map;
import org.rapidoid.app.AsyncAppHandler;
import org.rapidoid.config.Conf;
import org.rapidoid.data.YAML;
import org.rapidoid.http.Handler;
import org.rapidoid.io.Res;
import org.rapidoid.log.Log;
import org.rapidoid.plugins.Plugin;
import org.rapidoid.plugins.Plugins;
import org.rapidoid.util.U;
import org.rapidoid.webapp.AppMenu;
import org.rapidoid.webapp.RootWebApp;
import org.rapidoid.webapp.WebApp;
import org.rapidoid.webapp.WebAppGroup;

public class AppTool {
    public static WebApp createRootApp() {
        RootWebApp app = WebAppGroup.root();
        app.getRouter().generic((Handler)new AsyncAppHandler());
        AppTool.setupMenuConfig((WebApp)app);
        AppTool.setupAppConfig((WebApp)app);
        return app;
    }

    private static void setupAppConfig(final WebApp rootApp) {
        String appfile = "app.yaml";
        String firstAppFile = Conf.configPath() + "/" + appfile;
        String defaultAppFile = Conf.configPathDefault() + "/" + appfile;
        final Res confRes = Res.from((String)appfile, (boolean)true, (String[])new String[]{firstAppFile, defaultAppFile}).trackChanges();
        confRes.onChange("app tool", new Runnable(){

            @Override
            public void run() {
                if (confRes.exists()) {
                    String appYaml = confRes.getContent().trim();
                    Map conf = !U.isEmpty((String)appYaml) ? (Map)YAML.parse((String)appYaml, Map.class) : U.map();
                    Conf.reset();
                    rootApp.getConfig().clear();
                    for (Map.Entry e : conf.entrySet()) {
                        Plugin plugin;
                        String key = (String)e.getKey();
                        Object value = e.getValue();
                        Log.info((String)"Configuring", (String)key, value);
                        Conf.set((String)key, value);
                        rootApp.getConfig().put(key, value);
                        if (!(value instanceof Map) || (plugin = Plugins.get((String)key)) == null) continue;
                        Map pluginConfig = (Map)U.cast(value);
                        plugin.configure(pluginConfig);
                    }
                }
            }
        });
        confRes.exists();
    }

    private static void setupMenuConfig(final WebApp app) {
        String menufile = "menu.yaml";
        String firstMenuFile = Conf.configPath() + "/" + menufile;
        String defaultMenuFile = Conf.configPathDefault() + "/" + menufile;
        final Res menuRes = Res.from((String)menufile, (boolean)true, (String[])new String[]{firstMenuFile, defaultMenuFile}).trackChanges();
        menuRes.onChange("app tool", new Runnable(){

            @Override
            public void run() {
                if (menuRes.exists()) {
                    String menuYaml = menuRes.getContent().trim();
                    Object menuData = !U.isEmpty((String)menuYaml) ? YAML.parse((String)menuYaml, Object.class) : U.map();
                    AppMenu menu = AppMenu.from((Object)menuData);
                    app.setMenu(menu);
                }
            }
        });
        menuRes.exists();
    }
}

