/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.measure;

import org.rapidoid.measure.Measure;

public class StatsMeasure
implements Measure {
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private long sum = 0L;
    private long count = 0L;

    @Override
    public String get() {
        return this.count > 0L ? String.format("[%s..%s..%s]/%s", this.min, this.sum / this.count, this.max, this.count) : null;
    }

    @Override
    public void reset() {
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        this.sum = 0L;
        this.count = 0L;
    }

    public synchronized void add(long value) {
        if (this.min > value) {
            this.min = value;
        }
        if (this.max < value) {
            this.max = value;
        }
        ++this.count;
        this.sum += value;
    }
}

