/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.measure;

import java.util.HashMap;
import java.util.Map;
import org.rapidoid.measure.Measure;

public class Measures {
    private final Map<String, Measure> measures = new HashMap<String, Measure>();

    public synchronized <T extends Measure> T measure(String name, Class<T> clazz) {
        Measure m = this.measures.get(name);
        if (m == null) {
            try {
                m = (Measure)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Cannot create measure", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot create measure", e);
            }
            this.measures.put(name, m);
        }
        return (T)m;
    }

    public synchronized <T extends Measure> T measure(String name) {
        Measure m = this.measures.get(name);
        if (m == null) {
            throw new IllegalArgumentException("Cannot find measure: " + name);
        }
        return (T)m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String info() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Map<String, Measure> map = this.measures;
        synchronized (map) {
            for (Map.Entry<String, Measure> entry : this.measures.entrySet()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(entry.getKey());
                sb.append("=");
                Measure measure = entry.getValue();
                String val = measure.get();
                if (val == null) {
                    val = "N/A";
                }
                sb.append(val);
                measure.reset();
                first = false;
            }
        }
        return sb.toString();
    }

    public String get(String name) {
        return this.measure(name).get();
    }
}

