/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.measure;

import java.util.concurrent.atomic.AtomicInteger;
import org.rapidoid.measure.Measure;

public class PercentMeasure
implements Measure {
    private final AtomicInteger total = new AtomicInteger();
    private final AtomicInteger hits = new AtomicInteger();

    @Override
    public synchronized void reset() {
        this.total.set(0);
        this.hits.set(0);
    }

    @Override
    public synchronized String get() {
        int t = this.total.getAndSet(0);
        int h = this.hits.getAndSet(0) * 100;
        return t > 0 ? h / t + "%(" + t + ")" : null;
    }

    public void increment() {
        this.total.incrementAndGet();
    }

    public void hit() {
        this.hits.incrementAndGet();
    }
}

