/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.measure;

import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.measure.Measure;

public class StatsMeasure
implements Measure {
    private long min;
    private long max;
    private long sum = 0L;
    private long count = 0L;
    private final AtomicLong ticks = new AtomicLong();

    @Override
    public synchronized String get() {
        return this.count > 0L ? String.format("%s:[%s..%s..%s]#%s", this.sum, this.min, this.sum / this.count, this.max, this.count) : "" + this.ticks;
    }

    @Override
    public synchronized void reset() {
        this.min = 0L;
        this.max = 0L;
        this.sum = 0L;
        this.count = 0L;
        this.ticks.set(0L);
    }

    public void tick() {
        this.ticks.incrementAndGet();
    }

    public synchronized void value(long value) {
        if (this.count == 0L || this.min > value) {
            this.min = value;
        }
        if (this.count == 0L || this.max < value) {
            this.max = value;
        }
        ++this.count;
        this.sum += value;
    }

    public String toString() {
        return this.get();
    }
}

