/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.pages;

import java.util.Collection;
import java.util.List;
import org.rapidoid.html.Bootstrap;
import org.rapidoid.html.FieldType;
import org.rapidoid.html.FormLayout;
import org.rapidoid.html.Tag;
import org.rapidoid.html.tag.FormTag;
import org.rapidoid.html.tag.LiTag;
import org.rapidoid.html.tag.SpanTag;
import org.rapidoid.html.tag.TbodyTag;
import org.rapidoid.html.tag.TrTag;
import org.rapidoid.model.Item;
import org.rapidoid.model.Items;
import org.rapidoid.model.Model;
import org.rapidoid.model.Property;
import org.rapidoid.pages.HtmlWidgets;
import org.rapidoid.util.Cls;
import org.rapidoid.util.TypeKind;
import org.rapidoid.util.U;
import org.rapidoid.var.Var;

public abstract class BootstrapWidgets
extends Bootstrap {
    public static Object i18n(String multiLanguageText, Object ... formatArgs) {
        return HtmlWidgets.i18n(multiLanguageText, formatArgs);
    }

    public static <T> Var<T> property(Item item, String property) {
        return HtmlWidgets.property(item, property);
    }

    public static Tag<?> template(String templateFileName, Object ... namesAndValues) {
        return HtmlWidgets.template(templateFileName, namesAndValues);
    }

    public static Tag<?> hardcoded(String content) {
        return HtmlWidgets.hardcoded(content);
    }

    public static <T> Tag<?> grid(Class<T> type, Object[] items, int pageSize, String ... properties) {
        return BootstrapWidgets.grid(Model.beanItems(type, (Object[])items), pageSize, properties);
    }

    public static <T> Tag<?> grid(Class<T> type, Collection<T> items, int pageSize, String ... properties) {
        return BootstrapWidgets.grid(type, items.toArray(), pageSize, properties);
    }

    public static Tag<?> grid(Items items, int pageSize, String ... properties) {
        List props = items.properties(properties);
        Var pageNumber = BootstrapWidgets.var((Object)1);
        TrTag header = BootstrapWidgets.tr((Object[])new Object[0]);
        for (Property prop : props) {
            header = (TrTag)header.append(new Object[]{BootstrapWidgets.th((Object[])new Object[]{prop.caption()})});
        }
        Integer pageN = (Integer)pageNumber.get();
        Items page = items.range((pageN - 1) * pageSize, Math.min(pageN * pageSize, items.size()));
        TbodyTag body = BootstrapWidgets.tbody((Object[])new Object[0]);
        for (Item item : page) {
            TrTag row = BootstrapWidgets.itemRow(props, item);
            body = (TbodyTag)body.append(new Object[]{row});
        }
        int total = items.size();
        int pages = (int)Math.ceil((double)total / (double)pageSize);
        return BootstrapWidgets.rowFull((Object[])new Object[]{BootstrapWidgets.table_((Object[])new Object[]{BootstrapWidgets.thead((Object[])new Object[]{header}), body}), BootstrapWidgets.pager(1, pages, (Var<Integer>)pageNumber)});
    }

    protected static TrTag itemRow(List<Property> properties, Item item) {
        TrTag row = BootstrapWidgets.tr((Object[])new Object[0]);
        for (Property prop : properties) {
            row = (TrTag)row.append(new Object[]{BootstrapWidgets.td((Object[])new Object[]{U.or((Object)item.get(prop.name()), (Object)"")})});
        }
        return row;
    }

    public static Tag<?> pager(int from, int to, Var<Integer> pageNumber) {
        LiTag first = BootstrapWidgets.li((Object[])new Object[]{BootstrapWidgets.a((Object[])new Object[]{((SpanTag)BootstrapWidgets.span((Object[])new Object[]{LAQUO}).cmd("_set", new Object[]{pageNumber, from})).attr("aria-hidden", "true"), BootstrapWidgets.span((Object[])new Object[]{"First"}).class_("sr-only")})});
        LiTag prev = BootstrapWidgets.li((Object[])new Object[]{BootstrapWidgets.a((Object[])new Object[]{((SpanTag)BootstrapWidgets.span((Object[])new Object[]{LT}).cmd("_dec", new Object[]{pageNumber, 1})).attr("aria-hidden", "true"), BootstrapWidgets.span((Object[])new Object[]{"Previous"}).class_("sr-only")})});
        LiTag current = BootstrapWidgets.li((Object[])new Object[]{BootstrapWidgets.a((Object[])new Object[]{"Page ", pageNumber, " of " + to})});
        LiTag next = BootstrapWidgets.li((Object[])new Object[]{BootstrapWidgets.a((Object[])new Object[]{((SpanTag)BootstrapWidgets.span((Object[])new Object[]{GT}).cmd("_inc", new Object[]{pageNumber, 1})).attr("aria-hidden", "true"), BootstrapWidgets.span((Object[])new Object[]{"Next"}).class_("sr-only")})});
        LiTag last = BootstrapWidgets.li((Object[])new Object[]{BootstrapWidgets.a((Object[])new Object[]{((SpanTag)BootstrapWidgets.span((Object[])new Object[]{RAQUO}).cmd("_set", new Object[]{pageNumber, to})).attr("aria-hidden", "true"), BootstrapWidgets.span((Object[])new Object[]{"Last"}).class_("sr-only")})});
        return BootstrapWidgets.div((Object[])new Object[]{BootstrapWidgets.nav((Object[])new Object[]{BootstrapWidgets.ul((Object[])new Object[]{first, prev, current, next, last}).class_("pagination")})}).class_("pull-right");
    }

    public static FormTag edit(Object bean, Tag<?>[] buttons, String ... properties) {
        Item item = Model.item((Object)bean);
        return BootstrapWidgets.edit(item, buttons, properties);
    }

    public static FormTag edit(Item item, Tag<?>[] buttons, String ... properties) {
        List props = item.editableProperties(properties);
        int propN = props.size();
        String[] names = new String[propN];
        String[] desc = new String[propN];
        FieldType[] types = new FieldType[propN];
        Object[][] options = new Object[propN][];
        Var[] vars = new Var[propN];
        for (int i = 0; i < propN; ++i) {
            Property prop = (Property)props.get(i);
            names[i] = prop.name();
            desc[i] = prop.caption();
            types[i] = BootstrapWidgets.getPropertyFieldType(prop);
            options[i] = BootstrapWidgets.getPropertyOptions(prop);
            vars[i] = BootstrapWidgets.property(item, prop.name());
        }
        return BootstrapWidgets.form_((FormLayout)FormLayout.VERTICAL, (String[])names, (String[])desc, (FieldType[])types, (Object[][])options, (Var[])vars, (Object[])buttons);
    }

    protected static FieldType getPropertyFieldType(Property prop) {
        Class type = prop.type();
        if (type.isEnum()) {
            return type.getEnumConstants().length <= 3 ? FieldType.RADIOS : FieldType.DROPDOWN;
        }
        if (prop.name().toLowerCase().contains("email")) {
            return FieldType.EMAIL;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return FieldType.MULTI_SELECT;
        }
        if (Cls.kindOf((Class)type) == TypeKind.OBJECT) {
            return FieldType.DROPDOWN;
        }
        return FieldType.TEXT;
    }

    protected static Object[] getPropertyOptions(Property prop) {
        Class type = prop.type();
        if (type.isEnum()) {
            return type.getEnumConstants();
        }
        if (Cls.kindOf((Class)type) == TypeKind.OBJECT) {
            return new Object[0];
        }
        return null;
    }

    public static Tag<?> page(boolean devMode, String pageTitle, Object head, Object body) {
        String devOrProd = devMode ? "dev" : "prod";
        return BootstrapWidgets.template("bootstrap-page-" + devOrProd + ".html", "title", pageTitle, "head", head, "body", body);
    }

    public static Tag<?> page(boolean devMode, String pageTitle, Object body) {
        return BootstrapWidgets.page(devMode, pageTitle, "", body);
    }
}

