/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.pages.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.rapidoid.html.HTML;
import org.rapidoid.html.Tag;
import org.rapidoid.html.TagContext;
import org.rapidoid.html.TagProcessor;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.pages.impl.HardcodedTag;
import org.rapidoid.pages.impl.PageRenderer;
import org.rapidoid.util.U;

public class FileTemplateTag
extends HardcodedTag {
    private final String templateName;
    private final Object[] namesAndValues;

    public FileTemplateTag(String templateName, Object[] namesAndValues) {
        U.must((U.resource((String)templateName) != null || new File(templateName).exists() ? 1 : 0) != 0, (String)"Cannot find file: %s", (Object)templateName);
        this.templateName = templateName;
        this.namesAndValues = namesAndValues;
    }

    @Override
    public void render(TagContext ctx, HttpExchange x, PageRenderer renderer, OutputStream out) {
        String text = U.load((String)this.templateName);
        for (int i = 0; i < this.namesAndValues.length / 2; ++i) {
            String placeholder = (String)this.namesAndValues[i * 2];
            String value = renderer.toHTML(ctx, this.namesAndValues[i * 2 + 1], x);
            text = U.fillIn((String)text, (String)placeholder, (String)value);
        }
        try {
            out.write(text.getBytes());
        }
        catch (IOException e) {
            throw U.rte((String)"Cannot render template!", (Throwable)e);
        }
    }

    public Tag<?> copy() {
        return new FileTemplateTag(this.templateName, this.namesAndValues);
    }

    public void traverse(TagProcessor<Tag<?>> processor) {
        for (int i = 0; i < this.namesAndValues.length / 2; ++i) {
            Object val = this.namesAndValues[i * 2 + 1];
            HTML.traverse((Object)val, processor);
        }
    }

    @Override
    public String tagKind() {
        return "template";
    }
}

