/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.widget;

import java.util.List;
import org.rapidoid.html.Tag;
import org.rapidoid.html.tag.TdTag;
import org.rapidoid.model.Item;
import org.rapidoid.model.Items;
import org.rapidoid.model.Property;
import org.rapidoid.util.U;
import org.rapidoid.var.Var;
import org.rapidoid.widget.AbstractWidget;
import org.rapidoid.widget.PagerWidget;

public class GridWidget
extends AbstractWidget {
    private final Items items;
    private final String sortOrder;
    private final int pageSize;
    private final String[] properties;

    public GridWidget(Items items, String sortOrder, int pageSize, String ... properties) {
        this.items = items;
        this.sortOrder = sortOrder;
        this.pageSize = pageSize;
        this.properties = properties;
    }

    @Override
    protected Tag create() {
        List props = this.items.properties(this.properties);
        int total = this.items.size();
        int pages = (int)Math.ceil((double)total / (double)this.pageSize);
        boolean ordered = !U.isEmpty((String)this.sortOrder);
        Var<String> order = null;
        Items slice = this.items;
        String currentOrder = this.sortOrder;
        if (ordered) {
            order = GridWidget.localVar("_order_" + this.items.uri(), this.sortOrder);
            currentOrder = (String)order.get();
            slice = slice.orderedBy(currentOrder);
        }
        boolean paging = this.pageSize > 0;
        Var<Integer> pageNumber = null;
        if (paging) {
            pageNumber = GridWidget.localVar("_page_" + this.items.uri(), 1, 1, pages);
            slice = this.getPage(slice, (Integer)pageNumber.get());
        }
        Tag header = this.tableHeader(props, order);
        Tag body = this.tableBody(props, slice);
        PagerWidget pager = paging ? GridWidget.pager(1, pages, pageNumber) : this.noPager();
        return this.fullTable(header, body, pager);
    }

    protected PagerWidget noPager() {
        return null;
    }

    protected Tag fullTable(Tag header, Tag body, PagerWidget pager) {
        return GridWidget.row(new Object[]{GridWidget.table_(GridWidget.thead((Object[])new Object[]{header}), body), pager});
    }

    protected Items getPage(Items items, Integer pageN) {
        int pageFrom = Math.max((pageN - 1) * this.pageSize, 0);
        int pageTo = Math.min(pageN * this.pageSize, items.size());
        Items pageOrAll = items.range(pageFrom, pageTo);
        return pageOrAll;
    }

    protected Tag tableBody(List<Property> props, Items pageOrAll) {
        Tag body = GridWidget.tbody((Object[])new Object[0]);
        for (Item item : pageOrAll) {
            Tag row = this.itemRow(props, item);
            body = body.append(new Object[]{row});
        }
        return body;
    }

    protected Tag tableHeader(List<Property> props, Var<String> order) {
        Tag header = GridWidget.tr((Object[])new Object[0]);
        for (Property prop : props) {
            Object sort;
            Tag sortIcon = null;
            if (order != null) {
                String currentOrder = (String)order.get();
                if (currentOrder.equals(prop.name())) {
                    sortIcon = GridWidget.glyphicon("chevron-down");
                }
                if (order != null && currentOrder.equals("-" + prop.name())) {
                    sortIcon = GridWidget.glyphicon("chevron-up");
                }
                sort = GridWidget.a_void((Object[])new Object[]{prop.caption(), " ", sortIcon}).cmd("_sort", new Object[]{order, prop.name()});
            } else {
                sort = prop.caption();
            }
            header = header.append(new Object[]{GridWidget.th((Object[])new Object[]{sort})});
        }
        return header;
    }

    protected Tag itemRow(List<Property> properties, Item item) {
        Tag row = GridWidget.tr((Object[])new Object[0]);
        for (Property prop : properties) {
            Object value = item.get(prop.name());
            value = U.or((Object)value, (Object)"");
            row = row.append(new Object[]{this.cell(GridWidget.display(value))});
        }
        String js = this.onClickScript(item);
        row = row.onclick(js).class_("pointer");
        return row;
    }

    protected String onClickScript(Item item) {
        String js = U.format((String)"goAt('%s');", (Object[])new Object[]{GridWidget.urlFor(item.value())});
        return js;
    }

    protected TdTag cell(Object value) {
        return GridWidget.td((Object[])new Object[]{value});
    }
}

