/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.widget;

import org.rapidoid.html.Tag;
import org.rapidoid.var.Var;
import org.rapidoid.widget.AbstractWidget;

public class PagerWidget
extends AbstractWidget {
    private int from;
    private int to;
    private Var<Integer> pageNumber;

    public PagerWidget(int from, int to, Var<Integer> pageNumber) {
        this.from = from;
        this.to = to;
        this.pageNumber = pageNumber;
    }

    @Override
    protected Tag create() {
        Tag first = this.first().navigate("_set", new Object[]{this.pageNumber, this.from});
        Tag prev = this.prev().navigate("_dec", new Object[]{this.pageNumber, 1});
        Tag current = this.current();
        Tag next = this.next().navigate("_inc", new Object[]{this.pageNumber, 1});
        Tag last = this.last().navigate("_set", new Object[]{this.pageNumber, this.to});
        return this.pagination(first, prev, current, next, last);
    }

    protected Tag pagination(Tag first, Tag prev, Tag current, Tag next, Tag last) {
        int pageN = this.pageNumber();
        Tag firstLi = pageN > this.from ? PagerWidget.li((Object[])new Object[]{first}) : PagerWidget.li((Object[])new Object[]{first.cmd(null, new Object[0])}).class_("disabled");
        Tag prevLi = pageN > this.from ? PagerWidget.li((Object[])new Object[]{prev}) : PagerWidget.li((Object[])new Object[]{prev.cmd(null, new Object[0])}).class_("disabled");
        Tag currentLi = PagerWidget.li((Object[])new Object[]{current});
        Tag nextLi = pageN < this.to ? PagerWidget.li((Object[])new Object[]{next}) : PagerWidget.li((Object[])new Object[]{next.cmd(null, new Object[0])}).class_("disabled");
        Tag lastLi = pageN < this.to ? PagerWidget.li((Object[])new Object[]{last}) : PagerWidget.li((Object[])new Object[]{last.cmd(null, new Object[0])}).class_("disabled");
        Tag pagination = PagerWidget.nav((Object[])new Object[]{PagerWidget.ul_li((Object[])new Object[]{firstLi, prevLi, currentLi, nextLi, lastLi}).class_("pagination")});
        return PagerWidget.div((Object[])new Object[]{pagination}).class_("pull-right");
    }

    protected int pageNumber() {
        return (Integer)this.pageNumber.get();
    }

    protected Tag first() {
        Tag firstIcon = PagerWidget.span((Object[])new Object[]{LAQUO}).attr("aria-hidden", "true");
        return PagerWidget.a_void((Object[])new Object[]{firstIcon, PagerWidget.span((Object[])new Object[]{"First"}).class_("sr-only")});
    }

    protected Tag prev() {
        Tag prevIcon = PagerWidget.span((Object[])new Object[]{LT}).attr("aria-hidden", "true");
        return PagerWidget.a_void((Object[])new Object[]{prevIcon, PagerWidget.span((Object[])new Object[]{"Previous"}).class_("sr-only")});
    }

    protected Tag current() {
        return PagerWidget.a_void((Object[])new Object[]{"Page ", this.pageNumber(), " of " + this.to});
    }

    protected Tag next() {
        Tag nextIcon = PagerWidget.span((Object[])new Object[]{GT}).attr("aria-hidden", "true");
        return PagerWidget.a_void((Object[])new Object[]{nextIcon, PagerWidget.span((Object[])new Object[]{"Next"}).class_("sr-only")});
    }

    protected Tag last() {
        Tag lastIcon = PagerWidget.span((Object[])new Object[]{RAQUO}).attr("aria-hidden", "true");
        return PagerWidget.a_void((Object[])new Object[]{lastIcon, PagerWidget.span((Object[])new Object[]{"Last"}).class_("sr-only")});
    }
}

