package org.rapidoid.pages;

/*
 * #%L
 * rapidoid-pages
 * %%
 * Copyright (C) 2014 - 2015 Nikolche Mihajlovski
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.util.Map;

import org.rapidoid.annotation.Authors;
import org.rapidoid.annotation.Since;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.util.Cls;
import org.rapidoid.util.Scan;

@Authors("Nikolche Mihajlovski")
@Since("2.0.0")
public class PageHandler implements Handler {

	@Override
	public Object handle(HttpExchange x) throws Exception {

		Map<String, Class<?>> pages = Cls.classMap(Scan.bySuffix("Page", null, null));

		Object result = Pages.dispatch(x, null, pages);

		return result != null ? result : x.notFound();
	}

}
