/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.widget;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import org.rapidoid.annotation.Optional;
import org.rapidoid.annotation.Programmatic;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Metadata;
import org.rapidoid.html.FieldType;
import org.rapidoid.html.FormLayout;
import org.rapidoid.html.Tag;
import org.rapidoid.html.tag.InputTag;
import org.rapidoid.html.tag.TextareaTag;
import org.rapidoid.model.Item;
import org.rapidoid.model.Property;
import org.rapidoid.security.DataPermissions;
import org.rapidoid.util.Cls;
import org.rapidoid.util.TypeKind;
import org.rapidoid.util.U;
import org.rapidoid.var.Var;
import org.rapidoid.var.Vars;
import org.rapidoid.widget.AbstractWidget;
import org.rapidoid.widget.DataManager;
import org.rapidoid.widget.FormMode;

public class FormFieldWidget
extends AbstractWidget {
    protected DataManager dataManager;
    protected FormMode mode;
    protected Property prop;
    protected FormLayout layout = FormLayout.VERTICAL;
    protected String name;
    protected String desc;
    protected FieldType type;
    protected Collection<?> options;
    protected boolean required;
    protected Var<?> var;
    protected DataPermissions permissions;
    protected Tag content;
    protected Tag label;
    protected Tag input;

    public FormFieldWidget(DataManager dataManager, FormMode mode, FormLayout layout, Property prop, String name, String desc, FieldType type, Collection<?> options, boolean required, Var<?> var, DataPermissions permissions) {
        this.dataManager = dataManager;
        this.mode = (FormMode)((Object)U.or((Object)((Object)mode), (Object)((Object)FormMode.EDIT)));
        this.layout = layout;
        this.prop = prop;
        this.name = name;
        this.desc = (String)U.or((Object)desc, (Object)name);
        this.type = type;
        this.options = options;
        this.required = required;
        this.var = var;
        this.permissions = permissions;
    }

    public FormFieldWidget(DataManager dataManager, FormMode mode, FormLayout layout, Item item, Property prop) {
        this.dataManager = dataManager;
        this.mode = (FormMode)((Object)U.or((Object)((Object)mode), (Object)((Object)FormMode.EDIT)));
        this.layout = layout;
        this.prop = prop;
        this.name = prop.name();
        this.desc = (String)U.or((Object)prop.caption(), (Object)this.name);
        this.type = mode != FormMode.SHOW ? this.getPropertyFieldType(prop) : FieldType.LABEL;
        this.options = this.getPropertyOptions(prop);
        this.required = Metadata.get((Annotation[])prop.annotations(), Optional.class) == null;
        this.var = FormFieldWidget.property(item, prop.name());
    }

    protected String formLayoutClass(FormLayout layout) {
        switch (layout) {
            case VERTICAL: {
                return "";
            }
            case HORIZONTAL: {
                return "form-horizontal";
            }
            case INLINE: {
                return "form-inline";
            }
        }
        throw U.notExpected();
    }

    protected Tag field(String name, String desc, FieldType type, Collection<?> options, Var<?> var) {
        Tag inputWrap;
        desc = (String)U.or((Object)desc, (Object)name) + ": ";
        Tag inp = this.input == null ? this.input_(name, desc, type, options, var) : this.input;
        Object lbl = this.label;
        if (type == FieldType.RADIOS || type == FieldType.CHECKBOXES) {
            Tag tag = inp = this.layout == FormLayout.VERTICAL ? FormFieldWidget.div((Object[])new Object[]{inp}) : FormFieldWidget.span((Object[])new Object[]{inp});
        }
        if (type == FieldType.CHECKBOX) {
            if (this.label == null) {
                lbl = null;
            }
            inp = FormFieldWidget.div((Object[])new Object[]{FormFieldWidget.label((Object[])new Object[]{inp, desc})}).class_("checkbox");
            inputWrap = this.layout == FormLayout.HORIZONTAL ? FormFieldWidget.div((Object[])new Object[]{inp}).class_("col-sm-offset-4 col-sm-8") : inp;
        } else {
            if (this.label == null) {
                lbl = this.layout != FormLayout.INLINE ? FormFieldWidget.label((Object[])new Object[]{desc}) : (type == FieldType.RADIOS ? FormFieldWidget.label((Object[])new Object[]{desc}) : null);
            }
            if (this.layout == FormLayout.HORIZONTAL) {
                lbl = lbl.class_("col-sm-4 control-label");
            }
            inputWrap = this.layout == FormLayout.HORIZONTAL ? FormFieldWidget.div((Object[])new Object[]{inp}).class_("col-sm-8") : inp;
        }
        Tag err = FormFieldWidget.span((Object[])new Object[]{""}).class_("field-error");
        Tag group = lbl != null ? FormFieldWidget.div((Object[])new Object[]{lbl, inputWrap, err}) : FormFieldWidget.div((Object[])new Object[]{inputWrap, err});
        group = group.class_("form-group");
        return group;
    }

    protected Object input_(String name, String desc, FieldType type, Collection<?> options, Var<?> var) {
        switch (type) {
            case TEXT: {
                return this.textInput(name, desc, var);
            }
            case PASSWORD: {
                return this.passwordInput(name, desc, var);
            }
            case EMAIL: {
                return this.emailInput(name, desc, var);
            }
            case TEXTAREA: {
                return this.textareaInput(name, desc, var);
            }
            case CHECKBOX: {
                return this.checkboxInput(name, var);
            }
            case DROPDOWN: {
                return this.dropdownInput(name, options, var);
            }
            case MULTI_SELECT: {
                return this.multiSelectInput(name, options, var);
            }
            case RADIOS: {
                return this.radiosInput(name, options, var);
            }
            case CHECKBOXES: {
                return this.checkboxesInput(name, options, var);
            }
            case LABEL: {
                return this.readonly(var);
            }
        }
        throw U.notExpected();
    }

    protected Tag readonly(Object item) {
        Object display = FormFieldWidget.display(item);
        if (display instanceof Tag) {
            return (Tag)display;
        }
        return FormFieldWidget.span((Object[])new Object[]{display}).class_("display-wrap");
    }

    protected Object checkboxesInput(String name, Collection<?> options, Var<?> var) {
        return FormFieldWidget.checkboxes(name, options, var);
    }

    protected Object radiosInput(String name, Collection<?> options, Var<?> var) {
        return FormFieldWidget.radios(name, options, var);
    }

    protected Object multiSelectInput(String name, Collection<?> options, Var<?> var) {
        return FormFieldWidget.multiSelect(options, var).name(name);
    }

    protected Object dropdownInput(String name, Collection<?> options, Var<?> var) {
        return FormFieldWidget.dropdown(options, var).name(name);
    }

    protected Object checkboxInput(String name, Var<?> var) {
        return FormFieldWidget.checkbox(var).name(name);
    }

    protected Object textareaInput(String name, String desc, Var<?> var) {
        TextareaTag textarea = FormFieldWidget.textareaInput(var).name(name);
        textarea = this.layout == FormLayout.INLINE ? textarea.placeholder(desc) : textarea;
        return textarea;
    }

    protected Object emailInput(String name, String desc, Var<?> var) {
        InputTag input = FormFieldWidget.emailInput(var).name(name);
        input = this.layout == FormLayout.INLINE ? input.placeholder(desc) : input;
        return input;
    }

    protected Object passwordInput(String name, String desc, Var<?> var) {
        InputTag input = FormFieldWidget.passwordInput(var).name(name);
        input = this.layout == FormLayout.INLINE ? input.placeholder(desc) : input;
        return input;
    }

    protected Object textInput(String name, String desc, Var<?> var) {
        InputTag input = FormFieldWidget.textInput(var).name(name);
        input = this.layout == FormLayout.INLINE ? input.placeholder(desc) : input;
        return input;
    }

    @Override
    protected Tag create() {
        if (this.content != null) {
            return this.content;
        }
        if (this.isFieldProgrammatic() && this.mode != FormMode.SHOW) {
            return null;
        }
        if (this.mode != FormMode.SHOW && this.required) {
            this.var = Vars.mandatory(this.var);
        }
        return this.field(this.name, this.desc, this.type, this.options, this.var);
    }

    protected boolean isFieldProgrammatic() {
        return this.prop != null && Metadata.get((Annotation[])this.prop.annotations(), Programmatic.class) != null;
    }

    protected boolean isFieldAllowed() {
        switch (this.fieldMode()) {
            case CREATE: {
                return this.permissions.insert;
            }
            case EDIT: {
                return this.permissions.read && this.permissions.change;
            }
            case SHOW: {
                return this.permissions.read;
            }
        }
        throw U.notExpected();
    }

    protected FormMode fieldMode() {
        return this.type != FieldType.LABEL ? this.mode : FormMode.SHOW;
    }

    protected FieldType getPropertyFieldType(Property prop) {
        Class type = prop.type();
        if (type == Boolean.class || type == Boolean.TYPE) {
            return FieldType.CHECKBOX;
        }
        if (type.isEnum()) {
            return type.getEnumConstants().length <= 3 ? FieldType.RADIOS : FieldType.DROPDOWN;
        }
        if (prop.name().toLowerCase().contains("email")) {
            return FieldType.EMAIL;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return FieldType.MULTI_SELECT;
        }
        if (Cls.kindOf((Class)type) == TypeKind.OBJECT) {
            return FieldType.DROPDOWN;
        }
        return FieldType.TEXT;
    }

    protected Collection<?> getPropertyOptions(Property prop) {
        Class type = prop.type();
        if (type.isEnum()) {
            return U.list((Object[])type.getEnumConstants());
        }
        if (Collection.class.isAssignableFrom(type)) {
            return this.getCollectionPropertyOptions(prop);
        }
        if (Cls.kindOf((Class)type) == TypeKind.OBJECT) {
            return Collections.EMPTY_LIST;
        }
        return null;
    }

    protected Collection<?> getCollectionPropertyOptions(Property prop) {
        return this.propertyOptions(prop);
    }

    protected Collection<?> propertyOptions(Property prop) {
        if (prop.genericType() != null) {
            Type[] typeArgs = prop.genericType().getActualTypeArguments();
            return typeArgs.length == 1 ? this.getOptionsOfType(Cls.clazz((Type)typeArgs[0])) : Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }

    protected Collection<?> getOptionsOfType(Class<?> clazz) {
        if (Cls.kindOf(clazz) == TypeKind.OBJECT && Beany.hasProperty(clazz, (String)"id")) {
            return this.dataManager != null ? this.dataManager.getAll(clazz) : Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }

    public FormMode getMode() {
        return this.mode;
    }

    public void setMode(FormMode mode) {
        this.mode = mode;
    }

    public Property getProp() {
        return this.prop;
    }

    public void setProp(Property prop) {
        this.prop = prop;
    }

    public FormLayout getLayout() {
        return this.layout;
    }

    public void setLayout(FormLayout layout) {
        this.layout = layout;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public FieldType getType() {
        return this.type;
    }

    public void setType(FieldType type) {
        this.type = type;
    }

    public Collection<?> getOptions() {
        return this.options;
    }

    public void setOptions(Collection<?> options) {
        this.options = options;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public Var<?> getVar() {
        return this.var;
    }

    public void setVar(Var<?> var) {
        this.var = var;
    }

    public DataPermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(DataPermissions permissions) {
        this.permissions = permissions;
    }

    public Tag getContent() {
        return this.content;
    }

    public void setContent(Tag content) {
        this.content = content;
    }

    public Tag getLabel() {
        return this.label;
    }

    public void setLabel(Tag label) {
        this.label = label;
    }

    public Tag getInput() {
        return this.input;
    }

    public void setInput(Tag input) {
        this.input = input;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public void setDataManager(DataManager dataManager) {
        this.dataManager = dataManager;
    }
}

