/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.widget;

import java.util.Collection;
import java.util.List;
import org.rapidoid.html.FieldType;
import org.rapidoid.html.FormLayout;
import org.rapidoid.html.Tag;
import org.rapidoid.html.tag.ButtonTag;
import org.rapidoid.html.tag.FormTag;
import org.rapidoid.model.Item;
import org.rapidoid.model.Property;
import org.rapidoid.security.Secure;
import org.rapidoid.util.Cls;
import org.rapidoid.util.U;
import org.rapidoid.util.UTILS;
import org.rapidoid.var.Var;
import org.rapidoid.widget.AbstractWidget;
import org.rapidoid.widget.DataManager;
import org.rapidoid.widget.FormFieldWidget;
import org.rapidoid.widget.FormMode;

public class FormWidget
extends AbstractWidget {
    protected final DataManager dataManager;
    protected final Item item;
    protected final FormMode mode;
    protected List<Property> props;
    protected List<FormFieldWidget> fields = U.list((Object[])new Object[0]);
    protected List<Tag> buttons;
    protected FormLayout layout = FormLayout.VERTICAL;
    protected boolean hasFields = false;

    public FormWidget(DataManager dataManager, FormMode mode, Item item, String ... properties) {
        this.dataManager = dataManager;
        this.mode = mode;
        this.item = item;
        this.init(item, properties);
    }

    public FormWidget(DataManager dataManager, FormMode mode, FormLayout layout, String[] fieldNames, String[] fieldLabels, FieldType[] fieldTypes, Collection<?>[] options, Var<?>[] vars, Tag[] buttons) {
        this.dataManager = dataManager;
        this.mode = mode;
        this.item = null;
        this.layout = layout;
        for (int i = 0; i < fieldNames.length; ++i) {
            this.fields.add(new FormFieldWidget(dataManager, mode, layout, null, fieldNames[i], fieldLabels[i], fieldTypes[i], options[i], true, vars[i], null));
        }
        this.buttons = UTILS.withoutNulls((Object[])buttons);
    }

    public int fieldIndex(String fieldName) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!U.eq((Object)this.fields.get((int)i).name, (Object)fieldName)) continue;
            return i;
        }
        throw U.rte((String)"Cannot find field '%s'!", (Object[])new Object[]{fieldName});
    }

    public FormWidget field(String fieldName, FormFieldWidget field) {
        return this.field(this.fieldIndex(fieldName), field);
    }

    public FormWidget field(int fieldIndex, FormFieldWidget field) {
        this.fields.set(fieldIndex, field);
        return this;
    }

    public FormFieldWidget field(String fieldName) {
        return this.field(this.fieldIndex(fieldName));
    }

    public FormFieldWidget field(int fieldIndex) {
        return this.fields.get(fieldIndex);
    }

    public FormWidget buttons(ButtonTag ... buttons) {
        this.buttons = UTILS.withoutNulls((Object[])buttons);
        return this;
    }

    public List<Tag> buttons() {
        return this.buttons;
    }

    public FormWidget add(FormFieldWidget field) {
        if (field.getMode() == null) {
            field.setMode(this.mode);
        }
        if (field.getLayout() == null) {
            field.setLayout(this.layout);
        }
        this.fields.add(field);
        return this;
    }

    protected void init(Item item, String ... properties) {
        this.props = this.editable() ? item.editableProperties(properties) : item.readableProperties(properties);
        int propN = this.props.size();
        for (int i = 0; i < propN; ++i) {
            Property prop = this.props.get(i);
            FormFieldWidget field = FormWidget.field(this.dataManager, this.mode, this.layout, item, prop);
            this.fields.add(field);
        }
    }

    protected boolean editable() {
        return this.mode != FormMode.SHOW;
    }

    protected void initPermissions() {
        if (this.item != null) {
            Object target = this.item.value();
            Class targetClass = Cls.of((Object)target);
            for (FormFieldWidget field : this.fields) {
                if (field.permissions != null) continue;
                field.permissions = Secure.getPropertyPermissions((String)Secure.username(), (Class)targetClass, (Object)target, (String)field.name);
            }
        }
    }

    protected FormTag create() {
        this.initPermissions();
        FormTag form = this.emptyForm();
        form = this.addFormFields(form);
        form = (FormTag)form.append(new Object[]{this.formButtons()});
        return form;
    }

    protected FormTag addFormFields(FormTag form) {
        for (int i = 0; i < this.fields.size(); ++i) {
            FormFieldWidget field = this.getField(i);
            if (field == null) continue;
            form = (FormTag)form.append(new Object[]{field});
            this.hasFields = true;
        }
        if (!this.hasFields) {
            form = (FormTag)form.append(new Object[]{this.noFormFields()});
        }
        return form;
    }

    protected Tag noFormFields() {
        return FormWidget.h4((Object[])new Object[]{"Insufficient permissions!"});
    }

    protected FormFieldWidget getField(int index) {
        FormFieldWidget field = this.fields.get(index);
        if (field != null) {
            return field.isFieldAllowed() ? field : null;
        }
        return null;
    }

    protected FormTag emptyForm() {
        return (FormTag)((FormTag)FormWidget.form((Object[])new Object[0]).class_(this.formLayoutClass(this.layout))).role("form");
    }

    protected Tag formButtons() {
        Tag btns = this.layout == FormLayout.HORIZONTAL ? FormWidget.div((Object[])new Object[0]).class_("col-sm-offset-4 col-sm-8") : FormWidget.div((Object[])new Object[0]).class_("form-group");
        if (this.buttons != null && this.hasFields) {
            for (Tag btn : this.buttons) {
                btns = btns.append(new Object[]{btn});
            }
        }
        if (this.layout == FormLayout.HORIZONTAL) {
            return FormWidget.div((Object[])new Object[]{btns}).class_("form-group");
        }
        return btns;
    }

    protected String formLayoutClass(FormLayout layout) {
        switch (layout) {
            case VERTICAL: {
                return "";
            }
            case HORIZONTAL: {
                return "form-horizontal";
            }
            case INLINE: {
                return "form-inline";
            }
        }
        throw U.notExpected();
    }
}

