/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.pages;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.rapidoid.beany.Beany;
import org.rapidoid.config.Conf;
import org.rapidoid.html.Cmd;
import org.rapidoid.html.TagContext;
import org.rapidoid.html.Tags;
import org.rapidoid.http.HTTPServer;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.HttpNotFoundException;
import org.rapidoid.http.HttpSuccessException;
import org.rapidoid.inject.IoC;
import org.rapidoid.json.JSON;
import org.rapidoid.lambda.Lambdas;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.log.Log;
import org.rapidoid.pages.PageGUI;
import org.rapidoid.pages.PageHandler;
import org.rapidoid.pages.impl.BuiltInCmdHandler;
import org.rapidoid.pages.impl.ComplexView;
import org.rapidoid.pages.impl.PageRenderer;
import org.rapidoid.pojo.PojoDispatchException;
import org.rapidoid.pojo.PojoHandlerNotFoundException;
import org.rapidoid.pojo.PojoRequest;
import org.rapidoid.rest.WebPojoDispatcher;
import org.rapidoid.rest.WebReq;
import org.rapidoid.util.Arr;
import org.rapidoid.util.Cls;
import org.rapidoid.util.U;
import org.rapidoid.util.UTILS;

public class Pages {
    private static final String PAGE_RELOAD = "<h2>Reloading...</h2><script>location.reload();</script>";
    public static final String SESSION_CTX = "_ctx_";
    private static final BuiltInCmdHandler BUILT_IN_HANDLER = new BuiltInCmdHandler();

    public static void registerPages(HTTPServer server) {
        server.serve((Handler)new PageHandler());
    }

    protected static Map<Integer, Object> inputs(HttpExchange x) {
        String inputs = x.data("inputs");
        U.notNull((Object)inputs, (String)"inputs", (Object[])new Object[0]);
        Map inputsMap = U.map();
        Map inp = (Map)JSON.parse((String)inputs, Map.class);
        for (Map.Entry e : inp.entrySet()) {
            inputsMap.put(U.num((String)((String)e.getKey())), e.getValue());
        }
        return inputsMap;
    }

    public static String pageName(HttpExchange x) {
        String path = x.path();
        if (path.endsWith(".html")) {
            path = U.mid((String)path, (int)0, (int)-5);
        }
        if (path.equals("/")) {
            path = "/index";
        }
        return U.capitalized((String)path.substring(1));
    }

    public static String defaultPageTitle(Class<?> pageClass) {
        String pageName = pageClass.getSimpleName();
        if (pageName.endsWith("Page")) {
            pageName = U.mid((String)pageName, (int)0, (int)-4);
        }
        return UTILS.camelPhrase((String)pageName);
    }

    public static String titleOf(HttpExchange x, Object target) {
        Method m = Cls.findMethod(target.getClass(), (String)"title", (Class[])new Class[]{HttpExchange.class});
        if (m != null) {
            return (String)Cls.invoke((Method)m, (Object)target, (Object[])new Object[]{x});
        }
        try {
            return (String)Beany.getPropValue((Object)target, (String)"title");
        }
        catch (Exception e) {
            return Pages.defaultPageTitle(target.getClass());
        }
    }

    public static Object contentOf(HttpExchange x, Object target) {
        Method m = Cls.findMethod(target.getClass(), (String)"content", (Class[])new Class[]{HttpExchange.class});
        return m != null ? Cls.invoke((Method)m, (Object)target, (Object[])new Object[]{x}) : Beany.getPropValue((Object)target, (String)"content", null);
    }

    public static Object headOf(HttpExchange x, Object target) {
        Method m = Cls.findMethod(target.getClass(), (String)"head", (Class[])new Class[]{HttpExchange.class});
        return m != null ? Cls.invoke((Method)m, (Object)target, (Object[])new Object[]{x}) : Beany.getPropValue((Object)target, (String)"head", null);
    }

    public static Object page(HttpExchange x, Object page) {
        String pageTitle = Pages.titleOf(x, page);
        Object pageHead = U.or((Object)Pages.headOf(x, page), (Object)"");
        Object content = Pages.contentOf(x, page);
        if (content == null) {
            return null;
        }
        if (content instanceof HttpExchange) {
            U.must((x == content ? 1 : 0) != 0, (String)"Different HTTP exchange than expected!");
            return x;
        }
        return PageGUI.page(Conf.dev(), pageTitle, pageHead, content);
    }

    public static Object render(HttpExchange x, Object page) {
        Object fullPage = Pages.page(x, page);
        if (fullPage != null) {
            if (fullPage instanceof HttpExchange) {
                return x;
            }
            TagContext ctx = Tags.context();
            x.sessionSet(SESSION_CTX, (Object)ctx);
            PageRenderer.get().render(ctx, fullPage, x);
            return x;
        }
        throw x.notFound();
    }

    public static Object dispatch(HttpExchange x, WebPojoDispatcher serviceDispatcher, Map<String, Class<?>> pages) {
        String pageName;
        if (x.serveStatic()) {
            return x;
        }
        if (serviceDispatcher != null) {
            try {
                return serviceDispatcher.dispatch((PojoRequest)new WebReq(x));
            }
            catch (PojoHandlerNotFoundException pojoHandlerNotFoundException) {
            }
            catch (PojoDispatchException e) {
                return x.errorResponse((Throwable)e);
            }
        }
        if ((pageName = Pages.pageName(x)) == null) {
            return null;
        }
        String pageClassName = U.capitalized((String)pageName) + "Page";
        Class<?> pageClass = pages.get(pageClassName);
        if (pageClass == null) {
            return null;
        }
        Object page = Cls.newInstance(pageClass);
        if (Pages.isEmiting(x)) {
            return Pages.emit(x, page);
        }
        return Pages.serve(x, page);
    }

    public static boolean isEmiting(HttpExchange x) {
        return x.isPostReq();
    }

    public static Object serve(HttpExchange x, Object view) {
        Pages.load(x, view);
        Pages.store(x, view);
        Object result = Pages.render(x, view);
        x.addToPageStack();
        Pages.store(x, view);
        return result;
    }

    public static void load(HttpExchange x, Object target) {
        Mapper sessionMapper = Lambdas.mapper((Map)x.session());
        IoC.autowire((Object)target, (Mapper)sessionMapper);
        if (target instanceof ComplexView) {
            ComplexView complex = (ComplexView)target;
            for (Object subview : complex.getSubViews()) {
                IoC.autowire((Object)subview, (Mapper)sessionMapper);
            }
        }
    }

    public static void store(HttpExchange x, Object target) {
        Pages.storeFrom(x, target);
        if (target instanceof ComplexView) {
            ComplexView complex = (ComplexView)target;
            for (Object subview : complex.getSubViews()) {
                Pages.storeFrom(x, subview);
            }
        }
    }

    private static void storeFrom(HttpExchange x, Object target) {
        for (Field field : IoC.getSessionFields((Object)target)) {
            Object value = Cls.getFieldValue((Field)field, (Object)target);
            x.sessionSet(field.getName(), value);
        }
    }

    public static Object emit(HttpExchange x, Object view) {
        String html;
        int event = U.num((String)x.data("event"));
        TagContext ctx = (TagContext)x.session(SESSION_CTX, null);
        if (ctx == null) {
            return Pages.changes(x, PAGE_RELOAD);
        }
        Cmd cmd = ctx.getEventCmd(event);
        boolean navigational = cmd != null && cmd.navigational;
        Pages.load(x, view);
        if (!navigational) {
            Map errors = U.map();
            if (cmd != null) {
                Map<Integer, Object> inputs = Pages.inputs(x);
                ctx.emitValues(inputs, errors);
            } else {
                Log.warn((String)"Invalid event!", (String)"event", (Object)event);
            }
            if (!errors.isEmpty()) {
                x.json();
                return U.map((Object)"!errors", (Object)errors);
            }
        }
        Pages.store(x, view);
        Pages.load(x, view);
        boolean processView = true;
        if (cmd != null) {
            try {
                Pages.callCmdHandler(x, view, cmd);
            }
            catch (Exception e) {
                Throwable cause = UTILS.rootCause((Throwable)e);
                if (cause instanceof HttpSuccessException || cause instanceof HttpNotFoundException) {
                    processView = false;
                }
                throw U.rte((Throwable)e);
            }
        }
        Pages.store(x, view);
        Pages.load(x, view);
        if (processView) {
            Object content;
            try {
                content = Pages.contentOf(x, view);
                if (content == null || content instanceof HttpExchange) {
                    return content;
                }
            }
            catch (Exception e) {
                Throwable cause = UTILS.rootCause((Throwable)e);
                if (cause instanceof HttpSuccessException || cause instanceof HttpNotFoundException) {
                    return null;
                }
                throw U.rte((Throwable)e);
            }
            ctx = Tags.context();
            x.sessionSet(SESSION_CTX, (Object)ctx);
            html = PageRenderer.get().toHTML(ctx, content, x);
        } else {
            html = "Error!";
        }
        Pages.store(x, view);
        Pages.load(x, view);
        if (x.redirectUrl() != null) {
            x.startResponse(200);
            x.json();
            return U.map((Object)"_redirect_", (Object)x.redirectUrl());
        }
        return Pages.changes(x, html);
    }

    private static Object changes(HttpExchange x, String html) {
        x.json();
        return U.map((Object)"body", (Object)html);
    }

    public static void callCmdHandler(HttpExchange x, Object target, Cmd cmd) {
        if (!Pages.callCmdHandler(x, target, cmd, false)) {
            Pages.callCmdHandler(x, BUILT_IN_HANDLER, cmd, false);
        }
    }

    private static boolean callCmdHandler(HttpExchange x, Object target, Cmd cmd, boolean failIfNotFound) {
        String handlerName = "on" + U.capitalized((String)cmd.name);
        Method m = Cls.findMethodByArgs(target.getClass(), (String)handlerName, (Object[])cmd.args);
        if (m != null) {
            Cls.invoke((Method)m, (Object)target, (Object[])cmd.args);
            return true;
        }
        Object[] args2 = Arr.expand((Object[])cmd.args, (Object)x);
        m = Cls.findMethodByArgs(target.getClass(), (String)handlerName, (Object[])args2);
        if (m != null) {
            Cls.invoke((Method)m, (Object)target, (Object[])args2);
            return true;
        }
        args2 = new Object[cmd.args.length + 1];
        args2[0] = x;
        System.arraycopy(cmd.args, 0, args2, 1, cmd.args.length);
        m = Cls.findMethodByArgs(target.getClass(), (String)handlerName, (Object[])args2);
        if (m != null) {
            Cls.invoke((Method)m, (Object)target, (Object[])args2);
            return true;
        }
        Method on = Cls.findMethod(target.getClass(), (String)"on", (Class[])new Class[]{String.class, Object[].class});
        if (on != null) {
            Cls.invoke((Method)on, (Object)target, (Object[])new Object[]{cmd.name, cmd.args});
            return true;
        }
        on = Cls.findMethod(target.getClass(), (String)"on", (Class[])new Class[]{HttpExchange.class, String.class, Object[].class});
        if (on != null) {
            Cls.invoke((Method)on, (Object)target, (Object[])new Object[]{x, cmd.name, cmd.args});
            return true;
        }
        if (failIfNotFound) {
            throw U.rte((String)"Cannot find handler '%s' for the command '%s' and args: %s", (Object[])new Object[]{handlerName, cmd.name, cmd.args});
        }
        return false;
    }
}

