/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.pages;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.rapidoid.aop.AOP;
import org.rapidoid.arr.Arr;
import org.rapidoid.beany.Beany;
import org.rapidoid.cls.Cls;
import org.rapidoid.config.Conf;
import org.rapidoid.dispatch.PojoDispatchException;
import org.rapidoid.dispatch.PojoHandlerNotFoundException;
import org.rapidoid.dispatch.PojoRequest;
import org.rapidoid.html.Cmd;
import org.rapidoid.http.HTTPServer;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.HttpExchangeInternals;
import org.rapidoid.http.HttpNotFoundException;
import org.rapidoid.http.HttpSuccessException;
import org.rapidoid.json.JSON;
import org.rapidoid.lambda.Lambdas;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.log.Log;
import org.rapidoid.pages.PageGUI;
import org.rapidoid.pages.PageHandler;
import org.rapidoid.pages.impl.BuiltInCmdHandler;
import org.rapidoid.pages.impl.ComplexView;
import org.rapidoid.pages.impl.PageRenderer;
import org.rapidoid.rest.WebPojoDispatcher;
import org.rapidoid.rest.WebReq;
import org.rapidoid.util.Constants;
import org.rapidoid.util.U;
import org.rapidoid.util.UTILS;
import org.rapidoid.wire.Wire;

public class Pages {
    private static final String PAGE_RELOAD = "<h2>&nbsp;Reloading...</h2><script>location.reload();</script>";
    private static final BuiltInCmdHandler BUILT_IN_HANDLER = new BuiltInCmdHandler();

    public static void registerPages(HTTPServer server) {
        server.serve((Handler)new PageHandler());
    }

    public static String pageName(HttpExchange x) {
        String path = x.path();
        if (path.endsWith(".html")) {
            path = U.mid((String)path, (int)0, (int)-5);
        }
        if (path.equals("/")) {
            path = "/index";
        }
        return U.capitalized((String)path.substring(1));
    }

    public static String defaultPageTitle(Class<?> pageClass) {
        String pageName = pageClass.getSimpleName();
        if (pageName.endsWith("Page")) {
            pageName = U.mid((String)pageName, (int)0, (int)-4);
        }
        return UTILS.camelPhrase((String)pageName);
    }

    public static String titleOf(HttpExchange x, Object target) {
        Method m = Cls.findMethod(target.getClass(), (String)"title", (Class[])new Class[]{HttpExchange.class});
        if (m != null) {
            return (String)AOP.invoke((Object)x, (Method)m, (Object)target, (Object[])new Object[]{x});
        }
        try {
            return (String)Beany.getPropValue((Object)target, (String)"title");
        }
        catch (Exception e) {
            return Pages.defaultPageTitle(target.getClass());
        }
    }

    public static Object contentOf(HttpExchange x, Object target) {
        Method m = Cls.findMethod(target.getClass(), (String)"content", (Class[])new Class[]{HttpExchange.class});
        return m != null ? AOP.invoke((Object)x, (Method)m, (Object)target, (Object[])new Object[]{x}) : Beany.getPropValue((Object)target, (String)"content", null);
    }

    public static Object headOf(HttpExchange x, Object target) {
        Method m = Cls.findMethod(target.getClass(), (String)"head", (Class[])new Class[]{HttpExchange.class});
        return m != null ? AOP.invoke((Object)x, (Method)m, (Object)target, (Object[])new Object[]{x}) : Beany.getPropValue((Object)target, (String)"head", null);
    }

    public static Object page(HttpExchange x, Object page) {
        String pageTitle = Pages.titleOf(x, page);
        Object pageHead = U.or((Object)Pages.headOf(x, page), (Object)"");
        Object content = Pages.contentOf(x, page);
        if (content == null) {
            return null;
        }
        if (content instanceof HttpExchange) {
            U.must((x == content ? 1 : 0) != 0, (String)"Different HTTP exchange than expected!");
            return x;
        }
        return PageGUI.page(Conf.dev(), pageTitle, pageHead, content);
    }

    public static Object render(HttpExchange x, Object page) {
        Object fullPage = Pages.page(x, page);
        if (fullPage != null) {
            if (fullPage instanceof HttpExchange) {
                return x;
            }
            PageRenderer.get().render(fullPage, x);
            return x;
        }
        throw x.notFound();
    }

    public static Object dispatch(HttpExchange x, WebPojoDispatcher serviceDispatcher, Map<String, Class<?>> pages) {
        String pageName;
        if (x.serveStaticFile()) {
            return x;
        }
        if (serviceDispatcher != null) {
            try {
                return serviceDispatcher.dispatch((PojoRequest)new WebReq(x));
            }
            catch (PojoHandlerNotFoundException pojoHandlerNotFoundException) {
            }
            catch (PojoDispatchException e) {
                return x.errorResponse((Throwable)e);
            }
        }
        if ((pageName = Pages.pageName(x)) == null) {
            return null;
        }
        String pageClassName = U.capitalized((String)pageName) + "Page";
        Class<?> pageClass = pages.get(pageClassName);
        if (pageClass == null) {
            return null;
        }
        Object page = Cls.newInstance(pageClass);
        if (Pages.isEmiting(x)) {
            return Pages.emit(x, page);
        }
        return Pages.serve(x, page);
    }

    public static boolean isEmiting(HttpExchange x) {
        return x.isPostReq();
    }

    public static Object serve(HttpExchange x, Object view) {
        Pages.load(x, view);
        Pages.store(x, view);
        Object result = Pages.render(x, view);
        x.addToPageStack();
        Pages.store(x, view);
        return result;
    }

    public static void load(HttpExchange x, Object target) {
        Map sessionMap = UTILS.cast((Map)x.session());
        Mapper sessionMapper = Lambdas.mapper((Map)sessionMap);
        Map locals = UTILS.cast((Map)x.locals());
        Mapper localsMapper = Lambdas.mapper((Map)locals);
        Wire.autowire((Object)target, (Mapper)sessionMapper, (Mapper)localsMapper);
        if (target instanceof ComplexView) {
            ComplexView complex = (ComplexView)target;
            for (Object subview : complex.getSubViews()) {
                Wire.autowire((Object)subview, (Mapper)sessionMapper, (Mapper)localsMapper);
            }
        }
    }

    public static void store(HttpExchange x, Object target) {
        Pages.storeFrom(x, target);
        if (target instanceof ComplexView) {
            ComplexView complex = (ComplexView)target;
            for (Object subview : complex.getSubViews()) {
                Pages.storeFrom(x, subview);
            }
        }
    }

    private static void storeFrom(HttpExchange x, Object target) {
        for (Field field : Wire.getSessionFields((Object)target)) {
            Object value = Cls.getFieldValue((Field)field, (Object)target);
            x.session().put(field.getName(), UTILS.serializable((Object)value));
        }
    }

    public static final Object reloadOnEmit(HttpExchange x) {
        return Pages.changes(x, PAGE_RELOAD);
    }

    public static Object emit(HttpExchange x, Object view) {
        String html;
        Object content;
        boolean validEvent;
        String event = x.posted("event");
        boolean navigational = Boolean.parseBoolean(x.posted("navigational"));
        String evArgs = x.posted("args", null);
        Object[] args = evArgs != null ? (Object[])JSON.jacksonParse((String)evArgs, Object[].class) : Constants.EMPTY_ARRAY;
        boolean bl = validEvent = !U.isEmpty((String)event);
        if (!navigational) {
            Pages.doBinding(x, event, validEvent);
        }
        Pages.load(x, view);
        try {
            content = Pages.contentOf(x, view);
            if (content == null || content instanceof HttpExchange) {
                return content;
            }
        }
        catch (Exception e) {
            Throwable cause = UTILS.rootCause((Throwable)e);
            if (cause instanceof HttpSuccessException || cause instanceof HttpNotFoundException) {
                return null;
            }
            throw U.rte((Throwable)e);
        }
        if (x.hasErrors()) {
            x.json();
            return U.map((Object)"!errors", (Object)x.errors());
        }
        Pages.store(x, view);
        Pages.load(x, view);
        boolean processView = true;
        if (validEvent) {
            try {
                Pages.callCmdHandler(x, view, new Cmd(event, navigational, args));
            }
            catch (Exception e) {
                Throwable cause = UTILS.rootCause((Throwable)e);
                if (cause instanceof HttpSuccessException || cause instanceof HttpNotFoundException) {
                    processView = false;
                }
                throw U.rte((Throwable)e);
            }
        }
        Pages.store(x, view);
        Pages.load(x, view);
        String string = html = processView ? PageRenderer.get().toHTML(content, x) : "Error!";
        if (x.redirectUrl() != null) {
            x.startResponse(200);
            x.json();
            return U.map((Object)"_redirect_", (Object)x.redirectUrl());
        }
        return Pages.changes(x, html);
    }

    private static void doBinding(HttpExchange x, String event, boolean validEvent) {
        if (validEvent) {
            String inputs = x.posted("inputs");
            U.notNull((Object)inputs, (String)"inputs", (Object[])new Object[0]);
            Map inputsMap = (Map)JSON.parse((String)inputs, Map.class);
            Pages.emitValues(x, inputsMap);
        } else {
            Log.warn((String)"Invalid event!", (String)"event", (Object)event);
        }
    }

    private static void emitValues(HttpExchange x, Map<String, Object> values) {
        for (Map.Entry<String, Object> e : values.entrySet()) {
            String inputId = e.getKey();
            Object value = e.getValue();
            x.locals().put(inputId, UTILS.serializable((Object)value));
        }
    }

    private static Object changes(HttpExchange x, String html) {
        x.json();
        Map sel = U.map((Object)"body", (Object)html);
        return U.map((Object)"_sel_", (Object)sel, (Object)"_state_", (Object)Pages.stateOf(x));
    }

    public static byte[] stateOf(HttpExchange x) {
        HttpExchangeInternals xi = (HttpExchangeInternals)x;
        return xi.serializeLocals();
    }

    public static void callCmdHandler(HttpExchange x, Object target, Cmd cmd) {
        if (!Pages.callCmdHandler(x, target, cmd, false)) {
            Pages.callCmdHandler(x, BUILT_IN_HANDLER, cmd, false);
        }
    }

    private static boolean callCmdHandler(HttpExchange x, Object target, Cmd cmd, boolean failIfNotFound) {
        String handlerName = "on" + U.capitalized((String)cmd.name);
        Method m = Cls.findMethodByArgs(target.getClass(), (String)handlerName, (Object[])cmd.args);
        if (m != null) {
            AOP.invoke((Object)x, (Method)m, (Object)target, (Object[])cmd.args);
            return true;
        }
        Object[] args2 = Arr.expand((Object[])cmd.args, (Object)x);
        m = Cls.findMethodByArgs(target.getClass(), (String)handlerName, (Object[])args2);
        if (m != null) {
            AOP.invoke((Object)x, (Method)m, (Object)target, (Object[])args2);
            return true;
        }
        args2 = new Object[cmd.args.length + 1];
        args2[0] = x;
        System.arraycopy(cmd.args, 0, args2, 1, cmd.args.length);
        m = Cls.findMethodByArgs(target.getClass(), (String)handlerName, (Object[])args2);
        if (m != null) {
            AOP.invoke((Object)x, (Method)m, (Object)target, (Object[])args2);
            return true;
        }
        Method on = Cls.findMethod(target.getClass(), (String)"on", (Class[])new Class[]{String.class, Object[].class});
        if (on != null) {
            AOP.invoke((Object)x, (Method)on, (Object)target, (Object[])new Object[]{cmd.name, cmd.args});
            return true;
        }
        on = Cls.findMethod(target.getClass(), (String)"on", (Class[])new Class[]{HttpExchange.class, String.class, Object[].class});
        if (on != null) {
            AOP.invoke((Object)x, (Method)on, (Object)target, (Object[])new Object[]{x, cmd.name, cmd.args});
            return true;
        }
        if (failIfNotFound) {
            throw U.rte((String)"Cannot find handler '%s' for the command '%s' and args: %s", (Object[])new Object[]{handlerName, cmd.name, cmd.args});
        }
        return false;
    }
}

