/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.pages.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.rapidoid.html.HTML;
import org.rapidoid.html.Tag;
import org.rapidoid.html.TagProcessor;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.io.IO;
import org.rapidoid.pages.impl.HardcodedTag;
import org.rapidoid.pages.impl.PageRenderer;
import org.rapidoid.util.U;
import org.rapidoid.util.UTILS;

public class FileTemplateTag
extends HardcodedTag {
    private final String templateName;
    private final Object[] namesAndValues;

    public FileTemplateTag(String templateName, Object[] namesAndValues) {
        this.templateName = templateName;
        this.namesAndValues = namesAndValues;
    }

    @Override
    public void render(HttpExchange x, PageRenderer renderer, OutputStream out) {
        String text = IO.loadResourceAsString((String)this.templateName, (boolean)true);
        for (int i = 0; i < this.namesAndValues.length / 2; ++i) {
            String placeholder = (String)this.namesAndValues[i * 2];
            String value = renderer.toHTML(this.namesAndValues[i * 2 + 1], x);
            text = UTILS.fillIn((String)text, (String)placeholder, (String)value);
        }
        try {
            out.write(text.getBytes());
        }
        catch (IOException e) {
            throw U.rte((String)"Cannot render template!", (Throwable)e);
        }
    }

    public Tag copy() {
        return new FileTemplateTag(this.templateName, this.namesAndValues);
    }

    public void traverse(TagProcessor<Tag> processor) {
        for (int i = 0; i < this.namesAndValues.length / 2; ++i) {
            Object val = this.namesAndValues[i * 2 + 1];
            HTML.traverse((Object)val, processor);
        }
    }

    @Override
    public String tagKind() {
        return "template";
    }
}

