/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.scan;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.rapidoid.cls.Cls;
import org.rapidoid.ctx.Classes;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.io.IO;
import org.rapidoid.lambda.Lambdas;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.log.Log;
import org.rapidoid.tuple.Tuple;
import org.rapidoid.util.U;

public class Scan {
    private static final String[] SKIP_PKG = new String[]{"com", "org", "net", "io"};
    private static final Set<String> SKIP_PACKAGES = new HashSet<String>();
    private static final Map<String, Set<String>> SKIP_SUBPACKAGES = new HashMap<String, Set<String>>();
    private static final Set<String> CLASSPATH = new TreeSet<String>();
    private static final Map<Tuple, List<Class<?>>> CLASSES_CACHE = U.map();

    private Scan() {
    }

    public static synchronized void reset() {
        CLASSPATH.clear();
        CLASSES_CACHE.clear();
    }

    public static synchronized void args(String ... args) {
        for (String arg : args) {
            if (!arg.matches("\\+\\w+")) continue;
            Scan.addon(arg.substring(1));
        }
    }

    private static Object addon(String addonName) {
        U.must((boolean)addonName.matches("\\w+"), (String)"Invalid add-on name, must be alphanumeric!");
        String addonClassName = "org.rapidoid.addon." + U.capitalized((String)addonName) + "Addon";
        Class addonCls = Cls.getClassIfExists((String)addonClassName);
        if (addonCls != null) {
            if (Callable.class.isAssignableFrom(addonCls)) {
                Callable addon = (Callable)Cls.newInstance((Class)addonCls);
                try {
                    Object addonResult = addon.call();
                    Log.info((String)"Executed add-on", (String)"add-on", (Object)addonName, (String)"add-on class", (Object)addonClassName, (String)"result", addonResult);
                    return addonResult;
                }
                catch (Exception e) {
                    throw U.rte((Throwable)e);
                }
            }
            Log.warn((String)"Found add-on, but it's not a Runnable!", (String)"add-on", (Object)addonName, (String)"add-on class", (Object)addonClassName);
        } else {
            Log.debug((String)"No add-on was found", (String)"add-on", (Object)addonName, (String)"add-on class", (Object)addonClassName);
        }
        return null;
    }

    public static synchronized List<Class<?>> classes() {
        return Scan.classes(null, null, null, null, null);
    }

    public static synchronized List<Class<?>> classes(String packageName, String nameRegex, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, ClassLoader classLoader) {
        return Scan.scanClasses(packageName, nameRegex, filter, annotated, classLoader);
    }

    public static synchronized List<Class<?>> annotated(Class<? extends Annotation> annotated) {
        return Scan.scanClasses(null, null, null, annotated, null);
    }

    public static synchronized List<Class<?>> annotated(Class<? extends Annotation> annotated, ClassLoader classLoader) {
        return Scan.scanClasses(null, null, null, annotated, classLoader);
    }

    public static synchronized List<Class<?>> pkg(String packageName) {
        return Scan.scanClasses(packageName, null, null, null, null);
    }

    public static synchronized List<Class<?>> byName(String simpleName, Predicate<Class<?>> filter, ClassLoader classLoader) {
        return Scan.scanClasses(null, "(.*\\.|^)" + simpleName, filter, null, classLoader);
    }

    public static synchronized List<Class<?>> bySuffix(String nameSuffix, Predicate<Class<?>> filter, ClassLoader classLoader) {
        return Scan.scanClasses(null, ".*\\w" + nameSuffix, filter, null, classLoader);
    }

    public static synchronized List<File> files(String packageName, Predicate<File> filter) {
        ArrayList<File> files = new ArrayList<File>();
        Scan.files(packageName, files, filter);
        return files;
    }

    public static synchronized List<File> dir(String dir, Predicate<File> filter) {
        ArrayList<File> files = new ArrayList<File>();
        Scan.getFiles(files, new File(dir), filter);
        return files;
    }

    public static synchronized void files(String packageName, Collection<File> files, Predicate<File> filter) {
        Enumeration<URL> urls = Scan.resources(packageName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            File file = new File(url.getFile());
            Scan.getFiles(files, file, filter);
        }
    }

    private static void getFiles(Collection<File> files, File file, Predicate<File> filter) {
        if (file.isDirectory()) {
            Log.debug((String)"scanning directory", (String)"dir", (Object)file);
            for (File f : file.listFiles()) {
                if (f.isDirectory()) {
                    Scan.getFiles(files, f, filter);
                    continue;
                }
                Log.debug((String)"scanned file", (String)"file", (Object)f);
                try {
                    if (filter != null && !filter.eval((Object)f)) continue;
                    files.add(f);
                }
                catch (Exception e) {
                    throw U.rte((Throwable)e);
                }
            }
        }
    }

    private static List<Class<?>> scanClasses(String packageName, String nameRegex, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, ClassLoader classLoader) {
        List<Class<?>> classes;
        packageName = (String)U.or((Object)packageName, (Object)"");
        boolean caching = classLoader == null;
        Tuple cacheKey = null;
        if (caching && (classes = CLASSES_CACHE.get(cacheKey = new Tuple(new Object[]{packageName, nameRegex, filter, annotated, classLoader}))) != null) {
            return classes;
        }
        Classes ctxClasses = Ctx.classes();
        Pattern regex = nameRegex != null ? Pattern.compile(nameRegex) : null;
        classes = ctxClasses != null ? Scan.filterClasses(ctxClasses, packageName, regex, filter, annotated) : Scan.retrieveClasses(packageName, filter, annotated, regex, classLoader);
        if (caching) {
            CLASSES_CACHE.put(cacheKey, classes);
        }
        return classes;
    }

    private static List<Class<?>> retrieveClasses(String packageName, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, Pattern regex, ClassLoader classLoader) {
        ArrayList classes = new ArrayList();
        String pkgName = (String)U.or((Object)packageName, (Object)"");
        Set<String> classpath = Scan.getClasspath();
        for (String cpe : classpath) {
            File file = new File(cpe);
            String path = file.getAbsolutePath();
            String pkgPath = pkgName.replace('.', File.separatorChar);
            String rootPath = pkgPath.isEmpty() ? path : path.replace(File.separatorChar + pkgPath, "");
            File root = new File(rootPath);
            if (root.exists()) {
                if (root.isDirectory()) {
                    Log.debug((String)"Scanning directory", (String)"name", (Object)root.getAbsolutePath());
                    Scan.getClassesFromDir(classes, root, file, regex, filter, annotated, classLoader);
                    continue;
                }
                if (root.isFile() && root.getAbsolutePath().toLowerCase().endsWith(".jar")) {
                    Log.debug((String)"Scanning JAR", (String)"name", (Object)root.getAbsolutePath());
                    Scan.getClassesFromJAR(root.getAbsolutePath(), classes, packageName, regex, filter, annotated, classLoader);
                    continue;
                }
                Log.warn((String)("Invalid classpath entry: " + cpe));
                continue;
            }
            Log.warn((String)("Classpath entry doesn't exist: " + cpe));
        }
        return classes;
    }

    private static List<Class<?>> filterClasses(Classes classes, String packageName, Pattern regex, Predicate<Class<?>> filter, Class<? extends Annotation> annotated) {
        List matching = U.list((Object[])new Class[0]);
        for (Map.Entry e : classes.entrySet()) {
            String pkg;
            Class cls = (Class)e.getValue();
            String string = pkg = cls.getPackage() != null ? cls.getPackage().getName() : "";
            if (packageName != null && !pkg.startsWith(packageName + ".") && !pkg.equals(packageName) || !Scan.classMatches(cls, filter, annotated, regex)) continue;
            matching.add(cls);
        }
        return matching;
    }

    private static void getClassesFromDir(Collection<Class<?>> classes, File root, File parent, Pattern regex, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, ClassLoader classLoader) {
        if (parent.isDirectory()) {
            Log.debug((String)"scanning directory", (String)"dir", (Object)parent);
            for (File file : parent.listFiles()) {
                if (file.isDirectory()) {
                    Scan.getClassesFromDir(classes, root, file, regex, filter, annotated, classLoader);
                    continue;
                }
                String rootPath = U.trimr((String)root.getAbsolutePath(), (char)File.separatorChar);
                int from = rootPath.length() + 1;
                String relName = file.getAbsolutePath().substring(from);
                if (Scan.ignore(relName)) continue;
                Scan.scanFile(classes, regex, filter, annotated, classLoader, relName);
            }
        }
    }

    private static void scanFile(Collection<Class<?>> classes, Pattern regex, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, ClassLoader classLoader, String relName) {
        Log.debug((String)"scanned file", (String)"file", (Object)relName);
        if (relName.endsWith(".class")) {
            String clsName = U.mid((String)relName, (int)0, (int)-6).replace(File.separatorChar, '.');
            if (regex == null || regex.matcher(clsName).matches()) {
                try {
                    Class<?> cls;
                    Log.debug((String)"loading class", (String)"name", (Object)clsName);
                    Class<?> clazz = cls = classLoader != null ? Class.forName(clsName, true, classLoader) : Class.forName(clsName);
                    if (Scan.classMatches(cls, filter, annotated, null)) {
                        classes.add(cls);
                    }
                }
                catch (NoClassDefFoundError cls) {
                }
                catch (Exception e) {
                    throw U.rte((Throwable)e);
                }
            }
        }
    }

    private static String pkgToPath(String pkg) {
        return pkg.replace('.', File.separatorChar);
    }

    private static boolean classMatches(Class<?> cls, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, Pattern regex) {
        return !(annotated != null && cls.getAnnotation(annotated) == null || regex != null && !regex.matcher(cls.getCanonicalName()).matches() || filter != null && !Lambdas.eval(filter, cls));
    }

    private static Enumeration<URL> resources(String name) {
        name = name.replace('.', '/');
        try {
            return Cls.classLoader().getResources(name);
        }
        catch (IOException e) {
            throw U.rte((String)("Cannot scan: " + name), (Throwable)e);
        }
    }

    private static List<Class<?>> getClassesFromJAR(String jarName, List<Class<?>> classes, String pkg, Pattern regex, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, ClassLoader classLoader) {
        try {
            ZipEntry e;
            String pkgPath = Scan.pkgToPath(pkg);
            ZipInputStream zip = new ZipInputStream(new URL("file://" + jarName).openStream());
            while ((e = zip.getNextEntry()) != null) {
                String name;
                if (e.isDirectory() || Scan.ignore(name = e.getName()) || !U.isEmpty((String)pkg) && !name.startsWith(pkgPath)) continue;
                Scan.scanFile(classes, regex, filter, annotated, classLoader, name);
            }
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
        return classes;
    }

    private static boolean ignore(String name) {
        String pkgName = U.triml((String)name, (char)File.separatorChar);
        int p1 = pkgName.indexOf(File.separatorChar);
        int p2 = -1;
        if (p1 > 0) {
            String part1 = pkgName.substring(0, p1);
            if (SKIP_PACKAGES.contains(part1)) {
                return true;
            }
            p2 = pkgName.indexOf(File.separatorChar, p1 + 1);
            if (p2 > 0) {
                String part2 = pkgName.substring(p1 + 1, p2);
                if (U.isEmpty((String)part2)) {
                    return true;
                }
                Set<String> subpkg = SKIP_SUBPACKAGES.get(part1);
                if (subpkg != null && subpkg.contains(part2)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static synchronized Set<String> getClasspath() {
        if (CLASSPATH.isEmpty()) {
            URL[] urls;
            String classpathProp = System.getProperty("java.class.path");
            if (classpathProp != null) {
                String[] classpathEntries;
                for (String cpe : classpathEntries = classpathProp.split(File.pathSeparator)) {
                    cpe = U.trimr((String)cpe, (char)'/');
                    CLASSPATH.add(new File(cpe).getAbsolutePath());
                }
            }
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
                String path = U.trimr((String)url.getPath(), (char)'/');
                CLASSPATH.add(new File(path).getAbsolutePath());
            }
        }
        return CLASSPATH;
    }

    static {
        SKIP_PACKAGES.addAll(IO.loadLines((String)"scan-ignore.txt"));
        SKIP_PACKAGES.add("java");
        SKIP_PACKAGES.add("javax");
        SKIP_PACKAGES.add("META-INF");
        SKIP_PACKAGES.add("license");
        SKIP_PACKAGES.add("public");
        SKIP_PACKAGES.add("static");
        for (String pkg : SKIP_PKG) {
            SKIP_SUBPACKAGES.put(pkg, U.set((Iterable)IO.loadLines((String)U.format((String)"scan-ignore-%s.txt", (Object[])new Object[]{pkg}))));
        }
        SKIP_SUBPACKAGES.get("org").add("xml");
        SKIP_SUBPACKAGES.get("org").add("dom4j");
        SKIP_SUBPACKAGES.get("com").add("fasterxml");
    }
}

