/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.scan;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.rapidoid.cls.Cls;
import org.rapidoid.io.IO;
import org.rapidoid.lambda.Lmbd;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.log.Log;
import org.rapidoid.scan.ScanParams;
import org.rapidoid.u.U;

public class ClasspathUtil {
    private static final String[] SKIP_PKG = new String[]{"com", "org", "net", "io"};
    private static final Set<String> SKIP_PACKAGES = new HashSet<String>();
    private static final Map<String, Set<String>> SKIP_SUBPACKAGES = new HashMap<String, Set<String>>();
    private static final Set<String> CLASSPATH = new TreeSet<String>();
    private static boolean ignoreRapidoidClasses = true;
    private static String rootPackage = null;
    private static final String ORG_RAPIDOID_DIR = "org" + File.separatorChar + "rapidoid" + File.separatorChar;
    private static final String ORG_RAPIDOIDX_DIR = "org" + File.separatorChar + "rapidoidx" + File.separatorChar;

    private ClasspathUtil() {
    }

    public static synchronized void reset() {
        CLASSPATH.clear();
    }

    public static synchronized List<File> files(String packageName, Predicate<File> filter) {
        ArrayList<File> files = new ArrayList<File>();
        ClasspathUtil.files(packageName, files, filter);
        return files;
    }

    public static synchronized List<File> dir(String dir, Predicate<File> filter) {
        ArrayList<File> files = new ArrayList<File>();
        ClasspathUtil.getFiles(files, new File(dir), filter);
        return files;
    }

    public static synchronized void files(String packageName, Collection<File> files, Predicate<File> filter) {
        Enumeration<URL> urls = ClasspathUtil.resources(packageName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            File file = new File(url.getFile());
            ClasspathUtil.getFiles(files, file, filter);
        }
    }

    private static void getFiles(Collection<File> files, File file, Predicate<File> filter) {
        if (file.isDirectory()) {
            Log.debug((String)"scanning directory", (String)"dir", (Object)file);
            for (File f : file.listFiles()) {
                if (f.isDirectory()) {
                    ClasspathUtil.getFiles(files, f, filter);
                    continue;
                }
                Log.debug((String)"scanned file", (String)"file", (Object)f);
                try {
                    if (filter != null && !filter.eval((Object)f)) continue;
                    files.add(f);
                }
                catch (Exception e) {
                    throw U.rte((Throwable)e);
                }
            }
        }
    }

    public static List<Class<?>> scanClasses(ScanParams params) {
        String packageName = (String)U.or((Object)params.pkg(), (Object)"");
        long startingAt = U.time();
        String regex = params.matching();
        Pattern pattern = regex != null ? Pattern.compile(regex) : null;
        Log.info((String)"Retrieving classes", (String)"annotated", params.annotated(), (String)"package", (Object)packageName, (String)"matching", (Object)regex);
        List<Class<?>> classes = ClasspathUtil.retrieveClasses(packageName, params.filter(), params.annotated(), pattern, params.classLoader());
        long timeMs = U.time() - startingAt;
        Log.info((String)"Finished classpath scan", (String)"time", (Object)(timeMs + "ms"), (String)"classes", classes);
        return classes;
    }

    private static List<Class<?>> retrieveClasses(String packageName, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, Pattern regex, ClassLoader classLoader) {
        ArrayList classes = new ArrayList();
        String pkgName = U.safe((String)packageName);
        String pkgPath = pkgName.replace('.', File.separatorChar);
        Set<String> classpath = ClasspathUtil.getClasspath();
        Log.info((String)"Scanning classpath", (String)"classpath", classpath);
        Set jars = U.set();
        for (String cpe : classpath) {
            File cpEntry = new File(cpe);
            if (cpEntry.exists()) {
                if (cpEntry.isDirectory()) {
                    if (ClasspathUtil.shouldScanDir(cpEntry.getAbsolutePath())) {
                        Log.debug((String)"Scanning directory", (String)"root", (Object)cpEntry.getAbsolutePath());
                        File startingDir = pkgPath.isEmpty() ? cpEntry : new File(cpEntry.getAbsolutePath(), pkgPath);
                        if (!startingDir.exists()) continue;
                        ClasspathUtil.getClassesFromDir(classes, cpEntry, startingDir, pkgName, regex, filter, annotated, classLoader);
                        continue;
                    }
                    Log.debug((String)"Skipping directory", (String)"root", (Object)cpEntry.getAbsolutePath());
                    continue;
                }
                if (cpEntry.isFile() && cpEntry.getAbsolutePath().toLowerCase().endsWith(".jar")) {
                    jars.add(cpEntry.getAbsolutePath());
                    continue;
                }
                Log.warn((String)("Invalid classpath entry: " + cpe));
                continue;
            }
            Log.warn((String)("Classpath entry doesn't exist: " + cpe));
        }
        for (String jarName : jars) {
            if (ClasspathUtil.shouldScanJAR(jarName)) {
                Log.debug((String)"Scanning JAR", (String)"name", (Object)jarName);
                ClasspathUtil.getClassesFromJAR(jarName, classes, packageName, regex, filter, annotated, classLoader);
                continue;
            }
            Log.debug((String)"Skipping JAR", (String)"name", (Object)jarName);
        }
        return classes;
    }

    private static boolean shouldScanDir(String dir) {
        return true;
    }

    private static boolean shouldScanJAR(String jar) {
        File file = new File(jar);
        String simpleName = file.getName();
        return simpleName.startsWith("app.") || simpleName.startsWith("app-");
    }

    private static void getClassesFromDir(Collection<Class<?>> classes, File root, File dir, String pkg, Pattern regex, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, ClassLoader classLoader) {
        U.must((boolean)dir.isDirectory());
        Log.debug((String)"Traversing directory", (String)"root", (Object)root, (String)"dir", (Object)dir);
        File[] files = dir.listFiles();
        if (files == null) {
            Log.warn((String)"Not a folder!", (String)"dir", (Object)dir);
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                ClasspathUtil.getClassesFromDir(classes, root, file, pkg, regex, filter, annotated, classLoader);
                continue;
            }
            String rootPath = U.trimr((String)root.getAbsolutePath(), (char)File.separatorChar);
            int from = rootPath.length() + 1;
            String relName = file.getAbsolutePath().substring(from);
            if (ClasspathUtil.ignore(relName)) continue;
            ClasspathUtil.scanFile(classes, regex, filter, annotated, classLoader, relName);
        }
    }

    private static void scanFile(Collection<Class<?>> classes, Pattern regex, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, ClassLoader classLoader, String relName) {
        Log.debug((String)"scanned file", (String)"file", (Object)relName);
        if (relName.endsWith(".class")) {
            String clsName = U.mid((String)relName, (int)0, (int)-6).replace('/', '.').replace('\\', '.');
            if (regex == null || regex.matcher(clsName).matches()) {
                try {
                    Class<?> cls;
                    Log.debug((String)"loading class", (String)"name", (Object)clsName);
                    Class<?> clazz = cls = classLoader != null ? Class.forName(clsName, true, classLoader) : Class.forName(clsName);
                    if (ClasspathUtil.classMatches(cls, filter, annotated, null)) {
                        classes.add(cls);
                    }
                }
                catch (Throwable e) {
                    Log.warn((String)"Error while loading class", (String)"name", (Object)clsName, (String)"error", (Object)e);
                }
            }
        }
    }

    private static String pkgToPath(String pkg) {
        return pkg != null ? pkg.replace('.', File.separatorChar) : null;
    }

    private static Enumeration<URL> resources(String name) {
        name = name.replace('.', '/');
        try {
            return Cls.classLoader().getResources(name);
        }
        catch (IOException e) {
            throw U.rte((String)("Cannot scan: " + name), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Class<?>> getClassesFromJAR(String jarName, List<Class<?>> classes, String pkg, Pattern regex, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, ClassLoader classLoader) {
        ZipInputStream zip = null;
        try {
            ZipEntry e;
            String pkgPath = ClasspathUtil.pkgToPath(pkg);
            File jarFile = new File(jarName);
            FileInputStream jarInputStream = new FileInputStream(jarFile);
            zip = new ZipInputStream(jarInputStream);
            while ((e = zip.getNextEntry()) != null) {
                String name;
                if (e.isDirectory() || ClasspathUtil.ignore(name = e.getName()) || !U.isEmpty((String)pkg) && !name.startsWith(pkgPath)) continue;
                ClasspathUtil.scanFile(classes, regex, filter, annotated, classLoader, name);
            }
        }
        catch (Exception e) {
            Log.error((String)("Cannot scan JAR: " + jarName), (Throwable)e);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    Log.error((String)"Couldn't close the ZIP stream!", (Throwable)e);
                }
            }
        }
        return classes;
    }

    private static boolean ignore(String name) {
        String pkgDirName = U.triml((String)name, (char)File.separatorChar);
        if (ignoreRapidoidClasses && (pkgDirName.startsWith(ORG_RAPIDOID_DIR) || pkgDirName.startsWith(ORG_RAPIDOIDX_DIR))) {
            return true;
        }
        int p1 = pkgDirName.indexOf(File.separatorChar);
        int p2 = -1;
        if (p1 > 0) {
            String part1 = pkgDirName.substring(0, p1);
            if (SKIP_PACKAGES.contains(part1)) {
                return true;
            }
            p2 = pkgDirName.indexOf(File.separatorChar, p1 + 1);
            if (p2 > 0) {
                String part2 = pkgDirName.substring(p1 + 1, p2);
                if (U.isEmpty((String)part2)) {
                    return true;
                }
                Set<String> subpkg = SKIP_SUBPACKAGES.get(part1);
                if (subpkg != null && subpkg.contains(part2)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static synchronized Set<String> getClasspath() {
        if (CLASSPATH.isEmpty()) {
            URL[] urls;
            String classpathProp = System.getProperty("java.class.path");
            if (classpathProp != null) {
                String[] classpathEntries;
                for (String cpe : classpathEntries = classpathProp.split(File.pathSeparator)) {
                    cpe = U.trimr((String)cpe, (char)'/');
                    CLASSPATH.add(new File(cpe).getAbsolutePath());
                }
            }
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
                String path = U.trimr((String)url.getPath(), (char)'/');
                CLASSPATH.add(new File(path).getAbsolutePath());
            }
        }
        return CLASSPATH;
    }

    public static boolean classMatches(Class<?> cls, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, Pattern regex) {
        return !(annotated != null && cls.getAnnotation(annotated) == null || regex != null && (cls.getCanonicalName() == null || !regex.matcher(cls.getCanonicalName()).matches()) || filter != null && !Lmbd.eval(filter, cls));
    }

    public static void setIgnoreRapidoidClasses(boolean ignoreRapidoidClasses) {
        ClasspathUtil.ignoreRapidoidClasses = ignoreRapidoidClasses;
    }

    public static String getRootPackage() {
        return rootPackage;
    }

    public static void setRootPackage(String rootPackage) {
        ClasspathUtil.rootPackage = rootPackage;
    }

    public static List<Class<?>> getClasses(ScanParams scanParams) {
        return ClasspathUtil.scanClasses(scanParams);
    }

    static {
        SKIP_PACKAGES.addAll(IO.loadLines((String)"scan-ignore.txt"));
        SKIP_PACKAGES.add("java");
        SKIP_PACKAGES.add("javax");
        SKIP_PACKAGES.add("META-INF");
        SKIP_PACKAGES.add("license");
        SKIP_PACKAGES.add("public");
        SKIP_PACKAGES.add("static");
        for (String pkg : SKIP_PKG) {
            SKIP_SUBPACKAGES.put(pkg, U.set((Iterable)IO.loadLines((String)U.frmt((String)"scan-ignore-%s.txt", (Object[])new Object[]{pkg}))));
        }
        SKIP_SUBPACKAGES.get("org").add("xml");
        SKIP_SUBPACKAGES.get("org").add("dom4j");
        SKIP_SUBPACKAGES.get("com").add("fasterxml");
    }
}

