/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.security;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Metadata;
import org.rapidoid.beany.Prop;
import org.rapidoid.security.AppSecurity;
import org.rapidoid.security.DataPermissions;
import org.rapidoid.security.annotation.CanChange;
import org.rapidoid.security.annotation.CanDelete;
import org.rapidoid.security.annotation.CanInsert;
import org.rapidoid.security.annotation.CanManage;
import org.rapidoid.security.annotation.CanRead;
import org.rapidoid.util.AppCtx;
import org.rapidoid.util.Cls;
import org.rapidoid.util.Constants;
import org.rapidoid.util.U;
import org.rapidoid.util.UserInfo;

public class Secure
implements Constants {
    private static AppSecurity security = (AppSecurity)Cls.customizable(AppSecurity.class, (Object[])new Object[0]);

    public static boolean hasRole(String username, String role) {
        return security.hasRole(username, role, null, null);
    }

    public static boolean hasRoleForClass(String username, String role, Class<?> clazz) {
        return security.hasRole(username, role, Cls.unproxy(clazz), null);
    }

    public static boolean hasRoleForRecord(String username, String role, Object record) {
        return security.hasRole(username, role, Cls.unproxy(record.getClass()), record);
    }

    public static boolean isAdmin(String username) {
        return security.isAdmin(username);
    }

    public static boolean isManager(String username) {
        return security.isManager(username);
    }

    public static boolean isModerator(String username) {
        return security.isModerator(username);
    }

    public static boolean isOwnerOf(String username, Object record) {
        return security.isOwnerOf(username, record);
    }

    public static boolean isSharedWith(String username, Object record) {
        return security.isSharedWith(username, record);
    }

    public static boolean canAccessClass(String username, Class<?> clazz) {
        U.notNull(clazz, (String)"class", (Object[])new Object[0]);
        clazz = Cls.unproxy(clazz);
        return Secure.hasRoleBasedClassAccess(username, clazz) && security.canAccessClass(username, clazz);
    }

    public static boolean hasRoleBasedClassAccess(String username, Class<?> clazz) {
        U.notNull(clazz, (String)"class", (Object[])new Object[0]);
        clazz = Cls.unproxy(clazz);
        return Secure.hasRoleBasedAccess(username, clazz, null);
    }

    public static boolean hasRoleBasedObjectAccess(String username, Object target) {
        U.notNull((Object)target, (String)"target", (Object[])new Object[0]);
        return Secure.hasRoleBasedAccess(username, Cls.unproxy(target.getClass()), target);
    }

    private static boolean hasRoleBasedAccess(String username, Class<?> clazz, Object target) {
        String[] roles = security.getRolesAllowed(clazz = Cls.unproxy(clazz));
        return roles.length == 0 || Secure.hasAnyRole(username, roles, clazz, target);
    }

    public static boolean hasAnyRole(String username, String[] roles, Class<?> clazz, Object target) {
        clazz = Cls.unproxy(clazz);
        for (String role : roles) {
            if (!security.hasRole(username, role, clazz, target)) continue;
            return true;
        }
        return false;
    }

    public static DataPermissions getPropertyPermissions(String username, Class<?> clazz, Object target, String propertyName) {
        U.notNull(clazz, (String)"class", (Object[])new Object[0]);
        clazz = Cls.unproxy(clazz);
        if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Object[].class.isAssignableFrom(clazz)) {
            return DataPermissions.ALL;
        }
        if (!Secure.hasRoleBasedAccess(username, clazz, target)) {
            return DataPermissions.NONE;
        }
        CanRead canRead = (CanRead)Metadata.propAnnotation((Class)clazz, (String)propertyName, CanRead.class);
        CanInsert canInsert = (CanInsert)Metadata.propAnnotation((Class)clazz, (String)propertyName, CanInsert.class);
        CanChange canChange = (CanChange)Metadata.propAnnotation((Class)clazz, (String)propertyName, CanChange.class);
        CanDelete canDelete = (CanDelete)Metadata.propAnnotation((Class)clazz, (String)propertyName, CanDelete.class);
        CanManage canManage = (CanManage)Metadata.propAnnotation((Class)clazz, (String)propertyName, CanManage.class);
        if (canRead == null && canInsert == null && canChange == null && canDelete == null && canManage == null) {
            return DataPermissions.ALL;
        }
        boolean read = canRead == null || Secure.hasAnyRole(username, canRead.value(), clazz, target);
        boolean insert = canInsert != null && Secure.hasAnyRole(username, canInsert.value(), clazz, target);
        boolean change = canChange != null && Secure.hasAnyRole(username, canChange.value(), clazz, target);
        boolean delete = canDelete != null && Secure.hasAnyRole(username, canDelete.value(), clazz, target);
        boolean manage = canManage != null && Secure.hasAnyRole(username, canManage.value(), clazz, target);
        return DataPermissions.from(read, insert |= manage, change |= manage, delete |= manage);
    }

    public static DataPermissions getClassPermissions(String username, Class<?> clazz) {
        U.notNull(clazz, (String)"class", (Object[])new Object[0]);
        clazz = Cls.unproxy(clazz);
        if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Object[].class.isAssignableFrom(clazz)) {
            return DataPermissions.ALL;
        }
        if (!Secure.hasRoleBasedAccess(username, clazz, null)) {
            return DataPermissions.NONE;
        }
        CanRead canRead = (CanRead)Metadata.classAnnotation((Class)clazz, CanRead.class);
        CanInsert canInsert = (CanInsert)Metadata.classAnnotation((Class)clazz, CanInsert.class);
        CanChange canChange = (CanChange)Metadata.classAnnotation((Class)clazz, CanChange.class);
        CanDelete canDelete = (CanDelete)Metadata.classAnnotation((Class)clazz, CanDelete.class);
        CanManage canManage = (CanManage)Metadata.classAnnotation((Class)clazz, CanManage.class);
        if (canRead == null && canInsert == null && canChange == null && canDelete == null && canManage == null) {
            return DataPermissions.ALL;
        }
        boolean read = canRead == null || Secure.hasAnyRole(username, canRead.value(), clazz, null);
        boolean insert = canInsert != null && Secure.hasAnyRole(username, canInsert.value(), clazz, null);
        boolean change = canChange != null && Secure.hasAnyRole(username, canChange.value(), clazz, null);
        boolean delete = canDelete != null && Secure.hasAnyRole(username, canDelete.value(), clazz, null);
        boolean manage = canManage != null && Secure.hasAnyRole(username, canManage.value(), clazz, null);
        return DataPermissions.from(read, insert |= manage, change |= manage, delete |= manage);
    }

    public static DataPermissions getObjectPermissions(String username, Object target) {
        U.notNull((Object)target, (String)"target", (Object[])new Object[0]);
        Class clazz = target.getClass();
        clazz = Cls.unproxy(clazz);
        if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Object[].class.isAssignableFrom(clazz)) {
            return DataPermissions.ALL;
        }
        if (!Secure.hasRoleBasedAccess(username, clazz, null)) {
            return DataPermissions.NONE;
        }
        CanRead canRead = (CanRead)Metadata.classAnnotation((Class)clazz, CanRead.class);
        CanInsert canInsert = (CanInsert)Metadata.classAnnotation((Class)clazz, CanInsert.class);
        CanChange canChange = (CanChange)Metadata.classAnnotation((Class)clazz, CanChange.class);
        CanDelete canDelete = (CanDelete)Metadata.classAnnotation((Class)clazz, CanDelete.class);
        CanManage canManage = (CanManage)Metadata.classAnnotation((Class)clazz, CanManage.class);
        if (canRead == null && canInsert == null && canChange == null && canDelete == null && canManage == null) {
            return DataPermissions.ALL;
        }
        boolean read = canRead == null || Secure.hasAnyRole(username, canRead.value(), clazz, target);
        boolean insert = canInsert != null && Secure.hasAnyRole(username, canInsert.value(), clazz, target);
        boolean change = canChange != null && Secure.hasAnyRole(username, canChange.value(), clazz, target);
        boolean delete = canDelete != null && Secure.hasAnyRole(username, canDelete.value(), clazz, target);
        boolean manage = canManage != null && Secure.hasAnyRole(username, canManage.value(), clazz, target);
        return DataPermissions.from(read, insert |= manage, change |= manage, delete |= manage);
    }

    public static List<String> getUserRoles(String username) {
        return security.getUserRoles(username);
    }

    public static UserInfo user() {
        return AppCtx.user();
    }

    public static boolean isLoggedIn() {
        return Secure.user() != null;
    }

    public static String username() {
        UserInfo user = Secure.user();
        return user != null ? user.username : null;
    }

    public static boolean canRead(String username, Object record) {
        return Secure.hasRoleBasedObjectAccess(username, record) && Secure.getObjectPermissions((String)username, (Object)record).read;
    }

    public static boolean canInsert(String username, Object record) {
        return Secure.hasRoleBasedObjectAccess(username, record) && Secure.getObjectPermissions((String)username, (Object)record).insert;
    }

    public static boolean canUpdate(String username, Object record) {
        return Secure.hasRoleBasedObjectAccess(username, record) && Secure.getObjectPermissions((String)username, (Object)record).change;
    }

    public static boolean canDelete(String username, Object record) {
        return Secure.hasRoleBasedObjectAccess(username, record) && Secure.getObjectPermissions((String)username, (Object)record).delete;
    }

    public static boolean canReadProperty(String username, Object record, String property) {
        return Secure.hasRoleBasedObjectAccess(username, record) && Secure.getObjectPermissions((String)username, (Object)record).read && Secure.getPropertyPermissions((String)username, record.getClass(), (Object)record, (String)property).read;
    }

    public static boolean canUpdateProperty(String username, Object record, String property) {
        return Secure.hasRoleBasedObjectAccess(username, record) && Secure.getObjectPermissions((String)username, (Object)record).change && Secure.getPropertyPermissions((String)username, record.getClass(), (Object)record, (String)property).change;
    }

    public static void resetInvisibleProperties(String username, Object record) {
        for (Prop prop : Beany.propertiesOf((Object)record)) {
            if (Secure.getPropertyPermissions((String)username, record.getClass(), (Object)record, (String)prop.getName()).read) continue;
            prop.reset(record);
        }
    }
}

