/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.security;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Metadata;
import org.rapidoid.config.Conf;
import org.rapidoid.security.DataPermissions;
import org.rapidoid.security.annotation.Admin;
import org.rapidoid.security.annotation.LoggedIn;
import org.rapidoid.security.annotation.Manager;
import org.rapidoid.security.annotation.Moderator;
import org.rapidoid.security.annotation.Role;
import org.rapidoid.security.annotation.Roles;
import org.rapidoid.util.CommonRoles;
import org.rapidoid.util.Constants;
import org.rapidoid.util.U;

public class AppSecurity
implements Constants {
    public String[] getRolesAllowed(Class<?> clazz) {
        Set roles = U.set((Object[])new String[0]);
        Map annotations = Metadata.classAnnotations(clazz);
        for (Map.Entry e : annotations.entrySet()) {
            Annotation ann = (Annotation)e.getValue();
            Class<? extends Annotation> type = ann.annotationType();
            if (type.equals(Admin.class)) {
                roles.add("ADMIN");
                continue;
            }
            if (type.equals(Manager.class)) {
                roles.add("MANAGER");
                continue;
            }
            if (type.equals(Moderator.class)) {
                roles.add("MODERATOR");
                continue;
            }
            if (type.equals(LoggedIn.class)) {
                roles.add("LOGGED_IN");
                continue;
            }
            if (!type.equals(Roles.class)) continue;
            Role[] values = ((Roles)ann).value();
            U.must((values.length > 0 ? 1 : 0) != 0, (String)"At least one role must be specified in @Roles annotation!");
            for (Role r : values) {
                roles.add(r.annotationType().getSimpleName().toUpperCase());
            }
        }
        return roles.toArray(new String[roles.size()]);
    }

    public boolean canAccessClass(String username, Class<?> clazz) {
        return true;
    }

    public boolean hasRole(String username, String role, Class<?> clazz, Object record) {
        if ("ANYBODY".equalsIgnoreCase(role)) {
            return true;
        }
        if (U.isEmpty((String)username) || U.isEmpty((String)role)) {
            return false;
        }
        if (record != null) {
            if (role.equalsIgnoreCase("OWNER")) {
                return this.isOwnerOf(username, record);
            }
            if (role.equalsIgnoreCase("SHARED_WITH")) {
                return this.isSharedWith(username, record);
            }
        }
        return this.hasRole(username, role);
    }

    protected boolean hasRoleInDevMode(String username, String role) {
        return Conf.dev() && username.equals(role.toLowerCase() + "@debug");
    }

    protected boolean hasRole(String username, String role) {
        if (this.hasRoleInDevMode(username, role)) {
            return true;
        }
        if (role.equalsIgnoreCase("LOGGED_IN")) {
            return !U.isEmpty((String)username);
        }
        String roleConfig = "role-" + role.toLowerCase();
        return !U.isEmpty((String)username) && Conf.contains((String)roleConfig, (String)username);
    }

    public boolean isAdmin(String username) {
        return this.hasRole(username, "ADMIN", null, null);
    }

    public boolean isManager(String username) {
        return this.hasRole(username, "MANAGER", null, null);
    }

    public boolean isModerator(String username) {
        return this.hasRole(username, "MODERATOR", null, null);
    }

    public DataPermissions classPermissions(String username, Class<?> clazz) {
        return DataPermissions.ALL;
    }

    public DataPermissions recordPermissions(String username, Object record) {
        return DataPermissions.ALL;
    }

    public DataPermissions propertyPermissions(String username, Object record, String propertyName) {
        return DataPermissions.ALL;
    }

    public boolean isOwnerOf(String username, Object record) {
        if (U.isEmpty((String)username) || record == null) {
            return false;
        }
        Object owner = Beany.getPropValue((Object)record, (String)"createdBy", null);
        return owner instanceof String && username.equalsIgnoreCase((String)owner);
    }

    public boolean isSharedWith(String username, Object record) {
        if (U.isEmpty((String)username) || record == null) {
            return false;
        }
        Object sharedWith = Beany.getPropValue((Object)record, (String)"sharedWith", null);
        if (sharedWith != null && sharedWith instanceof Collection) {
            for (Object user : (Collection)sharedWith) {
                if (!username.equalsIgnoreCase((String)Beany.getPropValue(user, (String)"username", (Object)""))) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getBuiltInRoles() {
        return CommonRoles.ALL;
    }

    public List<String> getUserRoles(String username) {
        List roles = U.list((Object[])new String[0]);
        for (String role : this.getBuiltInRoles()) {
            if (!this.hasRole(username, role)) continue;
            roles.add(role);
        }
        return roles;
    }
}

