/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.plugins.templates;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.FragmentKey;
import com.github.mustachejava.Mustache;
import com.google.common.cache.LoadingCache;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.rapidoid.config.Conf;
import org.rapidoid.io.IO;
import org.rapidoid.io.Res;
import org.rapidoid.log.Log;
import org.rapidoid.util.U;

public class RapidoidMustacheFactory
extends DefaultMustacheFactory {
    private static final String SM = "(~";
    private static final String EM = "~)";
    private volatile LoadingCache<String, Mustache> mustacheCache;
    private volatile LoadingCache<FragmentKey, Mustache> lambdaCache;
    private final ThreadLocal<Map<String, Mustache>> partialCache = new ThreadLocal<Map<String, Mustache>>(){

        @Override
        protected Map<String, Mustache> initialValue() {
            return new HashMap<String, Mustache>();
        }
    };

    protected LoadingCache<String, Mustache> createMustacheCache() {
        this.mustacheCache = super.createMustacheCache();
        return this.mustacheCache;
    }

    protected LoadingCache<FragmentKey, Mustache> createLambdaCache() {
        this.lambdaCache = super.createLambdaCache();
        return this.lambdaCache;
    }

    public Mustache compile(String name) {
        String filename = IO.getRealOrDefaultFilename((String)name);
        Log.debug((String)"Compiling template", (String)"name", (Object)filename);
        return this.customCompile(filename);
    }

    public Mustache compilePartial(String name) {
        String filename = IO.getRealOrDefaultFilename((String)name);
        Log.debug((String)"Compiling partial", (String)"name", (Object)filename);
        return this.customCompile(filename);
    }

    public Mustache compile(Reader reader, String file, String sm, String em) {
        throw U.notExpected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mustache customCompile(String filename) {
        Map<String, Mustache> cache = this.partialCache.get();
        try {
            Mustache mustache = cache.get(filename);
            if (mustache == null) {
                mustache = this.mc.compile(this.getReader(filename), filename, SM, EM);
                cache.put(filename, mustache);
                mustache.init();
            }
            Mustache mustache2 = mustache;
            return mustache2;
        }
        finally {
            cache.remove(filename);
        }
    }

    public Mustache compile(Reader reader, String name) {
        return super.compile(reader, name, SM, EM);
    }

    public void invalidateCache() {
        this.mustacheCache.invalidateAll();
        this.lambdaCache.invalidateAll();
    }

    public Reader getReader(String resourceName) {
        String filename = resourceName;
        String firstFile = Conf.templatesPath() + "/" + filename;
        String defaultFile = Conf.templatesPathDefault() + "/" + filename;
        return Res.from((String)filename, (boolean)true, (String[])new String[]{firstFile, defaultFile}).getReader();
    }
}

