/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.plugins.templates;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.DefaultMustacheVisitor;
import com.github.mustachejava.FragmentKey;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheVisitor;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.ValueCode;
import com.google.common.cache.LoadingCache;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.rapidoid.config.Conf;
import org.rapidoid.io.Res;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.log.Log;
import org.rapidoid.plugins.templates.CustomObjectHandler;
import org.rapidoid.u.U;

public class RapidoidMustacheFactory
extends DefaultMustacheFactory {
    private static final String SM = "{{";
    private static final String EM = "}}";
    private static final ObjectHandler CUSTOM_OBJECT_HANDLER = new CustomObjectHandler();
    private static final String EXPR_REGEX = "\\$\\$([\\w\\.]+?)\\$\\$";
    private static final Mapper<String[], String> EXPR_REPLACER = new Mapper<String[], String>(){

        public String map(String[] groups) throws Exception {
            return "\\{\\{" + groups[1] + "\\}\\}";
        }
    };
    private volatile LoadingCache<String, Mustache> mustacheCache;
    private volatile LoadingCache<FragmentKey, Mustache> lambdaCache;
    private final ThreadLocal<Map<String, Mustache>> partialCache = new ThreadLocal<Map<String, Mustache>>(){

        @Override
        protected Map<String, Mustache> initialValue() {
            return new HashMap<String, Mustache>();
        }
    };

    public RapidoidMustacheFactory() {
        this.setObjectHandler(CUSTOM_OBJECT_HANDLER);
    }

    protected LoadingCache<String, Mustache> createMustacheCache() {
        this.mustacheCache = super.createMustacheCache();
        return this.mustacheCache;
    }

    protected LoadingCache<FragmentKey, Mustache> createLambdaCache() {
        this.lambdaCache = super.createLambdaCache();
        return this.lambdaCache;
    }

    public Mustache compile(String name) {
        return this.compileIfChanged(name, false);
    }

    private Mustache compileIfChanged(String filename, boolean partial) {
        Mustache template = (Mustache)this.mustacheCache.getIfPresent((Object)filename);
        if (template == null) {
            String desc = partial ? "partial" : "template";
            Log.info((String)("Compiling Mustache " + desc), (String)"name", (Object)filename);
            Res res = this.getResource(filename, partial);
            template = this.customCompile(filename, res);
            res.onChange("mustache", new Runnable(){

                @Override
                public void run() {
                    RapidoidMustacheFactory.this.invalidateCache();
                }
            }).trackChanges();
            this.mustacheCache.put((Object)filename, (Object)template);
        }
        return template;
    }

    public Mustache compilePartial(String name) {
        return this.compileIfChanged(name, true);
    }

    public Mustache compile(Reader reader, String file, String sm, String em) {
        throw U.notExpected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mustache customCompile(String filename, Res resource) {
        Map<String, Mustache> cache = this.partialCache.get();
        try {
            Mustache mustache = cache.get(filename);
            if (mustache == null) {
                String template = RapidoidMustacheFactory.preprocess(resource.getContent());
                InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(template.getBytes()));
                mustache = this.mc.compile((Reader)reader, filename, SM, EM);
                cache.put(filename, mustache);
                mustache.init();
            }
            Mustache mustache2 = mustache;
            return mustache2;
        }
        finally {
            cache.remove(filename);
        }
    }

    public static String preprocess(String template) {
        template = U.replace((String)template, (String)EXPR_REGEX, EXPR_REPLACER);
        return template;
    }

    public Mustache compile(Reader reader, String name) {
        return super.compile(reader, name, SM, EM);
    }

    public void invalidateCache() {
        Log.info((String)"Invalidating Mustache cache");
        this.mustacheCache.invalidateAll();
        this.lambdaCache.invalidateAll();
    }

    public Reader getReader(String resourceName) {
        return this.getResource(resourceName, false).getReader();
    }

    private Res getResource(String filename, boolean partial) {
        String sub = partial ? "/partials/" : "/templates/";
        String firstFile = Conf.rootPath() + sub + filename;
        String defaultFile = Conf.rootPathDefault() + sub + filename;
        return Res.from((String)filename, (boolean)true, (String[])new String[]{firstFile, defaultFile});
    }

    public MustacheVisitor createMustacheVisitor() {
        return new DefaultMustacheVisitor(this){

            public void value(TemplateContext tc, String var, boolean encoded) {
                this.list.add(new ValueCode(tc, this.df, var, encoded){

                    public Writer execute(Writer writer, Object[] scopes) {
                        try {
                            Object object = this.get(scopes);
                            if (object == null) {
                                this.identity(writer);
                                return writer;
                            }
                            return super.execute(writer, scopes);
                        }
                        catch (Exception e) {
                            throw new MustacheException("Failed to get value for " + this.name, (Throwable)e, this.tc);
                        }
                    }
                });
            }
        };
    }
}

