/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.util.LogLevel;

public class U {
    public static final LogLevel TRACE = LogLevel.TRACE;
    public static final LogLevel DEBUG = LogLevel.DEBUG;
    public static final LogLevel INFO = LogLevel.INFO;
    public static final LogLevel WARN = LogLevel.WARN;
    public static final LogLevel ERROR = LogLevel.ERROR;
    public static final LogLevel SEVERE = LogLevel.SEVERE;
    protected static LogLevel LOG_LEVEL = INFO;
    protected static final Random RND = new Random();
    private static Appendable LOG_OUTPUT = System.out;
    private static ScheduledThreadPoolExecutor EXECUTOR;
    private static long measureStart;
    protected static String[] ARGS;
    private static Properties CONFIG;
    private static Pattern JRE_CLASS_PATTERN;
    private static Pattern CAMEL_SPLITTER_PATTERN;

    private U() {
    }

    public static synchronized void setLogLevel(LogLevel logLevel) {
        LOG_LEVEL = logLevel;
    }

    public static synchronized LogLevel getLogLevel() {
        return LOG_LEVEL;
    }

    private static String getCallingClass() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (int i = 2; i < trace.length; ++i) {
            String cls = trace[i].getClassName();
            if (cls.equals(U.class.getCanonicalName())) continue;
            return cls;
        }
        return U.class.getCanonicalName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(Appendable out, LogLevel level, String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, int paramsN) {
        if (level.ordinal() >= LOG_LEVEL.ordinal()) {
            try {
                Appendable appendable = out;
                synchronized (appendable) {
                    out.append(level.name());
                    out.append(" | ");
                    out.append(Thread.currentThread().getName());
                    out.append(" | ");
                    out.append(U.getCallingClass());
                    out.append(" | ");
                    out.append(msg);
                    switch (paramsN) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            U.printKeyValue(out, key1, value1);
                            break;
                        }
                        case 2: {
                            U.printKeyValue(out, key1, value1);
                            U.printKeyValue(out, key2, value2);
                            break;
                        }
                        case 3: {
                            U.printKeyValue(out, key1, value1);
                            U.printKeyValue(out, key2, value2);
                            U.printKeyValue(out, key3, value3);
                            break;
                        }
                        default: {
                            throw U.notExpected();
                        }
                    }
                    out.append('\n');
                }
            }
            catch (IOException e) {
                throw U.rte(e);
            }
        }
    }

    private static void printKeyValue(Appendable out, String key, Object value) throws IOException {
        out.append(" | ");
        out.append(key);
        out.append("=");
        out.append(U.text(value));
        if (value instanceof Throwable) {
            Throwable err = (Throwable)value;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            err.printStackTrace(new PrintStream(stream));
            out.append("\n");
            out.append(stream.toString());
        }
    }

    public static synchronized void setLogOutput(Appendable logOutput) {
        LOG_OUTPUT = logOutput;
    }

    private static void log(LogLevel level, String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, int paramsN) {
        U.log(LOG_OUTPUT, level, msg, key1, value1, key2, value2, key3, value3, paramsN);
    }

    public static void trace(String msg) {
        U.log(TRACE, msg, null, null, null, null, null, null, 0);
    }

    public static void trace(String msg, String key, Object value) {
        U.log(TRACE, msg, key, value, null, null, null, null, 1);
    }

    public static void trace(String msg, String key1, Object value1, String key2, Object value2) {
        U.log(TRACE, msg, key1, value1, key2, value2, null, null, 2);
    }

    public static void trace(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        U.log(TRACE, msg, key1, value1, key2, value2, key3, value3, 3);
    }

    public static void debug(String msg) {
        U.log(DEBUG, msg, null, null, null, null, null, null, 0);
    }

    public static void debug(String msg, String key, Object value) {
        U.log(DEBUG, msg, key, value, null, null, null, null, 1);
    }

    public static void debug(String msg, String key1, Object value1, String key2, Object value2) {
        U.log(DEBUG, msg, key1, value1, key2, value2, null, null, 2);
    }

    public static void debug(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        U.log(DEBUG, msg, key1, value1, key2, value2, key3, value3, 3);
    }

    public static void info(String msg) {
        U.log(INFO, msg, null, null, null, null, null, null, 0);
    }

    public static void info(String msg, String key, Object value) {
        U.log(INFO, msg, key, value, null, null, null, null, 1);
    }

    public static void info(String msg, String key1, Object value1, String key2, Object value2) {
        U.log(INFO, msg, key1, value1, key2, value2, null, null, 2);
    }

    public static void info(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        U.log(INFO, msg, key1, value1, key2, value2, key3, value3, 3);
    }

    public static void warn(String msg) {
        U.log(WARN, msg, null, null, null, null, null, null, 0);
    }

    public static void warn(String msg, String key, Object value) {
        U.log(WARN, msg, key, value, null, null, null, null, 1);
    }

    public static void warn(String msg, String key1, Object value1, String key2, Object value2) {
        U.log(WARN, msg, key1, value1, key2, value2, null, null, 2);
    }

    public static void warn(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        U.log(WARN, msg, key1, value1, key2, value2, key3, value3, 3);
    }

    public static void warn(String msg, Throwable error) {
        U.warn(msg, "error", error);
    }

    public static void error(String msg) {
        U.log(ERROR, msg, null, null, null, null, null, null, 0);
    }

    public static void error(String msg, String key, Object value) {
        U.log(ERROR, msg, key, value, null, null, null, null, 1);
    }

    public static void error(String msg, String key1, Object value1, String key2, Object value2) {
        U.log(ERROR, msg, key1, value1, key2, value2, null, null, 2);
    }

    public static void error(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        U.log(ERROR, msg, key1, value1, key2, value2, key3, value3, 3);
    }

    public static void error(String msg, Throwable error) {
        U.error(msg, "error", error);
    }

    public static void error(Throwable error) {
        U.error("error occured!", "error", error);
    }

    public static void severe(String msg) {
        U.log(SEVERE, msg, null, null, null, null, null, null, 0);
    }

    public static void severe(String msg, String key, Object value) {
        U.log(SEVERE, msg, key, value, null, null, null, null, 1);
    }

    public static void severe(String msg, String key1, Object value1, String key2, Object value2) {
        U.log(SEVERE, msg, key1, value1, key2, value2, null, null, 2);
    }

    public static void severe(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        U.log(SEVERE, msg, key1, value1, key2, value2, key3, value3, 3);
    }

    public static void severe(String msg, Throwable error) {
        U.severe(msg, "error", error);
    }

    public static String text(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof Object[]) {
            return U.text((Object[])obj);
        }
        return String.valueOf(obj);
    }

    public static String text(Object[] objs) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < objs.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(U.text(objs[i]));
        }
        sb.append("]");
        return sb.toString();
    }

    public static RuntimeException rte(String message, Object ... args) {
        return new RuntimeException(U.format(message, args));
    }

    public static RuntimeException rte(Throwable cause) {
        return new RuntimeException(cause);
    }

    public static RuntimeException rte(String message) {
        return new RuntimeException(message);
    }

    public static RuntimeException notExpected() {
        return U.rte("This operation is not expected to be called!");
    }

    public static IllegalArgumentException illegalArg(String message) {
        return new IllegalArgumentException(message);
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw U.rte(e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        for (Constructor<?> constr : clazz.getConstructors()) {
            Class<?>[] paramTypes = constr.getParameterTypes();
            if (!U.areAssignable(paramTypes, args)) continue;
            try {
                return (T)constr.newInstance(args);
            }
            catch (Exception e) {
                throw U.rte(e);
            }
        }
        throw U.rte("Cannot find appropriate constructor for %s with args %s!", clazz, U.text(args));
    }

    public static boolean areAssignable(Class<?>[] types, Object[] values) {
        if (types.length != values.length) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            Object val = values[i];
            if (val == null || U.instanceOf(val, types[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> T or(T value, T fallback) {
        return value != null ? value : fallback;
    }

    public static String format(String s, Object ... args) {
        return String.format(s, args);
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new ThreadDeath();
        }
    }

    public static boolean waitInterruption(long millis) {
        try {
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitFor(Object obj) {
        try {
            Object object = obj;
            synchronized (object) {
                obj.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void joinThread(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String text(Collection<Object> coll) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (Object obj : coll) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(U.text(obj));
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public static String text(Iterator<?> it) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                sb.append(", ");
                first = false;
            }
            sb.append(U.text(it.next()));
        }
        sb.append("]");
        return sb.toString();
    }

    public static String textln(Object[] objs) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < objs.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("\n  ");
            sb.append(U.text(objs[i]));
        }
        sb.append("\n]");
        return sb.toString();
    }

    public static String replaceText(String s, String[][] repls) {
        for (String[] repl : repls) {
            s = s.replaceAll(Pattern.quote(repl[0]), repl[1]);
        }
        return s;
    }

    public static String join(String sep, Object ... items) {
        return U.render(items, "%s", sep);
    }

    public static String join(String sep, Iterable<?> items) {
        return U.render(items, "%s", sep);
    }

    public static String join(String sep, char[][] items) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(items[i]);
        }
        return sb.toString();
    }

    public static String render(Object[] items, String itemFormat, String sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(U.format(itemFormat, items[i]));
        }
        return sb.toString();
    }

    public static String render(Iterable<?> items, String itemFormat, String sep) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Object item : items) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(U.format(itemFormat, item));
            ++i;
        }
        return sb.toString();
    }

    public static <T> T[] array(T ... items) {
        return items;
    }

    public static <T> Set<T> set(T ... values) {
        HashSet<T> set = new HashSet<T>();
        for (T val : values) {
            set.add(val);
        }
        return set;
    }

    public static <T> List<T> list(T ... values) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : values) {
            list.add(item);
        }
        return list;
    }

    public static <K, V> Map<K, V> map() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> map(K key, V value) {
        Map<K, V> map = U.map();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> map(K key1, V value1, K key2, V value2) {
        Map<K, V> map = U.map(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <K, V> Map<K, V> map(K key1, V value1, K key2, V value2, K key3, V value3) {
        Map<K, V> map = U.map(key1, value1, key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static <K, V> Map<K, V> map(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        Map<K, V> map = U.map(key1, value1, key2, value2, key3, value3);
        map.put(key4, value4);
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> Map<K, V> autoExpandingMap(final Class<V> clazz) {
        return U.autoExpandingMap(new Mapper<K, V>(){

            @Override
            public V map(K src) throws Exception {
                return U.newInstance(clazz);
            }
        });
    }

    public static <K, V> Map<K, V> autoExpandingMap(final Mapper<K, V> valueFactory) {
        return new ConcurrentHashMap<K, V>(){

            @Override
            public synchronized V get(Object key) {
                Object val = super.get(key);
                if (val == null) {
                    try {
                        val = valueFactory.map(key);
                    }
                    catch (Exception e) {
                        throw U.rte(e);
                    }
                    this.put(key, val);
                }
                return val;
            }
        };
    }

    public static <T> Queue<T> queue(int maxSize) {
        return maxSize > 0 ? new ArrayBlockingQueue(maxSize) : new ConcurrentLinkedQueue();
    }

    public static <FROM, TO> Mapper<FROM, TO> mapper(final Map<FROM, TO> map) {
        return new Mapper<FROM, TO>(){

            @Override
            public TO map(FROM key) throws Exception {
                return map.get(key);
            }
        };
    }

    public static URL resource(String filename) {
        return U.classLoader().getResource(filename);
    }

    public static ClassLoader classLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static Enumeration<URL> resources(String name) {
        if ((name = name.replace('.', '/')).equals("*")) {
            name = "";
        }
        try {
            return U.classLoader().getResources(name);
        }
        catch (IOException e) {
            throw U.rte("Cannot scan: " + name, e);
        }
    }

    public static File file(String filename) {
        URL res;
        File file = new File(filename);
        if (!file.exists() && (res = U.resource(filename)) != null) {
            return new File(res.getFile());
        }
        return file;
    }

    public static long time() {
        return System.currentTimeMillis();
    }

    public static boolean xor(boolean a, boolean b) {
        return a && !b || b && !a;
    }

    public static boolean eq(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static void failIf(boolean failureCondition, String msg) {
        if (failureCondition) {
            throw U.rte(msg);
        }
    }

    public static void failIf(boolean failureCondition, String msg, Object ... args) {
        if (failureCondition) {
            throw U.rte(msg, args);
        }
    }

    public static byte[] loadBytes(InputStream input) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try {
            int readN = 0;
            while ((readN = input.read(buffer)) != -1) {
                output.write(buffer, 0, readN);
            }
        }
        catch (IOException e) {
            throw U.rte(e);
        }
        return output.toByteArray();
    }

    public static byte[] loadBytes(String filename) {
        File file;
        InputStream input = U.classLoader().getResourceAsStream(filename);
        if (input == null && (file = new File(filename)).exists()) {
            try {
                input = new FileInputStream(filename);
            }
            catch (FileNotFoundException e) {
                throw U.rte(e);
            }
        }
        return input != null ? U.loadBytes(input) : null;
    }

    public static byte[] classBytes(String fullClassName) {
        return U.loadBytes(fullClassName.replace('.', '/') + ".class");
    }

    public static String load(String filename) {
        byte[] bytes = U.loadBytes(filename);
        return bytes != null ? new String(bytes) : null;
    }

    public static List<String> loadLines(String filename) {
        InputStream input = U.classLoader().getResourceAsStream(filename);
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        List<Object> lines = U.list(new Object[0]);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw U.rte(e);
        }
        return lines;
    }

    public static List<String> loadLines(String filename, boolean filterEmpty, String commentPrefix) {
        List<String> lines = U.loadLines(filename);
        List<Object> lines2 = U.list(new Object[0]);
        for (String line : lines) {
            String s = line.trim();
            if (filterEmpty && s.isEmpty() || commentPrefix != null && s.startsWith(commentPrefix)) continue;
            lines2.add(s);
        }
        return lines2;
    }

    public static void save(String filename, String content) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filename);
            out.write(content.getBytes());
            U.close(out, false);
        }
        catch (Exception e) {
            U.close(out, true);
            throw U.rte(e);
        }
    }

    public static void close(OutputStream out, boolean quiet) {
        block2: {
            try {
                out.close();
            }
            catch (IOException e) {
                if (quiet) break block2;
                throw U.rte(e);
            }
        }
    }

    public static void close(InputStream in, boolean quiet) {
        block2: {
            try {
                in.close();
            }
            catch (IOException e) {
                if (quiet) break block2;
                throw U.rte(e);
            }
        }
    }

    public static void delete(String filename) {
        new File(filename).delete();
    }

    public static <T> T[] expand(T[] arr, int factor) {
        int len = arr.length;
        arr = Arrays.copyOf(arr, len * factor);
        return arr;
    }

    public static <T> T[] expand(T[] arr, T item) {
        int len = arr.length;
        arr = Arrays.copyOf(arr, len + 1);
        arr[len] = item;
        return arr;
    }

    public static <T> T[] subarray(T[] arr, int from, int to) {
        int end;
        int start = from >= 0 ? from : arr.length + from;
        int n = end = to >= 0 ? to : arr.length + to;
        if (start < 0) {
            start = 0;
        }
        if (end > arr.length - 1) {
            end = arr.length - 1;
        }
        U.must(start <= end, "Invalid range: expected form <= to!");
        int size = end - start + 1;
        T[] part = Arrays.copyOf(arr, size);
        System.arraycopy(arr, start, part, 0, size);
        return part;
    }

    public static boolean must(boolean expectedCondition, String message) {
        if (!expectedCondition) {
            throw U.rte(message);
        }
        return true;
    }

    public static String copyNtimes(String s, int n) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static RuntimeException rte(String message, Throwable cause, Object ... args) {
        return new RuntimeException(U.format(message, args), cause);
    }

    public static RuntimeException rte(String message, Throwable cause) {
        return new RuntimeException(message, cause);
    }

    public static boolean must(boolean expectedCondition) {
        if (!expectedCondition) {
            throw U.rte("Expectation failed!");
        }
        return true;
    }

    public static boolean must(boolean expectedCondition, String message, long arg) {
        if (!expectedCondition) {
            throw U.rte(message, arg);
        }
        return true;
    }

    public static boolean must(boolean expectedCondition, String message, Object arg) {
        if (!expectedCondition) {
            throw U.rte(message, U.text(arg));
        }
        return true;
    }

    public static boolean must(boolean expectedCondition, String message, Object arg1, Object arg2) {
        if (!expectedCondition) {
            throw U.rte(message, U.text(arg1), U.text(arg2));
        }
        return true;
    }

    public static void secure(boolean condition, String msg, Object arg) {
        if (!condition) {
            throw new SecurityException(U.format(msg, arg));
        }
    }

    public static void secure(boolean condition, String msg, Object arg1, Object arg2) {
        if (!condition) {
            throw new SecurityException(U.format(msg, arg1, arg2));
        }
    }

    public static void notNullAll(Object ... items) {
        for (int i = 0; i < items.length; ++i) {
            if (items[i] != null) continue;
            throw U.rte("The item[%s] must NOT be null!", i);
        }
    }

    public static <T> T notNull(T value, String desc, Object ... descArgs) {
        if (value == null) {
            throw U.rte("%s must NOT be null!", U.format(desc, descArgs));
        }
        return value;
    }

    public static RuntimeException notReady() {
        return U.rte("Not yet implemented!");
    }

    public static RuntimeException notSupported() {
        return U.rte("This operation is not supported by this implementation!");
    }

    public static void show(Object ... values) {
        String text = values.length == 1 ? U.text(values[0]) : U.text(values);
        U.print(">" + text + "<");
    }

    public static synchronized void schedule(Runnable task, long delay) {
        if (EXECUTOR == null) {
            EXECUTOR = new ScheduledThreadPoolExecutor(3);
        }
        EXECUTOR.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public static void startMeasure() {
        measureStart = U.time();
    }

    public static void endMeasure() {
        long delta = U.time() - measureStart;
        U.show(delta + " ms");
    }

    public static void endMeasure(String info) {
        long delta = U.time() - measureStart;
        U.show(info + ": " + delta + " ms");
    }

    public static void print(Object value) {
        System.out.println(value);
    }

    public static void printAll(Collection<?> collection) {
        for (Object item : collection) {
            U.print(item);
        }
    }

    public static boolean hasOption(String name) {
        U.notNull(ARGS, "command line arguments", new Object[0]);
        for (String op : ARGS) {
            if (!op.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static String option(String name, String defaultValue) {
        U.notNull(ARGS, "command line arguments", new Object[0]);
        for (String op : ARGS) {
            if (!op.startsWith(name + "=")) continue;
            return op.substring(name.length() + 1);
        }
        return defaultValue;
    }

    public static int option(String name, int defaultValue) {
        String n = U.option(name, null);
        return n != null ? Integer.parseInt(n) : defaultValue;
    }

    public static long optionL(String name, long defaultValue) {
        String n = U.option(name, null);
        return n != null ? Long.parseLong(n) : defaultValue;
    }

    public static double option(String name, double defaultValue) {
        String n = U.option(name, null);
        return n != null ? Double.parseDouble(n) : defaultValue;
    }

    public static int cpus() {
        return U.option("cpus", Runtime.getRuntime().availableProcessors());
    }

    public static boolean micro() {
        return U.hasOption("micro");
    }

    public static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static String capitalized(String s) {
        return s.isEmpty() ? s : s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String mid(String s, int beginIndex, int endIndex) {
        if (endIndex < 0) {
            endIndex = s.length() + endIndex;
        }
        return s.substring(beginIndex, endIndex);
    }

    public static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw U.rte(e);
        }
    }

    public static String mul(String s, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static int num(String s) {
        return Integer.parseInt(s);
    }

    public static String bytesToString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    private static MessageDigest digest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw U.rte("Cannot find algorithm: " + algorithm);
        }
    }

    public static String md5(byte[] bytes) {
        MessageDigest md5 = U.digest("MD5");
        md5.update(bytes);
        return U.bytesToString(md5.digest());
    }

    public static String md5(String data) {
        return U.md5(data.getBytes());
    }

    public static char rndChar() {
        return (char)(65 + U.rnd(26));
    }

    public static String rndStr(int length) {
        return U.rndStr(length, length);
    }

    public static String rndStr(int minLength, int maxLength) {
        int len = minLength + U.rnd(maxLength - minLength + 1);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append(U.rndChar());
        }
        return sb.toString();
    }

    public static int rnd(int n) {
        return RND.nextInt(n);
    }

    public static int rndExcept(int n, int except) {
        if (n > 1 || except != 0) {
            int num;
            while ((num = RND.nextInt(n)) == except) {
            }
            return num;
        }
        throw new RuntimeException("Cannot produce such number!");
    }

    public static <T> T rnd(T[] arr) {
        return arr[U.rnd(arr.length)];
    }

    public static int rnd() {
        return RND.nextInt();
    }

    public static long rndL() {
        return RND.nextLong();
    }

    public static MappedByteBuffer mmap(String filename, FileChannel.MapMode mode, long position, long size) {
        try {
            File file = new File(filename);
            FileChannel fc = new RandomAccessFile(file, "rw").getChannel();
            return fc.map(mode, position, size);
        }
        catch (Exception e) {
            throw U.rte(e);
        }
    }

    public static MappedByteBuffer mmap(String filename, FileChannel.MapMode mode) {
        File file = new File(filename);
        U.must(file.exists());
        return U.mmap(filename, mode, 0L, file.length());
    }

    public static Class<?> getClassIfExists(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean production() {
        return U.hasOption("production");
    }

    public static synchronized String config(String name) {
        if (CONFIG == null) {
            CONFIG = new Properties();
            try {
                URL config = U.resource("config");
                if (config != null) {
                    CONFIG.load(config.openStream());
                }
                if ((config = U.resource("config.private")) != null) {
                    CONFIG.load(config.openStream());
                }
            }
            catch (IOException e) {
                throw U.rte("Cannot load config!", e);
            }
        }
        return CONFIG.getProperty(name);
    }

    public static String fillIn(String template, String placeholder, String value) {
        return template.replaceAll("\\{\\{" + placeholder + "\\}\\}", value);
    }

    public static ByteBuffer expand(ByteBuffer buf, int newSize) {
        ByteBuffer buf2 = ByteBuffer.allocate(newSize);
        ByteBuffer buff = buf.duplicate();
        buff.rewind();
        buff.limit(buff.capacity());
        buf2.put(buff);
        return buf2;
    }

    public static ByteBuffer expand(ByteBuffer buf) {
        int cap = buf.capacity();
        cap = cap <= 1000 ? (cap *= 10) : (cap <= 10000 ? (cap *= 5) : (cap *= 2));
        return U.expand(buf, cap);
    }

    public static String buf2str(ByteBuffer buf) {
        ByteBuffer buf2 = buf.duplicate();
        buf2.rewind();
        buf2.limit(buf2.capacity());
        byte[] bytes = new byte[buf2.capacity()];
        buf2.get(bytes);
        return new String(bytes);
    }

    public static ByteBuffer buf(String s) {
        byte[] bytes = s.getBytes();
        ByteBuffer buf = ByteBuffer.allocateDirect(bytes.length);
        buf.put(bytes);
        buf.rewind();
        return buf;
    }

    public static synchronized void args(String ... args) {
        if (args != null) {
            ARGS = args;
            if (U.hasOption("debug") && U.getLogLevel().ordinal() > DEBUG.ordinal()) {
                U.setLogLevel(DEBUG);
            }
            for (String arg : args) {
                if (!arg.matches("\\w+")) continue;
                U.hook(arg);
            }
        }
    }

    public static Object hook(String hookName) {
        U.must(hookName.matches("\\w+"), "Invalid hook name, must be alphanumeric!");
        String hookClassName = "org.rapidoid.hook." + U.capitalized(hookName) + "Hook";
        Class<?> hookCls = U.getClassIfExists(hookClassName);
        if (hookCls != null) {
            if (Callable.class.isAssignableFrom(hookCls)) {
                Callable hook = (Callable)U.newInstance(hookCls);
                try {
                    Object hookResult = hook.call();
                    U.info("Executed a hook", "hook", hookName, "hookClass", hookClassName, "result", hookResult);
                    return hookResult;
                }
                catch (Exception e) {
                    throw U.rte(e);
                }
            }
            U.warn("Found a hook, but it's not a Runnable!", "hook", hookName, "hookClass", hookClassName);
        } else {
            U.debug("No hook was found", "hook", hookName, "hookClass", hookClassName);
        }
        return null;
    }

    public static void benchmark(String name, int count, Runnable runnable) {
        long start = U.time();
        for (int i = 0; i < count; ++i) {
            runnable.run();
        }
        U.benchmarkComplete(name, count, start);
    }

    public static void benchmarkComplete(String name, int count, long startTime) {
        double avg;
        long end = U.time();
        long ms = end - startTime;
        if (ms == 0L) {
            ms = 1L;
        }
        String avgs = (avg = (double)count / (double)ms) > 1.0 ? Math.round(avg) + "K" : Math.round(avg * 1000.0) + "";
        String data = U.format("%s: %s in %s ms (%s/sec)", name, count, ms, avgs);
        U.print(data + " | " + U.getCpuMemStats());
    }

    public static void benchmarkMT(int threadsN, final String name, int count, final CountDownLatch outsideLatch, final Runnable runnable) {
        U.eq(count % threadsN, 0);
        final int countPerThread = count / threadsN;
        final CountDownLatch latch = outsideLatch != null ? outsideLatch : new CountDownLatch(threadsN);
        long time = U.time();
        for (int i = 1; i <= threadsN; ++i) {
            new Thread(){

                @Override
                public void run() {
                    U.benchmark(name, countPerThread, runnable);
                    if (outsideLatch == null) {
                        latch.countDown();
                    }
                }
            }.start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw U.rte(e);
        }
        U.benchmarkComplete("avg(" + name + ")", threadsN * countPerThread, time);
    }

    public static void benchmarkMT(int threadsN, String name, int count, Runnable runnable) {
        U.benchmarkMT(threadsN, name, count, null, runnable);
    }

    public static String getCpuMemStats() {
        Runtime rt = Runtime.getRuntime();
        long totalMem = rt.totalMemory();
        long maxMem = rt.maxMemory();
        long freeMem = rt.freeMemory();
        long usedMem = totalMem - freeMem;
        int megs = 0x100000;
        String msg = "MEM [total=%s MB, used=%s MB, max=%s MB]";
        return U.format(msg, totalMem / (long)megs, usedMem / (long)megs, maxMem / (long)megs);
    }

    public static String replace(String s, String regex, Mapper<String[], String> replacer) {
        StringBuffer output = new StringBuffer();
        Pattern p = Pattern.compile(regex);
        Matcher matcher = p.matcher(s);
        while (matcher.find()) {
            int len = matcher.groupCount() + 1;
            String[] gr = new String[len];
            for (int i = 0; i < gr.length; ++i) {
                gr[i] = matcher.group(i);
            }
            matcher.appendReplacement(output, U.eval(replacer, gr));
        }
        matcher.appendTail(output);
        return output.toString();
    }

    public static <T> boolean eval(Predicate<T> predicate, T target) {
        try {
            return predicate.eval(target);
        }
        catch (Exception e) {
            throw U.rte("Cannot evaluate predicate %s on target: %s", e, predicate, target);
        }
    }

    public static <FROM, TO> TO eval(Mapper<FROM, TO> mapper, FROM src) {
        try {
            return mapper.map(src);
        }
        catch (Exception e) {
            throw U.rte("Cannot evaluate mapper %s on target: %s", e, mapper, src);
        }
    }

    public static List<Class<?>> classpathClasses(String packageName, String nameRegex, Predicate<Class<?>> filter, ClassLoader classLoader) {
        Pattern regex = Pattern.compile(nameRegex);
        ArrayList classes = new ArrayList();
        Enumeration<URL> urls = U.resources(packageName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            File file = new File(url.getFile());
            U.getClasses(classes, file, file, regex, filter, classLoader);
        }
        return classes;
    }

    public static List<Class<?>> classpathClassesByName(String simpleName, Predicate<Class<?>> filter, ClassLoader classLoader) {
        List<Class<?>> classes = U.classpathClasses("*", ".*\\." + simpleName, filter, classLoader);
        if (classes.isEmpty()) {
            U.warn("No classes found on classpath with the specified simple name", "name", simpleName);
        }
        return classes;
    }

    public static List<Class<?>> classpathClassesBySuffix(String nameSuffix, Predicate<Class<?>> filter, ClassLoader classLoader) {
        List<Class<?>> classes = U.classpathClasses("*", ".+" + nameSuffix, filter, classLoader);
        if (classes.isEmpty()) {
            U.warn("No classes found on classpath with the specified suffix", "suffix", nameSuffix);
        }
        return classes;
    }

    public static List<File> classpath(String packageName, Predicate<File> filter) {
        ArrayList<File> files = new ArrayList<File>();
        U.classpath(packageName, files, filter);
        return files;
    }

    public static void classpath(String packageName, Collection<File> files, Predicate<File> filter) {
        Enumeration<URL> urls = U.resources(packageName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            File file = new File(url.getFile());
            U.getFiles(files, file, filter);
        }
    }

    private static void getFiles(Collection<File> files, File file, Predicate<File> filter) {
        if (file.isDirectory()) {
            U.debug("scanning directory", "dir", file);
            for (File f : file.listFiles()) {
                if (f.isDirectory()) {
                    U.getFiles(files, f, filter);
                    continue;
                }
                U.debug("scanned file", "file", f);
                try {
                    if (filter != null && !filter.eval(f)) continue;
                    files.add(f);
                }
                catch (Exception e) {
                    throw U.rte(e);
                }
            }
        }
    }

    private static void getClasses(Collection<Class<?>> classes, File root, File parent, Pattern nameRegex, Predicate<Class<?>> filter, ClassLoader classLoader) {
        if (parent.isDirectory()) {
            U.debug("scanning directory", "dir", parent);
            for (File f : parent.listFiles()) {
                if (f.isDirectory()) {
                    U.getClasses(classes, root, f, nameRegex, filter, classLoader);
                    continue;
                }
                U.debug("scanned file", "file", f);
                try {
                    Class<?> cls;
                    if (!f.getName().endsWith(".class")) continue;
                    String clsName = f.getAbsolutePath();
                    String rootPath = root.getAbsolutePath();
                    U.must(clsName.startsWith(rootPath));
                    clsName = clsName.substring(rootPath.length() + 1, clsName.length() - 6);
                    clsName = clsName.replace(File.separatorChar, '.');
                    if (!nameRegex.matcher(clsName).matches()) continue;
                    U.debug("loading class", "name", clsName);
                    Class<?> clazz = cls = classLoader != null ? Class.forName(clsName, true, classLoader) : Class.forName(clsName);
                    if (filter != null && !filter.eval(cls)) continue;
                    classes.add(cls);
                }
                catch (Exception e) {
                    throw U.rte(e);
                }
            }
        }
    }

    public static boolean isJREClass(String canonicalClassName) {
        return JRE_CLASS_PATTERN.matcher(canonicalClassName).matches();
    }

    public static boolean instanceOf(Object obj, Class<?> ... classes) {
        if (obj == null) {
            return false;
        }
        Class<?> objClass = obj.getClass();
        for (Class<?> clazz : classes) {
            if (!clazz.isAssignableFrom(objClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Object arrOrColl, Object value) {
        if (arrOrColl instanceof Object[]) {
            Object[] arr = (Object[])arrOrColl;
            return U.indexOf(arr, value) >= 0;
        }
        if (arrOrColl instanceof Collection) {
            Collection coll = (Collection)arrOrColl;
            return coll.contains(value);
        }
        throw U.illegalArg("Expected array or collection!");
    }

    public static Object include(Object arrOrColl, Object item) {
        if (arrOrColl instanceof Object[]) {
            Object[] arr = (Object[])arrOrColl;
            return U.indexOf(arr, item) < 0 ? U.expand(arr, item) : arr;
        }
        if (arrOrColl instanceof Collection) {
            Collection coll = (Collection)arrOrColl;
            if (!coll.contains(item)) {
                coll.add(item);
            }
            return coll;
        }
        throw U.illegalArg("Expected array or collection!");
    }

    public static Object exclude(Object arrOrColl, Object item) {
        if (arrOrColl instanceof Object[]) {
            Object[] arr = (Object[])arrOrColl;
            int ind = U.indexOf(arr, item);
            return ind >= 0 ? U.deleteAt(arr, ind) : arr;
        }
        if (arrOrColl instanceof Collection) {
            Collection coll = (Collection)arrOrColl;
            if (coll.contains(item)) {
                coll.remove(item);
            }
            return coll;
        }
        throw U.illegalArg("Expected array or collection!");
    }

    private static int indexOf(Object[] arr, Object value) {
        for (int i = 0; i < arr.length; ++i) {
            if (!U.eq(arr[i], value)) continue;
            return i;
        }
        return -1;
    }

    private static Object[] deleteAt(Object[] arr, int index) {
        Object[] res = new Object[arr.length - 1];
        if (index > 0) {
            System.arraycopy(arr, 0, res, 0, index);
        }
        if (index < arr.length - 1) {
            System.arraycopy(arr, index + 1, res, index, res.length - index);
        }
        return res;
    }

    public static String camelSplit(String s) {
        return CAMEL_SPLITTER_PATTERN.matcher(s).replaceAll(" ");
    }

    public static String camelPhrase(String s) {
        return U.capitalized(U.camelSplit(s).toLowerCase());
    }

    static {
        ARGS = new String[0];
        CONFIG = null;
        JRE_CLASS_PATTERN = Pattern.compile("^(java|javax|javafx|com\\.sun|sun|com\\.oracle|oracle|jdk|org\\.omg|org\\.w3c).*");
        CAMEL_SPLITTER_PATTERN = Pattern.compile("(?<=[A-Z])(?=[A-Z][a-z])|(?<=[^A-Z])(?=[A-Z])|(?<=[A-Za-z])(?=[^A-Za-z])");
    }
}

