/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.rapidoid.lambda.Dynamic;
import org.rapidoid.lambda.Mapper;

public class U {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public static String readable(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof Object[]) {
            return U.readable((Object[])obj);
        }
        return String.valueOf(obj);
    }

    public static String readable(Object[] objs) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < objs.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(U.readable(objs[i]));
        }
        sb.append("]");
        return sb.toString();
    }

    public static String format(String s, Object ... args) {
        return String.format(s, args);
    }

    public static String nice(String format, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = U.readable(args[i]);
        }
        return String.format(format, args);
    }

    public static String readable(Iterable<Object> coll) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (Object obj : coll) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(U.readable(obj));
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public static String readable(Iterator<?> it) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                sb.append(", ");
                first = false;
            }
            sb.append(U.readable(it.next()));
        }
        sb.append("]");
        return sb.toString();
    }

    public static String readableln(Object[] objs) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < objs.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("\n  ");
            sb.append(U.readable(objs[i]));
        }
        sb.append("\n]");
        return sb.toString();
    }

    public static String replaceText(String s, String[][] repls) {
        for (String[] repl : repls) {
            s = s.replaceAll(Pattern.quote(repl[0]), repl[1]);
        }
        return s;
    }

    public static void print(Object ... values) {
        String text = values != null ? (values.length == 1 ? U.readable(values[0]) : U.readable(values)) : "null";
        System.out.println(text);
    }

    public static <T> String join(String sep, T ... items) {
        return U.render(items, "%s", sep);
    }

    public static String join(String sep, Iterable<?> items) {
        return U.render(items, "%s", sep);
    }

    public static String join(String sep, char[][] items) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(items[i]);
        }
        return sb.toString();
    }

    public static String render(Object[] items, String itemFormat, String sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(U.nice(itemFormat, items[i]));
        }
        return sb.toString();
    }

    public static String render(Iterable<?> items, String itemFormat, String sep) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Object item : items) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(U.nice(itemFormat, item));
            ++i;
        }
        return sb.toString();
    }

    public static <T> Iterator<T> iterator(T[] arr) {
        return Arrays.asList(arr).iterator();
    }

    public static <T> T[] array(T ... items) {
        return items;
    }

    public static Object[] array(Iterable<?> items) {
        return items instanceof Collection ? ((Collection)items).toArray() : U.list(items).toArray();
    }

    public static <T> Set<T> synchronizedSet() {
        return Collections.synchronizedSet(U.<T>set());
    }

    public static <T> Set<T> set() {
        return new LinkedHashSet();
    }

    public static <T> Set<T> set(Iterable<? extends T> values) {
        Set<T> set = U.set();
        for (T val : values) {
            set.add(val);
        }
        return set;
    }

    public static <T> Set<T> set(T ... values) {
        Set<T> set = U.set();
        for (T val : values) {
            set.add(val);
        }
        return set;
    }

    public static <T> List<T> synchronizedList() {
        return Collections.synchronizedList(U.<T>list());
    }

    public static <T> List<T> list() {
        return new ArrayList();
    }

    public static <T> List<T> list(Iterable<? extends T> values) {
        List<T> list = U.list();
        for (T item : values) {
            list.add(item);
        }
        return list;
    }

    public static <T> List<T> list(T ... values) {
        List<T> list = U.list();
        for (T item : values) {
            list.add(item);
        }
        return list;
    }

    public static <K, V> Map<K, V> map() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> map(Map<? extends K, ? extends V> src) {
        Map<? extends K, ? extends V> map = U.map();
        map.putAll(src);
        return map;
    }

    public static <K, V> Map<K, V> map(K key, V value) {
        Map<K, V> map = U.map();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> map(K key1, V value1, K key2, V value2) {
        Map<K, V> map = U.map(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <K, V> Map<K, V> map(K key1, V value1, K key2, V value2, K key3, V value3) {
        Map<K, V> map = U.map(key1, value1, key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static <K, V> Map<K, V> map(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        Map<K, V> map = U.map(key1, value1, key2, value2, key3, value3);
        map.put(key4, value4);
        return map;
    }

    public static <K, V> Map<K, V> map(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        Map<K, V> map = U.map(key1, value1, key2, value2, key3, value3, key4, value4);
        map.put(key5, value5);
        return map;
    }

    public static <K, V> Map<K, V> map(Object ... keysAndValues) {
        U.must(keysAndValues.length % 2 == 0, "Incorrect number of arguments (expected key-value pairs)!");
        Map<Object, Object> map = U.map();
        for (int i = 0; i < keysAndValues.length / 2; ++i) {
            map.put(keysAndValues[i * 2], keysAndValues[i * 2 + 1]);
        }
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(Map<? extends K, ? extends V> src, boolean ignoreNullValues) {
        ConcurrentMap<K, V> map = U.concurrentMap();
        for (Map.Entry<K, V> e : src.entrySet()) {
            if (ignoreNullValues && e.getValue() == null) continue;
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(K key, V value) {
        ConcurrentMap<K, V> map = U.concurrentMap();
        map.put(key, value);
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(K key1, V value1, K key2, V value2) {
        ConcurrentMap<K, V> map = U.concurrentMap(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(K key1, V value1, K key2, V value2, K key3, V value3) {
        ConcurrentMap<K, V> map = U.concurrentMap(key1, value1, key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        ConcurrentMap<K, V> map = U.concurrentMap(key1, value1, key2, value2, key3, value3);
        map.put(key4, value4);
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        ConcurrentMap<K, V> map = U.concurrentMap(key1, value1, key2, value2, key3, value3, key4, value4);
        map.put(key5, value5);
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(Object ... keysAndValues) {
        U.must(keysAndValues.length % 2 == 0, "Incorrect number of arguments (expected key-value pairs)!");
        ConcurrentMap<Object, Object> map = U.concurrentMap();
        for (int i = 0; i < keysAndValues.length / 2; ++i) {
            map.put(keysAndValues[i * 2], keysAndValues[i * 2 + 1]);
        }
        return map;
    }

    public static <K, V> Map<K, V> orderedMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> orderedMap(Map<? extends K, ? extends V> src, boolean ignoreNullValues) {
        Map<K, V> map = U.orderedMap();
        for (Map.Entry<K, V> e : src.entrySet()) {
            if (ignoreNullValues && e.getValue() == null) continue;
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    public static <K, V> Map<K, V> orderedMap(K key, V value) {
        Map<K, V> map = U.orderedMap();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> orderedMap(K key1, V value1, K key2, V value2) {
        Map<K, V> map = U.orderedMap(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <K, V> Map<K, V> orderedMap(K key1, V value1, K key2, V value2, K key3, V value3) {
        Map<K, V> map = U.orderedMap(key1, value1, key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static <K, V> Map<K, V> orderedMap(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        Map<K, V> map = U.orderedMap(key1, value1, key2, value2, key3, value3);
        map.put(key4, value4);
        return map;
    }

    public static <K, V> Map<K, V> orderedMap(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        Map<K, V> map = U.orderedMap(key1, value1, key2, value2, key3, value3, key4, value4);
        map.put(key5, value5);
        return map;
    }

    public static <K, V> Map<K, V> orderedMap(Object ... keysAndValues) {
        U.must(keysAndValues.length % 2 == 0, "Incorrect number of arguments (expected key-value pairs)!");
        Map<Object, Object> map = U.orderedMap();
        for (int i = 0; i < keysAndValues.length / 2; ++i) {
            map.put(keysAndValues[i * 2], keysAndValues[i * 2 + 1]);
        }
        return map;
    }

    public static <K, V> Map<K, V> synchronizedMap() {
        return Collections.synchronizedMap(U.<K, V>map());
    }

    public static <T> Queue<T> queue() {
        return new ConcurrentLinkedQueue();
    }

    public static <T> BlockingQueue<T> queue(int maxSize) {
        U.argMust(maxSize > 0, "Maximum queue size must be > 0!", new Object[0]);
        return new ArrayBlockingQueue(maxSize);
    }

    public static <T> T or(T value, T fallback) {
        return value != null ? value : fallback;
    }

    public static String safe(String s) {
        return U.or(s, "");
    }

    public static Object[] safe(Object[] arr) {
        return U.or(arr, EMPTY_ARRAY);
    }

    public static <T> List<T> safe(List<T> list) {
        return U.or(list, Collections.EMPTY_LIST);
    }

    public static <T> Set<T> safe(Set<T> list) {
        return U.or(list, Collections.EMPTY_SET);
    }

    public static <K, V> Map<K, V> safe(Map<K, V> list) {
        return U.or(list, Collections.EMPTY_MAP);
    }

    public static long time() {
        return System.currentTimeMillis();
    }

    public static boolean xor(boolean a, boolean b) {
        return a && !b || b && !a;
    }

    public static boolean eq(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public static RuntimeException rte(String message) {
        return new RuntimeException(message);
    }

    public static RuntimeException rte(String message, Throwable cause) {
        return new RuntimeException(message, cause);
    }

    public static RuntimeException rte(Throwable cause) {
        return U.rte("", cause);
    }

    public static RuntimeException rte(String message, Object ... args) {
        return U.rte(U.nice(message, args));
    }

    public static RuntimeException cancelled() {
        return U.rte("This operation was cancelled!");
    }

    public static RuntimeException notExpected() {
        return U.rte("This operation is not expected to be called!");
    }

    public static void rteIf(boolean failureCondition, String msg) {
        if (failureCondition) {
            throw U.rte(msg);
        }
    }

    public static boolean must(boolean expectedCondition, String message) {
        if (!expectedCondition) {
            throw U.rte(message);
        }
        return true;
    }

    public static RuntimeException rte(String message, Throwable cause, Object ... args) {
        return U.rte(U.nice(message, args), cause);
    }

    public static boolean must(boolean expectedCondition) {
        if (!expectedCondition) {
            throw U.rte("Expectation failed!");
        }
        return true;
    }

    public static boolean must(boolean expectedCondition, String message, long arg) {
        if (!expectedCondition) {
            throw U.rte(message, arg);
        }
        return true;
    }

    public static boolean must(boolean expectedCondition, String message, Object arg) {
        if (!expectedCondition) {
            throw U.rte(message, U.readable(arg));
        }
        return true;
    }

    public static boolean must(boolean expectedCondition, String message, Object arg1, Object arg2) {
        if (!expectedCondition) {
            throw U.rte(message, U.readable(arg1), U.readable(arg2));
        }
        return true;
    }

    public static boolean must(boolean expectedCondition, String message, Object arg1, Object arg2, Object arg3) {
        if (!expectedCondition) {
            throw U.rte(message, U.readable(arg1), U.readable(arg2), U.readable(arg3));
        }
        return true;
    }

    public static IllegalArgumentException illegalArg(String message, Object ... args) {
        return new IllegalArgumentException(U.format(message, args));
    }

    public static void secure(boolean condition, String msg) {
        if (!condition) {
            throw new SecurityException(U.readable(msg));
        }
    }

    public static void secure(boolean condition, String msg, Object arg) {
        if (!condition) {
            throw new SecurityException(U.nice(msg, arg));
        }
    }

    public static void secure(boolean condition, String msg, Object arg1, Object arg2) {
        if (!condition) {
            throw new SecurityException(U.nice(msg, arg1, arg2));
        }
    }

    public static void bounds(int value, int min, int max) {
        U.must(value >= min && value <= max, "%s is not in the range [%s, %s]!", value, min, max);
    }

    public static void notNullAll(Object ... items) {
        for (int i = 0; i < items.length; ++i) {
            if (items[i] != null) continue;
            throw U.rte("The item[%s] must NOT be null!", i);
        }
    }

    public static <T> T notNull(T value, String msgOrDesc, Object ... descArgs) {
        if (value == null) {
            if (msgOrDesc.endsWith("!")) {
                throw U.rte(msgOrDesc, descArgs);
            }
            throw U.rte("%s must NOT be null!", U.nice(msgOrDesc, descArgs));
        }
        return value;
    }

    public static RuntimeException notReady() {
        return U.rte("Not yet implemented!");
    }

    public static RuntimeException notSupported() {
        return U.rte("This operation is not supported by this implementation!");
    }

    public static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static boolean isEmpty(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isEmpty(Iterable<?> iter) {
        return iter.iterator().hasNext();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return U.isEmpty((String)value);
        }
        if (value instanceof Object[]) {
            return U.isEmpty((Object[])value);
        }
        if (value instanceof Collection) {
            return U.isEmpty((Collection)value);
        }
        if (value instanceof Map) {
            return U.isEmpty((Map)value);
        }
        if (value instanceof Iterable) {
            return U.isEmpty((Iterable)value);
        }
        return false;
    }

    public static String capitalized(String s) {
        return s.isEmpty() ? s : s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String uncapitalized(String s) {
        return s.isEmpty() ? s : s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static String copyNtimes(String s, int n) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String mid(String s, int beginIndex, int endIndex) {
        if (endIndex < 0) {
            endIndex = s.length() + endIndex;
        }
        return s.substring(beginIndex, endIndex);
    }

    public static String insert(String target, int atIndex, String insertion) {
        return target.substring(0, atIndex) + insertion + target.substring(atIndex);
    }

    public static int num(String s) {
        return Integer.parseInt(s);
    }

    public static int limited(int min, int value, int max) {
        return Math.min(Math.max(min, value), max);
    }

    public static <T> T single(Iterable<T> coll) {
        Iterator<T> it = coll.iterator();
        U.must(it.hasNext(), "Expected exactly 1 item, but didn't find any!");
        T item = it.next();
        U.must(!it.hasNext(), "Expected exactly 1 item, but found more than 1!");
        return item;
    }

    public static <T> T singleOrNone(Iterable<T> coll) {
        Iterator<T> it = coll.iterator();
        T item = it.hasNext() ? (T)it.next() : null;
        U.must(!it.hasNext(), "Expected 0 or 1 items, but found more than 1!");
        return item;
    }

    public static <T> int compare(T val1, T val2) {
        if (val1 == null && val2 == null) {
            return 0;
        }
        if (val1 == null) {
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return ((Comparable)val1).compareTo(val2);
    }

    public static <T> List<T> range(Iterable<T> items, int fromIndex, int toIndex) {
        List<T> list = U.list(items);
        fromIndex = U.limited(0, fromIndex, list.size());
        toIndex = U.limited(fromIndex, toIndex, list.size());
        return U.list(list.subList(fromIndex, toIndex));
    }

    public static <T> List<T> page(Iterable<T> items, int page, int pageSize) {
        return U.range(items, (page - 1) * pageSize, page * pageSize);
    }

    public static String trimr(String s, char suffix) {
        return !s.isEmpty() && s.charAt(s.length() - 1) == suffix ? U.mid(s, 0, -1) : s;
    }

    public static String trimr(String s, String suffix) {
        return s.endsWith(suffix) ? U.mid(s, 0, -suffix.length()) : s;
    }

    public static String triml(String s, char prefix) {
        return !s.isEmpty() && s.charAt(0) == prefix ? s.substring(1) : s;
    }

    public static String triml(String s, String prefix) {
        return s.startsWith(prefix) ? s.substring(prefix.length()) : s;
    }

    public static String bytesAsText(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static void argMust(boolean expectedCondition, String message, Object ... args) {
        if (!expectedCondition) {
            throw U.illegalArg(message, args);
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
    }

    public static <K, V> Map<K, V> autoExpandingMap(final Class<?> clazz) {
        return U.autoExpandingMap(new Mapper<K, V>(){

            @Override
            public V map(K src) throws Exception {
                try {
                    return clazz.newInstance();
                }
                catch (Exception e) {
                    throw U.rte(e);
                }
            }
        });
    }

    public static <K, V> Map<K, V> autoExpandingMap(final Mapper<K, V> valueFactory) {
        return Collections.synchronizedMap(new HashMap<K, V>(){

            @Override
            public synchronized V get(Object key) {
                Object val = super.get(key);
                if (val == null) {
                    try {
                        val = valueFactory.map(key);
                    }
                    catch (Exception e) {
                        throw U.rte(e);
                    }
                    this.put(key, val);
                }
                return val;
            }
        });
    }

    public static <K1, K2, V> Map<K1, Map<K2, V>> mapOfMaps() {
        return U.autoExpandingMap(new Mapper<K1, Map<K2, V>>(){

            @Override
            public Map<K2, V> map(K1 src) throws Exception {
                return U.synchronizedMap();
            }
        });
    }

    public static <K, V> Map<K, List<V>> mapOfLists() {
        return U.autoExpandingMap(new Mapper<K, List<V>>(){

            @Override
            public List<V> map(K src) throws Exception {
                return Collections.synchronizedList(U.list());
            }
        });
    }

    public static <K, V> Map<K, Set<V>> mapOfSets() {
        return U.autoExpandingMap(new Mapper<K, Set<V>>(){

            @Override
            public Set<V> map(K src) throws Exception {
                return Collections.synchronizedSet(U.set());
            }
        });
    }

    public static <T> T cast(Object value) {
        return (T)value;
    }

    public static void wait(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
    }

    public static void wait(CountDownLatch latch, long timeout, TimeUnit unit) {
        try {
            latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
    }

    public static <T> T dynamic(final Class<T> targetInterface, final Dynamic dynamic) {
        final Object obj = new Object();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().equals(Object.class)) {
                    if (method.getName().equals("toString")) {
                        return targetInterface.getSimpleName() + "@" + Integer.toHexString(obj.hashCode());
                    }
                    return method.invoke(obj, args);
                }
                return dynamic.call(method, U.safe(args));
            }
        };
        return (T)Proxy.newProxyInstance(targetInterface.getClassLoader(), new Class[]{targetInterface}, handler);
    }

    public static <T> T evalJS(String js) throws ScriptException {
        return U.evalJS(js, null);
    }

    public static <T> T evalJS(String js, Map<String, ?> bindings) throws ScriptException {
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("JavaScript");
        if (bindings != null) {
            Map map = (Map)U.cast(bindings);
            return (T)engine.eval(js, (Bindings)new SimpleBindings(map));
        }
        return (T)engine.eval(js);
    }

    public static CompiledScript compileJS(String js) throws ScriptException {
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("JavaScript");
        U.must(engine instanceof Compilable, "The JavaScript engine cannot compile!");
        Compilable compilable = (Compilable)((Object)engine);
        return compilable.compile(js);
    }
}

