/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.io.watch;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.rapidoid.log.Log;

public class ClassReloader
extends ClassLoader {
    private final List<String> names;
    private final ClassLoader parent;
    private final String dir;
    private final long createdOn = System.currentTimeMillis();

    public ClassReloader(String dir, ClassLoader parent, List<String> names) {
        super(parent);
        this.dir = dir;
        this.parent = parent;
        this.names = names;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String filename = null;
        File ff = new File(this.dir, ClassReloader.getClassRelativePath(name));
        if (ff.exists()) {
            filename = ff.getAbsolutePath();
        } else {
            URL res = this.parent.getResource(ClassReloader.getClassRelativePath(name));
            if (res != null) {
                try {
                    filename = res.toURI().getPath();
                }
                catch (URISyntaxException e2) {
                    e2.printStackTrace();
                }
            }
        }
        if (filename != null) {
            try {
                Log.info((String)"Hot swap", (String)"file", (Object)filename);
                try {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception res) {
                        // empty catch block
                    }
                    byte[] classData = this.readFile(new File(filename));
                    return this.defineClass(name, classData, 0, classData.length);
                }
                catch (ClassFormatError e) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    byte[] classData = this.readFile(new File(filename));
                    return this.defineClass(name, classData, 0, classData.length);
                }
            }
            catch (Exception e) {
                throw new ClassNotFoundException("Couldn't find class: " + name);
            }
        }
        return super.findClass(name);
    }

    private byte[] readFile(File file) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(file));
            byte[] bytes = new byte[16384];
            int read = -1;
            while ((read = stream.read(bytes)) != -1) {
                output.write(bytes, 0, read);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public Class<?> loadClass(String classname) throws ClassNotFoundException {
        Log.info((String)"Loading class", (String)"name", (Object)classname);
        if (this.inDir(classname) || this.names.contains(classname)) {
            try {
                return this.findClass(classname);
            }
            catch (ClassNotFoundException e) {
                Class<?> fallbackClass = super.loadClass(classname);
                Log.info((String)"Couldn't reload class, fallback load", (String)"name", (Object)classname);
                return fallbackClass;
            }
        }
        return super.loadClass(classname);
    }

    private boolean inDir(String classname) {
        return new File(this.dir, ClassReloader.getClassRelativePath(classname)).exists();
    }

    private static String getClassRelativePath(String classname) {
        return classname.replace('.', File.separatorChar) + ".class";
    }

    public void add(List<String> classnames) {
        this.names.addAll(classnames);
    }

    public long getCreatedOn() {
        return this.createdOn;
    }
}

