/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.io.watch;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.rapidoid.io.Res;
import org.rapidoid.io.watch.FilesystemChangeListener;
import org.rapidoid.io.watch.Watch;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.log.Log;
import org.rapidoid.util.U;

public class Dir
implements FilesystemChangeListener {
    private static final ScheduledExecutorService EXECUTORS = Executors.newScheduledThreadPool(8);
    private static final Map<String, Dir> DIRS = U.autoExpandingMap((Mapper)new Mapper<String, Dir>(){

        public Dir map(String path) throws Exception {
            return new Dir(path);
        }
    });
    private final String path;
    private final File dir;
    private final Set<Res> files = U.set();
    private final Set<String> folders = U.set();
    private boolean dirty = true;

    public static Dir from(String path) {
        return DIRS.get(path);
    }

    private Dir(String path) {
        this.path = path;
        this.dir = new File(path);
        Watch.dir(path, this);
        this.refresh();
    }

    public synchronized String toString() {
        return U.format((String)"Dir(%s, %d files, %d folders)", (Object[])new Object[]{this.path, this.files.size(), this.folders.size()});
    }

    @Override
    public void created(String filename) {
        this.refreshLater();
    }

    @Override
    public void modified(String filename) {
        this.refreshLater();
    }

    @Override
    public void deleted(String filename) {
        this.refreshLater();
    }

    public synchronized void refresh() {
        if (!this.dirty) {
            return;
        }
        Log.info((String)"Refreshing dir", (String)"path", (Object)this.path);
        this.files.clear();
        this.folders.clear();
        Dir.traverse(Paths.get(this.path, new String[0]), (FileVisitor<Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Dir.this.files.add(Res.from((String)file.toAbsolutePath().toString()));
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String dirPath = dir.toAbsolutePath().toString();
                if (!dirPath.equals(Dir.this.path)) {
                    Dir.this.folders.add(dirPath);
                }
                return super.preVisitDirectory(dir, attrs);
            }
        });
        Log.info((String)"Refreshed folder content", (String)"files", this.files, (String)"folders", this.folders);
        this.dirty = false;
    }

    public synchronized Set<Res> files() {
        return this.files;
    }

    public synchronized Set<String> folders() {
        return this.folders;
    }

    private synchronized void refreshLater() {
        this.dirty = true;
        EXECUTORS.schedule(new Runnable(){

            @Override
            public void run() {
                Dir.this.refresh();
            }
        }, 500L, TimeUnit.MILLISECONDS);
    }

    public synchronized boolean exists() {
        return this.dir.exists();
    }

    public static void traverse(Path root, FileVisitor<Path> visitor) {
        try {
            Files.walkFileTree(root, visitor);
        }
        catch (IOException e) {
            Log.error((String)("Error occured while traversing the directory tree: " + root));
        }
    }
}

