/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.io.watch;

import java.io.File;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.rapidoid.activity.AbstractLoopThread;
import org.rapidoid.io.watch.ClassRefresher;
import org.rapidoid.io.watch.Reload;
import org.rapidoid.log.Log;
import org.rapidoid.util.U;

public class WatchingRefresherThread
extends AbstractLoopThread {
    private final ClassRefresher refresher;
    private final Set<String> filenames = U.set();
    private final String dir;
    private final Queue<String> queue;

    public WatchingRefresherThread(String dir, Queue<String> queue, ClassRefresher refresher) {
        this.dir = dir;
        this.queue = queue;
        this.refresher = refresher;
    }

    protected void loop() {
        String filename;
        boolean found = false;
        while ((filename = this.queue.poll()) != null) {
            this.filenames.add(filename);
            found = true;
        }
        if (!found && !this.filenames.isEmpty()) {
            this.reload(this.filenames);
            this.filenames.clear();
        }
        U.sleep((long)100L);
    }

    protected void reload(Set<String> filenames) {
        Log.info((String)"Reloading classes", (String)"classes", filenames);
        try {
            List<String> classnames = WatchingRefresherThread.filenamesToClassnames(this.dir, filenames);
            List<Class<?>> classes = Reload.reloadClasses(this.dir, classnames);
            this.refresher.refresh(classes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String filenameToClassname(String dir, String filename) {
        if (filename.endsWith(".class") && filename.startsWith(dir + File.separatorChar)) {
            return filename.substring(dir.length() + 1, filename.length() - 6).replace(File.separatorChar, '.');
        }
        if (filename.endsWith(".class") && filename.startsWith(dir + "/")) {
            return filename.substring(dir.length() + 1, filename.length() - 6).replace('/', '.');
        }
        return null;
    }

    private static List<String> filenamesToClassnames(String dir, Set<String> filenames) {
        List list = U.list();
        for (String filename : filenames) {
            String classname = WatchingRefresherThread.filenameToClassname(dir, filename);
            if (classname == null) continue;
            list.add(classname);
        }
        return list;
    }
}

