/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.io.watch;

import java.util.Queue;
import org.rapidoid.io.watch.ClassRefresher;
import org.rapidoid.io.watch.FilesystemChangeListener;
import org.rapidoid.io.watch.FilesystemChangeQueueListener;
import org.rapidoid.io.watch.WatcherThread;
import org.rapidoid.io.watch.WatchingRefresherThread;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class Watch {
    private final WatcherThread watcher;

    public Watch(String dir, FilesystemChangeListener changes) {
        this.watcher = new WatcherThread(changes, dir, true);
        this.watcher.start();
    }

    public static Watch dir(String dir, FilesystemChangeListener changes) {
        try {
            return new Watch(dir, changes);
        }
        catch (Throwable e) {
            Log.error((String)"Couldn't watch for changes!", (Throwable)e);
            return null;
        }
    }

    public static Watch dir(String dir, ClassRefresher refresher) {
        try {
            Queue queue = U.queue();
            FilesystemChangeQueueListener changes = new FilesystemChangeQueueListener(queue);
            new WatchingRefresherThread(dir, queue, refresher).start();
            return Watch.dir(dir, changes);
        }
        catch (Throwable e) {
            Log.error((String)"Couldn't watch for changes!", (Throwable)e);
            return null;
        }
    }

    public void stop() {
        this.watcher.interrupt();
    }
}

