/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.io.watch;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.rapidoid.activity.AbstractLoopThread;
import org.rapidoid.io.watch.Dir;
import org.rapidoid.io.watch.FilesystemChangeListener;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class WatcherThread
extends AbstractLoopThread {
    private final Map<WatchKey, Path> keys = U.map();
    private final FilesystemChangeListener onChange;
    private final String path;
    private final File file;
    private final boolean recursive;
    private volatile WatchService watcher;

    public WatcherThread(FilesystemChangeListener change, String path, boolean recursive) {
        this.onChange = change;
        this.path = path;
        this.recursive = recursive;
        this.file = new File(path);
        this.setName("watcher");
    }

    private void startWatching() {
        Path dir = Paths.get(this.path, new String[0]);
        if (this.recursive) {
            this.startWatchingTree(dir);
        } else {
            this.startWatching(dir);
        }
    }

    private void startWatching(Path dir) {
        Log.info((String)"Watching directory for changes", (String)"dir", (Object)this.path, (String)"recursive", (Object)this.recursive);
        try {
            if (this.watcher == null) {
                this.watcher = FileSystems.getDefault().newWatchService();
            }
            WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.keys.put(key, dir);
        }
        catch (IOException e) {
            Log.error((String)("Couldn't register to watch for changes on: " + dir), (Throwable)e);
        }
    }

    private void startWatchingTree(Path root) {
        try {
            Dir.traverse(root, (FileVisitor<Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    WatcherThread.this.startWatching(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            Log.warn((String)"Couldn't register a watch for the directory tree", (String)"dir", (Object)root);
        }
    }

    protected void loop() {
        WatchKey key;
        if (this.watcher == null) {
            if (this.file.exists()) {
                this.startWatching();
            } else {
                U.sleep((long)1000L);
                return;
            }
        }
        try {
            key = this.watcher.take();
        }
        catch (InterruptedException x) {
            throw new CancellationException();
        }
        Path dir = this.keys.get(key);
        if (dir == null) {
            return;
        }
        for (WatchEvent<?> event : key.pollEvents()) {
            Path child;
            WatchEvent.Kind<?> kind = event.kind();
            if (StandardWatchEventKinds.ENTRY_CREATE.equals(kind)) {
                child = this.getChild(dir, event);
                if (this.recursive && Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                    this.startWatchingTree(child);
                }
                this.onChange.created(this.fullNameOf(child));
                continue;
            }
            if (StandardWatchEventKinds.ENTRY_MODIFY.equals(kind)) {
                child = this.getChild(dir, event);
                this.onChange.modified(this.fullNameOf(child));
                continue;
            }
            if (StandardWatchEventKinds.ENTRY_DELETE.equals(kind)) {
                child = this.getChild(dir, event);
                this.onChange.deleted(this.fullNameOf(child));
                continue;
            }
            if (StandardWatchEventKinds.OVERFLOW.equals(kind)) {
                Log.warn((String)"Received OVERFLOW event from the Watch service!");
                continue;
            }
            throw U.notExpected();
        }
        boolean isKeyValid = key.reset();
        if (!isKeyValid) {
            this.keys.remove(key);
            if (this.keys.isEmpty()) {
                if (!this.file.exists()) {
                    Log.warn((String)"Cannot watch directory because it doesn't exist anymore", (String)"dir", (Object)dir);
                } else {
                    Log.error((String)"Cannot watch directory due to unknown reason!", (String)"dir", (Object)dir);
                }
                this.watcher = null;
            }
        }
    }

    private Path getChild(Path dir, WatchEvent<?> event) {
        WatchEvent ev = (WatchEvent)U.cast(event);
        Path path = (Path)ev.context();
        return dir.resolve(path);
    }

    private String fullNameOf(Path child) {
        return child.toAbsolutePath().toString();
    }
}

