/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.io.watch;

import java.util.Collection;
import java.util.Queue;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Coll;
import org.rapidoid.config.RapidoidInitializer;
import org.rapidoid.io.watch.ClassRefresher;
import org.rapidoid.io.watch.FilesystemChangeListener;
import org.rapidoid.io.watch.FilesystemChangeQueueListener;
import org.rapidoid.io.watch.WatcherThread;
import org.rapidoid.io.watch.WatchingRefresherThread;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class Watch
extends RapidoidThing {
    private final WatcherThread watcher;

    public Watch(Collection<String> folders, FilesystemChangeListener changes) {
        this.watcher = new WatcherThread(changes, folders, true);
        this.watcher.start();
    }

    public static Watch dirs(Collection<String> folders, FilesystemChangeListener changes) {
        try {
            return new Watch(folders, changes);
        }
        catch (Throwable e) {
            Log.error((String)"Couldn't watch for changes!", (Throwable)e);
            return null;
        }
    }

    public static Watch dir(String folder, FilesystemChangeListener changes) {
        return Watch.dirs((Collection<String>)U.list((Object[])new String[]{folder}), changes);
    }

    public static Watch dirs(Collection<String> folders, ClassRefresher refresher) {
        try {
            Queue created = Coll.queue();
            Queue modified = Coll.queue();
            Queue deleted = Coll.queue();
            FilesystemChangeQueueListener changes = new FilesystemChangeQueueListener(created, modified, deleted);
            new WatchingRefresherThread(folders, created, modified, deleted, refresher).start();
            return Watch.dirs(folders, changes);
        }
        catch (Throwable e) {
            Log.error((String)"Couldn't watch for changes!", (Throwable)e);
            return null;
        }
    }

    public static Watch dir(String folder, ClassRefresher changes) {
        return Watch.dirs((Collection<String>)U.list((Object[])new String[]{folder}), changes);
    }

    public void stop() {
        this.watcher.interrupt();
    }

    static {
        RapidoidInitializer.initialize();
    }
}

