/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.reload;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.rapidoid.cls.Cls;
import org.rapidoid.io.IO;
import org.rapidoid.log.Log;
import org.rapidoid.reload.OptionalJPAUtil;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class ClassReloader
extends ClassLoader {
    private final List<String> names;
    private final Collection<String> classpath;
    private final ClassLoader parent;

    public ClassReloader(Collection<String> classpath, ClassLoader parent, List<String> names) {
        super(parent);
        this.classpath = classpath;
        this.parent = parent;
        this.names = names;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String filename = this.getClassFilename(name);
        if (filename != null) {
            try {
                return super.findClass(name);
            }
            catch (ClassNotFoundException e) {
                Log.debug((String)"Hot swap", (String)"file", (Object)filename);
                return this.reload(name, filename);
            }
        }
        return super.findClass(name);
    }

    private Class<?> reload(String name, String filename) throws ClassNotFoundException {
        Log.debug((String)"Reloading class", (String)"name", (Object)name, (String)"filename", (Object)filename);
        for (int i = 0; i < 100; ++i) {
            try {
                byte[] classData = IO.loadBytes((String)filename);
                return this.defineClass(name, classData, 0, classData.length);
            }
            catch (ClassFormatError e) {
                U.sleep((long)50L);
                continue;
            }
        }
        throw new ClassNotFoundException("Couldn't find class: " + name);
    }

    private String getClassFilename(String name) {
        String filename = this.findOnClasspath(name);
        if (filename != null) {
            return filename;
        }
        URL res = this.parent.getResource(ClassReloader.getClassRelativePath(name));
        return res != null ? this.getFilename(res) : null;
    }

    private String findOnClasspath(String name) {
        for (String dir : this.classpath) {
            File classFile = new File(dir, ClassReloader.getClassRelativePath(name));
            if (!classFile.exists()) continue;
            return classFile.getAbsolutePath();
        }
        return null;
    }

    private String getFilename(URL res) {
        try {
            return res.toURI().getPath();
        }
        catch (URISyntaxException e) {
            throw U.rte((Throwable)e);
        }
    }

    @Override
    public Class<?> loadClass(String classname) throws ClassNotFoundException {
        Log.debug((String)"Loading class", (String)"name", (Object)classname);
        Class<?> cls = this.findLoadedClass(classname);
        if (cls != null) {
            return cls;
        }
        if (this.names.contains(classname) || !Cls.isRapidoidClass((String)classname) && !Cls.isJREClass((String)classname) && !this.isEntity(classname) && this.findOnClasspath(classname) != null) {
            try {
                return this.findClass(classname);
            }
            catch (ClassNotFoundException e) {
                Class<?> fallbackClass = super.loadClass(classname);
                Log.debug((String)"Couldn't reload class, fallback load", (String)"name", (Object)classname);
                return fallbackClass;
            }
        }
        return super.loadClass(classname);
    }

    private boolean isEntity(String classname) {
        return Msc.hasRapidoidJPA() && OptionalJPAUtil.isEntity(classname);
    }

    private static String getClassRelativePath(String classname) {
        return classname.replace('.', File.separatorChar) + ".class";
    }

    public void add(List<String> classnames) {
        this.names.addAll(classnames);
    }
}

