/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.io.watch;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import org.rapidoid.activity.AbstractLoopThread;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.Err;
import org.rapidoid.io.watch.Dir;
import org.rapidoid.io.watch.FilesystemChangeListener;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class WatcherThread
extends AbstractLoopThread {
    private static final AtomicInteger idGen = new AtomicInteger();
    private final Map<WatchKey, Path> keys = U.map();
    private final FilesystemChangeListener onChange;
    private final boolean recursive;
    private final WatchService watcher;
    private final List<String> folders = Coll.synchronizedList((Object[])new String[0]);
    private final Set<String> watching = Coll.synchronizedSet((Object[])new String[0]);

    public WatcherThread(FilesystemChangeListener change, Collection<String> targetFolders, boolean recursive) {
        this.onChange = change;
        this.recursive = recursive;
        for (String folder : targetFolders) {
            this.folders.add(new File(folder).getAbsolutePath());
        }
        this.setName("watcher" + idGen.incrementAndGet());
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw U.rte((String)"Couldn't create a file system watch service!", (Throwable)e);
        }
    }

    private void init() {
        for (String folder : this.folders) {
            this.init(folder);
        }
    }

    private void init(String folder) {
        if (!this.watching.contains(folder) && new File(folder).exists()) {
            Log.debug((String)"Watching folder for changes", (String)"folder", (Object)folder, (String)"recursive", (Object)this.recursive);
            Path dir = Paths.get(folder, new String[0]);
            if (this.recursive) {
                this.startWatchingTree(dir);
            } else {
                this.init(dir);
            }
            this.watching.add(folder);
        }
    }

    private void init(Path dir) {
        Log.debug((String)"Registering directory watch", (String)"dir", (Object)dir);
        try {
            WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            U.notNull((Object)key, (String)"watch key", (Object[])new Object[0]);
            this.keys.put(key, dir);
        }
        catch (IOException e) {
            Log.error((String)("Couldn't register to watch for changes on: " + dir), (Throwable)e);
        }
    }

    private void startWatchingTree(Path root) {
        try {
            Dir.traverse(root, (FileVisitor<Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    WatcherThread.this.init(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            Log.warn((String)"Couldn't register a watch for the directory tree", (String)"dir", (Object)root);
        }
    }

    protected void loop() {
        WatchKey key;
        this.init();
        try {
            key = this.watcher.take();
        }
        catch (InterruptedException x) {
            throw new CancellationException();
        }
        Path dir = this.keys.get(key);
        if (dir == null) {
            return;
        }
        for (WatchEvent<?> event : key.pollEvents()) {
            Path child;
            WatchEvent.Kind<?> kind = event.kind();
            if (StandardWatchEventKinds.ENTRY_CREATE.equals(kind)) {
                child = this.getChild(dir, event);
                if (this.recursive && Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                    this.startWatchingTree(child);
                }
                this.onChange.created(this.fullNameOf(child));
                continue;
            }
            if (StandardWatchEventKinds.ENTRY_MODIFY.equals(kind)) {
                child = this.getChild(dir, event);
                this.onChange.modified(this.fullNameOf(child));
                continue;
            }
            if (StandardWatchEventKinds.ENTRY_DELETE.equals(kind)) {
                child = this.getChild(dir, event);
                this.onChange.deleted(this.fullNameOf(child));
                continue;
            }
            if (StandardWatchEventKinds.OVERFLOW.equals(kind)) {
                Log.warn((String)"Received OVERFLOW event from the Watch service!");
                continue;
            }
            throw Err.notExpected();
        }
        boolean isKeyValid = key.reset();
        if (!isKeyValid) {
            this.keys.remove(key);
            if (this.keys.isEmpty()) {
                if (!dir.toFile().exists()) {
                    Log.warn((String)"Cannot watch directory because it doesn't exist anymore", (String)"dir", (Object)dir);
                } else {
                    Log.error((String)"Cannot watch directory due to unknown reason!", (String)"dir", (Object)dir);
                }
            }
            this.watching.remove(dir.toFile().getAbsolutePath());
        }
    }

    private Path getChild(Path dir, WatchEvent<?> event) {
        WatchEvent ev = (WatchEvent)U.cast(event);
        Path path = (Path)ev.context();
        return dir.resolve(path);
    }

    private String fullNameOf(Path child) {
        return child.toAbsolutePath().toString();
    }
}

