/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.io.watch;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.rapidoid.activity.AbstractLoopThread;
import org.rapidoid.io.watch.ClassRefresher;
import org.rapidoid.log.Log;
import org.rapidoid.reload.Reload;
import org.rapidoid.u.U;

public class WatchingRefresherThread
extends AbstractLoopThread {
    private static final AtomicInteger idGen = new AtomicInteger();
    private final ClassRefresher refresher;
    private final Set<String> createdFilenames = U.set();
    private final Set<String> modifiedFilenames = U.set();
    private final Set<String> deletedFilenames = U.set();
    private final Collection<String> folders;
    private final Queue<String> created;
    private final Queue<String> modified;
    private final Queue<String> deleted;

    public WatchingRefresherThread(Collection<String> folders, Queue<String> created, Queue<String> modified, Queue<String> deleted, ClassRefresher refresher) {
        this.folders = folders;
        this.created = created;
        this.modified = modified;
        this.deleted = deleted;
        this.refresher = refresher;
        this.setName("reloader" + idGen.incrementAndGet());
    }

    protected void loop() {
        String filename;
        boolean found = false;
        while ((filename = this.created.poll()) != null) {
            this.createdFilenames.add(filename);
            found = true;
        }
        while ((filename = this.modified.poll()) != null) {
            this.modifiedFilenames.add(filename);
            found = true;
        }
        while ((filename = this.deleted.poll()) != null) {
            this.deletedFilenames.add(filename);
            found = true;
        }
        if (!(found || this.createdFilenames.isEmpty() && this.modifiedFilenames.isEmpty() && this.deletedFilenames.isEmpty())) {
            this.reload();
            this.createdFilenames.clear();
            this.modifiedFilenames.clear();
            this.deletedFilenames.clear();
        }
        U.sleep((long)100L);
    }

    protected void reload() {
        Set filenames = U.set();
        filenames.addAll(this.createdFilenames);
        filenames.addAll(this.modifiedFilenames);
        Log.debug((String)"Detected changes in classes", (String)"created", this.createdFilenames, (String)"modified", this.modifiedFilenames, (String)"deleted", this.deletedFilenames);
        try {
            List<String> classnames = this.filenamesToClassnames(filenames);
            List<Class<?>> classes = Reload.reloadClasses(this.folders, classnames);
            this.refresher.refresh(classes, this.filenamesToClassnames(this.deletedFilenames));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String filenameToClassname(String filename) {
        for (String dir : this.folders) {
            if (filename.endsWith(".class") && filename.startsWith(dir + File.separatorChar)) {
                return filename.substring(dir.length() + 1, filename.length() - 6).replace(File.separatorChar, '.');
            }
            if (!filename.endsWith(".class") || !filename.startsWith(dir + "/")) continue;
            return filename.substring(dir.length() + 1, filename.length() - 6).replace('/', '.');
        }
        return null;
    }

    private List<String> filenamesToClassnames(Set<String> filenames) {
        List list = U.list();
        for (String filename : filenames) {
            String classname = this.filenameToClassname(filename);
            if (classname == null) continue;
            list.add(classname);
        }
        return list;
    }
}

