/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.io.watch;

import java.util.Collection;
import java.util.Queue;
import java.util.Set;
import org.rapidoid.collection.Coll;
import org.rapidoid.config.RapidoidInitializer;
import org.rapidoid.io.watch.ClassRefresher;
import org.rapidoid.io.watch.FilesystemChangeListener;
import org.rapidoid.io.watch.FilesystemChangeQueueListener;
import org.rapidoid.io.watch.WatcherThread;
import org.rapidoid.io.watch.WatchingRefresherThread;
import org.rapidoid.lambda.Operation;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class Watch
extends RapidoidInitializer {
    private static final Set<WatcherThread> WATCHERS = Coll.synchronizedSet((Object[])new WatcherThread[0]);

    public static WatcherThread dirs(Collection<String> folders, FilesystemChangeListener changes) {
        try {
            WatcherThread watcher = new WatcherThread(changes, folders, true);
            watcher.start();
            WATCHERS.add(watcher);
            return watcher;
        }
        catch (Throwable e) {
            Log.error((String)"Couldn't watch for changes!", (Throwable)e);
            return null;
        }
    }

    public static WatcherThread dir(String folder, FilesystemChangeListener changes) {
        return Watch.dirs((Collection<String>)U.list((Object[])new String[]{folder}), changes);
    }

    public static WatcherThread dirs(Collection<String> folders, ClassRefresher refresher) {
        try {
            Queue created = Coll.queue();
            Queue modified = Coll.queue();
            Queue deleted = Coll.queue();
            FilesystemChangeQueueListener changes = new FilesystemChangeQueueListener(created, modified, deleted);
            new WatchingRefresherThread(folders, created, modified, deleted, refresher).start();
            return Watch.dirs(folders, changes);
        }
        catch (Throwable e) {
            Log.error((String)"Couldn't watch for changes!", (Throwable)e);
            return null;
        }
    }

    public static WatcherThread dir(String folder, ClassRefresher changes) {
        return Watch.dirs((Collection<String>)U.list((Object[])new String[]{folder}), changes);
    }

    public static WatcherThread dirs(Collection<String> folders, Operation<String> changeListener) {
        return Watch.dirs(folders, Watch.simpleListener(changeListener));
    }

    public static WatcherThread dir(String folder, Operation<String> changeListener) {
        return Watch.dir(folder, Watch.simpleListener(changeListener));
    }

    public static FilesystemChangeListener simpleListener(final Operation<String> changeListener) {
        return new FilesystemChangeListener(){

            @Override
            public void created(String filename) throws Exception {
                changeListener.execute((Object)filename);
            }

            @Override
            public void modified(String filename) throws Exception {
                changeListener.execute((Object)filename);
            }

            @Override
            public void deleted(String filename) throws Exception {
                changeListener.execute((Object)filename);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelAll() {
        Set<WatcherThread> set = WATCHERS;
        synchronized (set) {
            for (WatcherThread watch : WATCHERS) {
                watch.cancel();
            }
            WATCHERS.clear();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Watch.cancelAll();
            }
        });
    }
}

