/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.goodies;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.goodies.BeansHandler;
import org.rapidoid.goodies.ClasspathHandler;
import org.rapidoid.goodies.ConfigHandler;
import org.rapidoid.goodies.EchoHandler;
import org.rapidoid.goodies.EntitiesHandler;
import org.rapidoid.goodies.GraphDataHandler;
import org.rapidoid.goodies.GraphsHandler;
import org.rapidoid.goodies.JMXGoodies;
import org.rapidoid.goodies.LoginHandler;
import org.rapidoid.goodies.LogoutHandler;
import org.rapidoid.goodies.ManageableDetailsPage;
import org.rapidoid.goodies.ManageablesOverviewPage;
import org.rapidoid.goodies.OverviewHandler;
import org.rapidoid.goodies.ProcessDetailsHandler;
import org.rapidoid.goodies.ProcessesHandler;
import org.rapidoid.goodies.RoutesHandler;
import org.rapidoid.goodies.StatusHandler;
import org.rapidoid.goodies.TerminateHandler;
import org.rapidoid.goodies.WelcomeHandler;
import org.rapidoid.goodies.X;
import org.rapidoid.goodies.discovery.DiscoveryIndexHandler;
import org.rapidoid.goodies.discovery.DiscoveryRegistrationHandler;
import org.rapidoid.goodies.discovery.DiscoveryState;
import org.rapidoid.gui.GUI;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.HttpVerb;
import org.rapidoid.http.ReqHandler;
import org.rapidoid.http.ReqRespHandler;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.insight.Metrics;
import org.rapidoid.jpa.JPA;
import org.rapidoid.lambda.FourParamLambda;
import org.rapidoid.setup.On;
import org.rapidoid.setup.Setup;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.util.MscOpts;

public class Goodies
extends RapidoidThing {
    public static final JMXGoodies JMX = new JMXGoodies();

    public static void bootstrap(Setup setup) {
        if (setup.isAdmin()) {
            Goodies.adminCenter(setup);
        } else if (setup.isApp()) {
            Goodies.bootstrapAppGoodies(setup);
        }
    }

    public static void bootstrapAppGoodies(Setup setup) {
        Msc.logSection((String)"Registering App services:");
        Goodies.auth(setup);
    }

    public static void adminCenter(Setup setup) {
        Msc.logSection((String)"Registering Admin Center:");
        Metrics.bootstrap();
        Goodies.overview(setup);
        Goodies.entities(setup);
        Goodies.application(setup);
        Goodies.lifecycle(setup);
        Goodies.processes(setup);
        Goodies.manageables(setup);
        Goodies.jmx(setup);
        Goodies.metrics(setup);
        Goodies.auth(setup);
        Goodies.status(setup);
    }

    public static void auth(Setup setup) {
        setup.post(Goodies.uri("login")).roles(new String[0]).json((ReqRespHandler)new LoginHandler());
        setup.get(Goodies.uri("logout")).roles(new String[]{"logged_in"}).json((ReqRespHandler)new LogoutHandler());
    }

    public static void ping(Setup setup) {
        setup.get(Goodies.uri("ping")).plain("OK");
    }

    public static void lifecycle(Setup setup) {
        setup.page(Goodies.uri("terminate")).mvc((Callable)new TerminateHandler());
    }

    public static void overview(Setup setup) {
        setup.page(Goodies.uri("")).mvc((Callable)new OverviewHandler());
    }

    public static void application(Setup setup) {
        setup.page(Goodies.uri("routes")).mvc((Callable)new RoutesHandler());
        setup.page(Goodies.uri("beans")).mvc((Callable)new BeansHandler());
        setup.page(Goodies.uri("config")).mvc((Callable)new ConfigHandler());
        setup.get(Goodies.uri("classpath")).mvc((Callable)new ClasspathHandler());
    }

    public static void metrics(Setup setup) {
        setup.page(Goodies.uri("metrics")).mvc((ReqRespHandler)new GraphsHandler());
        setup.get(Goodies.uri("graphs/{id:.*}")).json((FourParamLambda)new GraphDataHandler());
    }

    public static void processes(Setup setup) {
        setup.page(Goodies.uri("processes")).mvc((Callable)new ProcessesHandler());
        setup.page(Goodies.uri("processes/{id}")).mvc((ReqRespHandler)new ProcessDetailsHandler());
    }

    public static void manageables(Setup setup) {
        setup.page(Goodies.uri("manageables")).mvc((Callable)new ManageablesOverviewPage());
        setup.page(Goodies.uri("manageables/{type}/{id}")).mvc((ReqRespHandler)new ManageableDetailsPage());
    }

    public static void jmx(Setup setup) {
        setup.page(Goodies.uri("jmx/memory")).mvc((Callable)JMX.memory());
        setup.page(Goodies.uri("jmx/mempool")).mvc((Callable)JMX.memoryPool());
        setup.page(Goodies.uri("jmx/classes")).mvc((Callable)JMX.classes());
        setup.page(Goodies.uri("jmx/os")).mvc((Callable)JMX.os());
        setup.page(Goodies.uri("jmx/threads")).mvc((Callable)JMX.threads());
        setup.page(Goodies.uri("jmx/compilation")).mvc((Callable)JMX.compilation());
        setup.page(Goodies.uri("jmx/runtime")).mvc((Callable)JMX.runtime());
        setup.page(Goodies.uri("jmx/gc")).mvc((Callable)JMX.gc());
    }

    public static void entities(Setup setup) {
        setup.page(Goodies.uri("entities")).mvc((Callable)new EntitiesHandler());
        if (MscOpts.hasJPA()) {
            for (Class type : JPA.getEntityJavaTypes()) {
                String uri = GUI.typeUri((Class)type);
                String contextPath = (String)HttpUtils.zone((Customization)setup.custom(), (String)setup.zone()).entry("home").or((Object)Goodies.uri(""));
                X.scaffold(setup, Msc.uri((String[])new String[]{contextPath, uri}), type);
            }
        }
    }

    public static void oauth(Setup setup) {
        Class oauthClass = Cls.getClassIfExists((String)"org.rapidoid.oauth.OAuth");
        U.must((oauthClass != null ? 1 : 0) != 0, (String)"Cannot find the OAuth components, is module 'rapidoid-oauth' missing?");
        Method bootstrap = Cls.getMethod((Class)oauthClass, (String)"bootstrap", (Class[])new Class[]{Setup.class});
        Cls.invokeStatic((Method)bootstrap, (Object[])new Object[]{setup});
    }

    public static void welcome(Setup setup) {
        if (!setup.routes().hasRouteOrResource(HttpVerb.GET, "/")) {
            On.get((String)"/").view("_welcome").mvc((ReqRespHandler)new WelcomeHandler());
        }
    }

    public static void status(Setup setup) {
        setup.get(Goodies.uri("status")).json((Callable)new StatusHandler());
    }

    public static void discovery(Setup setup) {
        DiscoveryState state = new DiscoveryState();
        setup.post(Goodies.uri("discovery/{scope}/register")).json((ReqHandler)new DiscoveryRegistrationHandler(state));
        setup.get(Goodies.uri("discovery/{scope}")).json((ReqHandler)new DiscoveryIndexHandler(state));
    }

    public static void echo(Setup setup) {
        setup.get(Goodies.uri("echo")).json((ReqRespHandler)new EchoHandler());
    }

    static String uri(String path) {
        return Msc.specialUri((String[])new String[]{path});
    }
}

