/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.goodies;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.rapidoid.gui.GUI;
import org.rapidoid.html.Tag;
import org.rapidoid.html.tag.TableTag;
import org.rapidoid.html.tag.TdTag;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.HttpVerb;
import org.rapidoid.http.Route;
import org.rapidoid.http.RouteConfig;
import org.rapidoid.setup.Admin;
import org.rapidoid.setup.On;
import org.rapidoid.u.U;

public class RoutesHandler
extends GUI
implements Callable<Object> {
    @Override
    public Object call() throws Exception {
        List routes = U.list();
        Set appRoutes = On.setup().routes().allNonAdmin();
        Set adminRoutes = On.setup().routes().allAdmin();
        adminRoutes.addAll(Admin.setup().routes().allAdmin());
        routes.add(RoutesHandler.div((Object[])new Object[]{RoutesHandler.h3((Object[])new Object[]{"Application routes:"}), RoutesHandler.routesOf(appRoutes, true)}));
        routes.add(RoutesHandler.div((Object[])new Object[]{RoutesHandler.h3((Object[])new Object[]{"Admin routes:"}), RoutesHandler.routesOf(adminRoutes, true)}));
        return RoutesHandler.multi((Object[])new Object[]{routes});
    }

    public static TableTag routesOf(Set<Route> httpRoutes, boolean withHandler) {
        List routes = U.list(httpRoutes);
        RoutesHandler.sortRoutes(routes);
        List rows = U.list();
        rows.add(RoutesHandler.tr((Object[])new Object[]{RoutesHandler.th((Object[])new Object[]{"Verb"}), RoutesHandler.th((Object[])new Object[]{"Path"}), RoutesHandler.th((Object[])new Object[]{"Zone"}), RoutesHandler.th((Object[])new Object[]{"Content type"}), RoutesHandler.th((Object[])new Object[]{"MVC"}), RoutesHandler.th((Object[])new Object[]{"View name"}), RoutesHandler.th((Object[])new Object[]{"Roles"}), withHandler ? RoutesHandler.th((Object[])new Object[]{"Handler"}) : null}));
        while (!routes.isEmpty()) {
            Route route = (Route)U.first((List)routes);
            List verbs = U.list((Object[])new HttpVerb[]{route.verb()});
            Iterator it = routes.iterator();
            while (it.hasNext()) {
                Route other = (Route)it.next();
                if (route == other) {
                    it.remove();
                    continue;
                }
                if (!RoutesHandler.sameTarget(route, other)) continue;
                verbs.add(other.verb());
                it.remove();
            }
            rows.add(RoutesHandler.routeRow(route, verbs, withHandler));
        }
        return RoutesHandler.table_((Object[])new Object[]{rows});
    }

    private static boolean sameTarget(Route a, Route b) {
        return !a.verb().equals((Object)b.verb()) && a.path().equals(b.path()) && a.handler() == b.handler() && a.config().equals(b.config());
    }

    private static void sortRoutes(List<Route> routes) {
        Collections.sort(routes, new Comparator<Route>(){

            @Override
            public int compare(Route a, Route b) {
                int cmpByPath = a.path().compareTo(b.path());
                return cmpByPath != 0 ? cmpByPath : a.verb().compareTo((Enum)b.verb());
            }
        });
    }

    private static Tag routeRow(Route route, List<HttpVerb> verbs, boolean withHandler) {
        RouteConfig config = route.config();
        TdTag verb = RoutesHandler.td((Object[])new Object[0]);
        for (HttpVerb vrb : verbs) {
            verb = verb.append(new Object[]{RoutesHandler.verb((HttpVerb)vrb)});
        }
        TdTag path = RoutesHandler.td((Object[])new Object[]{route.path()});
        TdTag zone = RoutesHandler.td((Object[])new Object[]{config.zone()});
        TdTag roles = RoutesHandler.td((Object[])new Object[]{RoutesHandler.display((Object)(config.roles().isEmpty() ? "" : config.roles()))});
        TdTag hnd = RoutesHandler.td((Object[])new Object[]{route.handler()});
        TdTag ctype = RoutesHandler.td((Object[])new Object[]{config.contentType().info()});
        String viewName = config.mvc() ? RoutesHandler.viewName(route, config) : "";
        TdTag view = RoutesHandler.td((Object[])new Object[]{viewName});
        TdTag mvc = RoutesHandler.td((Object[])new Object[]{config.mvc() ? RoutesHandler.fa((String)"check") : ""});
        return RoutesHandler.tr((Object[])new Object[]{verb, path, zone, ctype, mvc, view, roles, withHandler ? hnd : null});
    }

    private static String viewName(Route route, RouteConfig config) {
        return config.view() != null ? config.view() : HttpUtils.resNameFromRoutePath((String)route.path());
    }
}

