/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.goodies;

import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.EntityType;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.English;
import org.rapidoid.commons.Str;
import org.rapidoid.datamodel.Range;
import org.rapidoid.gui.Btn;
import org.rapidoid.gui.GUI;
import org.rapidoid.gui.Grid;
import org.rapidoid.gui.Pager;
import org.rapidoid.gui.input.Form;
import org.rapidoid.http.Req;
import org.rapidoid.http.ReqRespHandler;
import org.rapidoid.http.Resp;
import org.rapidoid.jdbc.JDBC;
import org.rapidoid.jpa.JPA;
import org.rapidoid.setup.App;
import org.rapidoid.setup.On;
import org.rapidoid.setup.Setup;
import org.rapidoid.u.U;

public class X
extends RapidoidThing {
    private static final Object OK = U.map();

    public static ReqRespHandler sql(final String sql, final Object ... args) {
        return new ReqRespHandler(){

            public Object execute(Req req, Resp resp) throws Exception {
                return JDBC.query((String)sql, (Object[])args);
            }
        };
    }

    public static ReqRespHandler jpql(final String jpql, final Object ... args) {
        return new ReqRespHandler(){

            public Object execute(Req req, Resp resp) throws Exception {
                Map namedArgs = req != null ? req.data() : null;
                return JPA.jpql((String)jpql).bind(namedArgs).bind(args).all();
            }
        };
    }

    public static ReqRespHandler index(final Class<?> entityType) {
        return new ReqRespHandler(){

            public Object execute(Req req, Resp resp) throws Exception {
                return JPA.of((Class)entityType).all();
            }
        };
    }

    public static ReqRespHandler read(final Class<?> entityType) {
        return new ReqRespHandler(){

            public Object execute(Req req, Resp resp) throws Exception {
                Object id = Cls.convert((String)req.param("id"), (Class)X.idType(entityType));
                return JPA.get((Class)entityType, (Object)id);
            }
        };
    }

    public static ReqRespHandler insert(final Class<?> entityType) {
        return new ReqRespHandler(){

            public Object execute(Req req, Resp resp) throws Exception {
                return JPA.save((Object)req.data(entityType));
            }
        };
    }

    public static ReqRespHandler update(final Class<?> entityType) {
        return new ReqRespHandler(){

            public Object execute(Req req, Resp resp) throws Exception {
                Object id = Cls.convert((String)req.param("id"), (Class)X.idType(entityType));
                JPA.get((Class)entityType, (Object)id);
                JPA.merge((Object)req.data(entityType));
                return OK;
            }
        };
    }

    public static ReqRespHandler delete(final Class<?> entityType) {
        return new ReqRespHandler(){

            public Object execute(Req req, Resp resp) throws Exception {
                Object id = Cls.convert((String)req.param("id"), (Class)X.idType(entityType));
                JPA.delete((Class)entityType, (Object)id);
                return OK;
            }
        };
    }

    public static ReqRespHandler manage(final Class<?> entityType, final String baseUri) {
        return new ReqRespHandler(){

            public Object execute(Req req, Resp resp) throws Exception {
                if (resp.screen().title() == null) {
                    resp.screen().title("Manage " + English.plural((String)X.name(entityType)));
                }
                long count = JPA.count((Class)entityType);
                int pageSize = 10;
                int pages = (int)Math.ceil((double)count / (double)pageSize);
                int page = (Integer)U.or((Object)Cls.convert((String)((String)req.params().get("page")), Integer.class), (Object)1);
                Range range = Range.of((int)((page - 1) * pageSize), (int)pageSize);
                List records = JPA.of((Class)entityType).page((long)range.start(), (long)range.length());
                Grid grid = GUI.grid((Iterable)records);
                Btn add = GUI.btn((Object[])new Object[]{"Add " + X.name(entityType)}).primary().go(baseUri + "/add");
                Pager pager = GUI.pager((String)"page").min(1).max(pages).right(true);
                return GUI.multi((Object[])new Object[]{grid, GUI.div((Object[])new Object[]{pager, add})});
            }
        };
    }

    public static ReqRespHandler add(final Class<?> entityType, final String baseUri) {
        return new ReqRespHandler(){

            public Object execute(Req req, Resp resp) throws Exception {
                Object entity = Cls.newInstance((Class)entityType);
                if (resp.screen().title() == null) {
                    resp.screen().title("Add " + X.name(entityType));
                }
                Btn save = X.btnSave(entity).go(baseUri + "/manage");
                Btn cancel = GUI.btn((Object[])new Object[]{"Cancel"}).go(baseUri + "/manage");
                return GUI.create((Object)entity, (String[])new String[0]).buttons(new Btn[]{save, cancel});
            }
        };
    }

    public static ReqRespHandler view(final Class<?> entityType, final String baseUri) {
        final Class<?> idType = X.idType(entityType);
        return new ReqRespHandler(){

            public Object execute(Req req, Resp resp) throws Exception {
                final Object id = Cls.convert((String)req.param("id"), (Class)idType);
                Object entity = JPA.getIfExists((Class)entityType, (Object)id);
                if (entity == null) {
                    return null;
                }
                JPA.detach((Object)entity);
                String name = X.name(entityType);
                if (resp.screen().title() == null) {
                    resp.screen().title(name + " Details");
                }
                Btn edit = GUI.btn((Object[])new Object[]{"Edit"}).go(X.uri(baseUri, entity) + "/edit");
                Btn all = GUI.btn((Object[])new Object[]{"View all"}).go(baseUri + "/manage");
                Btn del = X.btnDelete().go(baseUri + "/manage").onClick(new Runnable(){

                    @Override
                    public void run() {
                        JPA.delete((Class)entityType, (Object)id);
                    }
                }).confirm("Do you really want to delete the " + name + "?");
                Form form = (Form)GUI.show((Object)entity, (String[])new String[0]).buttons(new Btn[]{edit, all, del}).visible(!del.clicked());
                String msg = del.clicked() ? GUI.div((Object[])new Object[]{"The data was deleted."}) : "";
                return GUI.multi((Object[])new Object[]{form, msg});
            }
        };
    }

    public static ReqRespHandler edit(final Class<?> entityType, final String baseUri) {
        return new ReqRespHandler(){

            public Object execute(Req req, Resp resp) throws Exception {
                Object id = Cls.convert((String)req.param("id"), (Class)X.idType(entityType));
                Object entity = JPA.getIfExists((Class)entityType, (Object)id);
                if (entity == null) {
                    return null;
                }
                JPA.detach((Object)entity);
                if (resp.screen().title() == null) {
                    resp.screen().title("Edit " + X.name(entityType));
                }
                Btn save = X.btnSave(entity).go(baseUri + "/manage");
                Btn cancel = GUI.btn((Object[])new Object[]{"Cancel"}).go(X.uri(baseUri, entity) + "/view");
                return GUI.edit((Object)entity, (String[])new String[0]).buttons(new Btn[]{save, cancel});
            }
        };
    }

    public static Btn btnSave(final Object entity) {
        return GUI.btn((Object[])new Object[]{"Save"}).primary().onSuccess(new Runnable(){

            @Override
            public void run() {
                JPA.save((Object)entity);
            }
        });
    }

    public static Btn btnDelete() {
        return GUI.btn((Object[])new Object[]{"Delete"}).danger().confirm("Do you really want to delete the data?");
    }

    private static String name(Class<?> entityType) {
        return entityType.getSimpleName();
    }

    private static Class<?> idType(Class<?> entityType) {
        for (EntityType t : JPA.getEntityTypes()) {
            if (!t.getJavaType().equals(entityType)) continue;
            return t.getIdType() != null ? t.getIdType().getJavaType() : null;
        }
        return null;
    }

    public static String uri(String baseUri, Object entity) {
        return GUI.uriFor((String)baseUri, (Object)entity);
    }

    public static void scaffold(String uri, Class<?> entityType) {
        X.scaffold(On.setup(), uri, entityType);
    }

    public static void scaffold(Setup setup, String uri, Class<?> entityType) {
        JPA.bootstrap((String[])App.path(), (Class[])new Class[]{entityType});
        X.scaffoldEntity(setup, uri, entityType);
    }

    public static void scaffold(Class<?> ... entityTypes) {
        X.scaffold(On.setup(), entityTypes);
    }

    public static void scaffold(Setup setup, Class<?> ... entityTypes) {
        JPA.bootstrap((String[])App.path(), (Class[])entityTypes);
        for (Class<?> entityType : entityTypes) {
            X.scaffoldEntity(setup, GUI.typeUri(entityType), entityType);
        }
    }

    private static void scaffoldEntity(Setup setup, String baseUri, Class<?> entityType) {
        if (baseUri.length() > 1) {
            baseUri = Str.trimr((String)baseUri, (String)"/");
        }
        setup.get(baseUri).json(X.index(entityType));
        setup.get(baseUri + "/{id}").json(X.read(entityType));
        setup.post(baseUri).transaction().json(X.insert(entityType));
        setup.put(baseUri + "/{id}").transaction().json(X.update(entityType));
        setup.delete(baseUri + "/{id}").transaction().json(X.delete(entityType));
        setup.page(baseUri + "/manage").mvc(X.manage(entityType, baseUri));
        setup.page(baseUri + "/add").transaction().mvc(X.add(entityType, baseUri));
        setup.page(baseUri + "/{id}/view").transaction().mvc(X.view(entityType, baseUri));
        setup.page(baseUri + "/{id}/edit").transaction().mvc(X.edit(entityType, baseUri));
    }
}

