/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.web.handler;

import java.util.Map;
import java.util.regex.Pattern;
import org.rapidoid.commons.Err;
import org.rapidoid.datamodel.Results;
import org.rapidoid.gui.GUI;
import org.rapidoid.gui.Grid;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.render.Render;
import org.rapidoid.u.U;
import org.rapidoid.web.config.bean.PageConfig;
import org.rapidoid.web.config.bean.PageGuiConfig;
import org.rapidoid.web.handler.GenericHandler;

public class PageHandler
extends GenericHandler {
    private final PageConfig page;

    public PageHandler(PageConfig page) {
        this.page = page;
    }

    public Object execute(Req req, Resp resp) {
        if (U.notEmpty((String)this.page.sql)) {
            return this.guiOf(this.page, this.sqlItems(this.page.sql));
        }
        if (U.notEmpty(this.page.gui)) {
            return this.guiModel(this.page.gui);
        }
        return GUI.N_A;
    }

    private Object guiModel(Map<String, PageGuiConfig> gui) {
        Map model = U.map();
        for (Map.Entry<String, PageGuiConfig> e : gui.entrySet()) {
            model.put(e.getKey(), this.gui(e.getValue()));
        }
        return model;
    }

    private Object gui(PageGuiConfig gui) {
        Grid item;
        switch (gui.type) {
            case grid: {
                item = this.grid(gui, this.sqlItems(gui.sql));
                break;
            }
            default: {
                throw Err.notReady();
            }
        }
        if (U.notEmpty((String)gui.caption)) {
            item = GUI.multi((Object[])new Object[]{GUI.titleBox((Object[])new Object[]{gui.caption}), item});
        }
        if (U.notEmpty((String)gui.header) || U.notEmpty((String)gui.footer)) {
            item = GUI.panel((Object[])new Object[]{item}).header((Object)gui.header).footer((Object)gui.footer);
        }
        return item;
    }

    private Object guiOf(PageConfig gui, Results items) {
        if (gui.single) {
            Object item = U.single((Iterable)items.all());
            return GUI.details((Object)item);
        }
        return this.grid(new PageGuiConfig(), items);
    }

    public Grid grid(final PageGuiConfig gui, Results items) {
        String pageSize;
        String highlight;
        Req req = this.req();
        Grid grid = GUI.grid((Iterable)items.all());
        String q = req.param("find", null);
        if (q != null) {
            grid.highlightRegex(Pattern.quote(q));
        }
        if ((highlight = req.param("$highlight", null)) != null) {
            grid.highlightRegex(Pattern.quote(highlight));
        }
        if ((pageSize = req.param("$pageSize", null)) != null) {
            grid.pageSize(U.num((String)pageSize));
        }
        if (U.notEmpty((String)gui.uri)) {
            grid.toUri((Mapper)new Mapper<Object, String>(){

                public String map(Object item) throws Exception {
                    return Render.template((String)gui.uri).model(item);
                }
            });
        }
        return grid;
    }
}

