/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.wire;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rapidoid.annotation.Autocreate;
import org.rapidoid.annotation.Init;
import org.rapidoid.annotation.Inject;
import org.rapidoid.annotation.Local;
import org.rapidoid.annotation.Session;
import org.rapidoid.aop.AOP;
import org.rapidoid.beany.Beany;
import org.rapidoid.cls.Cls;
import org.rapidoid.config.Conf;
import org.rapidoid.lambda.F3;
import org.rapidoid.lambda.Lambdas;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.log.Log;
import org.rapidoid.log.LogLevel;
import org.rapidoid.util.Builder;
import org.rapidoid.util.Proxies;
import org.rapidoid.util.U;
import org.rapidoid.util.UTILS;

public class Wire {
    private static final Map<Class<?>, Object> SINGLETONS = U.map();
    private static final Set<Class<?>> MANAGED_CLASSES = U.set((Object[])new Class[0]);
    private static final Set<Object> MANAGED_INSTANCES = U.set((Object[])new Object[0]);
    private static final Map<Object, Object> IOC_INSTANCES = U.map();
    private static final Map<Class<?>, List<Field>> INJECTABLE_FIELDS = UTILS.autoExpandingMap((Mapper)new Mapper<Class<?>, List<Field>>(){

        public List<Field> map(Class<?> clazz) throws Exception {
            List fields = Cls.getFieldsAnnotated(clazz, Inject.class);
            Log.debug((String)"Retrieved @Inject fields", (String)"class", clazz, (String)"fields", (Object)fields);
            return fields;
        }
    });
    private static final Map<Class<?>, List<Field>> SESSION_FIELDS = UTILS.autoExpandingMap((Mapper)new Mapper<Class<?>, List<Field>>(){

        public List<Field> map(Class<?> clazz) throws Exception {
            List fields = Cls.getFieldsAnnotated(clazz, Session.class);
            Log.debug((String)"Retrieved @Session fields", (String)"class", clazz, (String)"fields", (Object)fields);
            return fields;
        }
    });
    private static final Map<Class<?>, List<Field>> LOCAL_FIELDS = UTILS.autoExpandingMap((Mapper)new Mapper<Class<?>, List<Field>>(){

        public List<Field> map(Class<?> clazz) throws Exception {
            List fields = Cls.getFieldsAnnotated(clazz, Local.class);
            Log.debug((String)"Retrieved @Local fields", (String)"class", clazz, (String)"fields", (Object)fields);
            return fields;
        }
    });
    private static final Map<Class<?>, Set<Object>> INJECTION_PROVIDERS = U.map();
    private static final Map<Class<?>, List<F3<Object, Object, Method, Object[]>>> INTERCEPTORS = U.map();

    public static synchronized void reset() {
        Log.info((String)"Reseting IoC state");
        Log.setLogLevel((LogLevel)Log.INFO);
        Conf.args((String[])new String[0]);
        Beany.reset();
        SINGLETONS.clear();
        MANAGED_CLASSES.clear();
        MANAGED_INSTANCES.clear();
        IOC_INSTANCES.clear();
        INJECTABLE_FIELDS.clear();
        SESSION_FIELDS.clear();
        LOCAL_FIELDS.clear();
        INJECTION_PROVIDERS.clear();
        INTERCEPTORS.clear();
    }

    public static <K, V> Map<K, V> autoExpandingInjectingMap(final Class<V> clazz) {
        return UTILS.autoExpandingMap((Mapper)new Mapper<K, V>(){

            public V map(K src) throws Exception {
                return Wire.inject(Cls.newInstance((Class)clazz));
            }
        });
    }

    public static synchronized void manage(Object ... classesOrInstances) {
        ArrayList autocreate = new ArrayList();
        for (Object classOrInstance : classesOrInstances) {
            boolean isClass = Wire.isClass(classOrInstance);
            Class<?> clazz = isClass ? (Class<?>)classOrInstance : classOrInstance.getClass();
            for (Class interfacee : Cls.getImplementedInterfaces(clazz)) {
                Wire.addInjectionProvider(interfacee, classOrInstance);
            }
            if (isClass) {
                Log.debug((String)"configuring managed class", (String)"class", (Object)classOrInstance);
                MANAGED_CLASSES.add(clazz);
                if (clazz.isInterface() || clazz.isEnum() || clazz.isAnnotation() || clazz.getAnnotation(Autocreate.class) == null) continue;
                autocreate.add(clazz);
                continue;
            }
            Log.debug((String)"configuring managed instance", (String)"instance", (Object)classOrInstance);
            Wire.addInjectionProvider(clazz, classOrInstance);
            MANAGED_INSTANCES.add(classOrInstance);
        }
        for (Class clazz : autocreate) {
            Wire.singleton(clazz);
        }
    }

    private static void addInjectionProvider(Class<?> type, Object provider) {
        Set providers = INJECTION_PROVIDERS.get(type);
        if (providers == null) {
            providers = U.set((Object[])new Object[0]);
            INJECTION_PROVIDERS.put(type, providers);
        }
        providers.add((Object)provider);
    }

    public static synchronized <T> T singleton(Class<T> type) {
        Log.debug((String)"Inject", (String)"type", type);
        return Wire.provideIoCInstanceOf(null, type, null, null, false);
    }

    public static synchronized <T> T autowire(T target) {
        Log.debug((String)"Autowire", (String)"target", target);
        Wire.autowire(target, null, null, null);
        return target;
    }

    public static synchronized <T> T autowire(T target, Mapper<String, Object> session, Mapper<String, Object> bindings) {
        Log.debug((String)"Autowire", (String)"target", target);
        Wire.autowire(target, null, session, bindings);
        return target;
    }

    public static synchronized <T> T inject(T target) {
        Log.debug((String)"Inject", (String)"target", target);
        return Wire.ioc(target, null);
    }

    public static synchronized <T> T inject(T target, Map<String, Object> properties) {
        Log.debug((String)"Inject", (String)"target", target, (String)"properties", properties);
        return Wire.ioc(target, properties);
    }

    private static <T> T provideSessionValue(Object target, Class<T> type, String name, Mapper<String, Object> session) {
        U.notNull(session, (String)"session", (Object[])new Object[0]);
        Object value = Lambdas.eval(session, (Object)name);
        return (T)(value != null ? Cls.convert((Object)value, type) : null);
    }

    private static <T> T provideBindValue(Object target, Class<T> type, String name, Mapper<String, Object> bindings) {
        U.notNull(bindings, (String)"bindings", (Object[])new Object[0]);
        Object value = Lambdas.eval(bindings, (Object)name);
        return (T)(value != null ? Cls.convert((Object)value, type) : null);
    }

    private static <T> T provideIoCInstanceOf(Object target, Class<T> type, String name, Map<String, Object> properties, boolean optional) {
        T instance = null;
        if (name != null) {
            instance = Wire.provideInstanceByName(target, type, name, properties);
        }
        if (instance == null) {
            instance = Wire.provideIoCInstanceByType(type, properties);
        }
        if (instance == null && Wire.canInjectNew(type)) {
            instance = Wire.provideNewIoCInstanceOf(type, properties);
        }
        if (!optional && instance == null) {
            if (name != null) {
                throw U.rte((String)"Didn't find a value for type '%s' and name '%s'!", (Object[])new Object[]{type, name});
            }
            throw U.rte((String)"Didn't find a value for type '%s'!", (Object[])new Object[]{type});
        }
        return instance != null ? Wire.ioc(instance, properties) : null;
    }

    private static boolean canInjectNew(Class<?> type) {
        return !type.isAnnotation() && !type.isEnum() && !type.isInterface() && !type.isPrimitive() && !type.equals(String.class) && !type.equals(Object.class) && !type.equals(Boolean.class) && !Number.class.isAssignableFrom(type);
    }

    private static <T> T provideNewIoCInstanceOf(Class<T> type, Map<String, Object> properties) {
        if (!(type.isInterface() || type.isEnum() || type.isAnnotation())) {
            Object instance = SINGLETONS.get(type);
            if (instance == null) {
                instance = Wire.ioc(Cls.newInstance(type, properties), properties);
            }
            return (T)instance;
        }
        return null;
    }

    private static <T> T provideIoCInstanceByType(Class<T> type, Map<String, Object> properties) {
        Set<Object> providers = INJECTION_PROVIDERS.get(type);
        if (providers != null && !providers.isEmpty()) {
            Object provider = null;
            for (Object pr : providers) {
                if (provider == null) {
                    provider = pr;
                    continue;
                }
                if (Wire.isClass(provider) && !Wire.isClass(pr)) {
                    provider = pr;
                    continue;
                }
                if (!Wire.isClass(provider) && Wire.isClass(pr)) continue;
                throw U.rte((String)"Found more than 1 injection candidates for type '%s': %s", (Object[])new Object[]{type, providers});
            }
            if (provider != null) {
                return Wire.provideFrom(provider, properties);
            }
        }
        return null;
    }

    private static <T> T provideFrom(Object classOrInstance, Map<String, Object> properties) {
        Object instance = Wire.isClass(classOrInstance) ? Wire.provideNewIoCInstanceOf((Class)classOrInstance, properties) : classOrInstance;
        return (T)instance;
    }

    private static boolean isClass(Object obj) {
        return obj instanceof Class;
    }

    private static <T> T provideInstanceByName(Object target, Class<T> type, String name, Map<String, Object> properties) {
        T instance = Wire.getInjectableByName(type, name, properties, false);
        if (target != null) {
            instance = Wire.getInjectableByName(type, target.getClass().getSimpleName() + "." + name, properties, true);
        }
        if (instance == null) {
            instance = Wire.getInjectableByName(type, name, properties, true);
        }
        return instance;
    }

    private static <T> T getInjectableByName(Class<T> type, String name, Map<String, Object> properties, boolean useConfig) {
        Object instance;
        Object object = instance = properties != null ? properties.get(name) : null;
        if (instance == null && useConfig) {
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                instance = Conf.is((String)name);
            } else {
                String opt = Conf.option((String)name, (String)null);
                if (opt != null) {
                    instance = Cls.convert((String)opt, type);
                }
            }
        }
        return (T)instance;
    }

    private static void autowire(Object target, Map<String, Object> properties, Mapper<String, Object> session, Mapper<String, Object> locals) {
        Log.debug((String)"Autowiring", (String)"target", (Object)target, (String)"session", session, (String)"bindings", locals);
        for (Field field : INJECTABLE_FIELDS.get(target.getClass())) {
            boolean optional = Wire.isInjectOptional(field);
            Object value = Wire.provideIoCInstanceOf(target, field.getType(), field.getName(), properties, optional);
            Log.debug((String)"Injecting field value", (String)"target", (Object)target, (String)"field", (Object)field.getName(), (String)"value", value);
            if (optional && value == null) continue;
            Cls.setFieldValue((Object)target, (String)field.getName(), value);
        }
        for (Field field : SESSION_FIELDS.get(target.getClass())) {
            Object value = Wire.provideSessionValue(target, field.getType(), field.getName(), session);
            if (value == null) continue;
            Log.debug((String)"Injecting session field value", (String)"target", (Object)target, (String)"field", (Object)field.getName(), (String)"value", value);
            Cls.setFieldValue((Object)target, (String)field.getName(), value);
        }
        for (Field field : LOCAL_FIELDS.get(target.getClass())) {
            Object value = Wire.provideBindValue(target, field.getType(), field.getName(), locals);
            if (value == null) continue;
            Log.debug((String)"Injecting bind field value", (String)"target", (Object)target, (String)"field", (Object)field.getName(), (String)"value", value);
            Cls.setFieldValue((Object)target, (String)field.getName(), value);
        }
    }

    private static boolean isInjectOptional(Field field) {
        Inject inject = field.getAnnotation(Inject.class);
        return inject != null && inject.optional();
    }

    private static <T> void invokePostConstruct(T target) {
        List methods = Cls.getMethodsAnnotated(target.getClass(), Init.class);
        for (Method method : methods) {
            AOP.invoke(null, (Method)method, target, (Object[])new Object[0]);
        }
    }

    private static <T> T ioc(T target, Map<String, Object> properties) {
        if (!Wire.isIocProcessed(target)) {
            IOC_INSTANCES.put(target, null);
            Wire.manage(target);
            Wire.autowire(target, properties, null, null);
            Wire.invokePostConstruct(target);
            T proxy = Wire.proxyWrap(target);
            IOC_INSTANCES.put(target, proxy);
            Wire.manage(proxy);
            target = proxy;
        }
        return target;
    }

    private static boolean isIocProcessed(Object target) {
        for (Map.Entry<Object, Object> e : IOC_INSTANCES.entrySet()) {
            if (e.getKey() != target && e.getValue() != target) continue;
            return true;
        }
        return false;
    }

    private static <T> T proxyWrap(T instance) {
        Set done = U.set((Object[])new F3[0]);
        for (Class interf : Cls.getImplementedInterfaces(instance.getClass())) {
            List<F3<Object, Object, Method, Object[]>> interceptors = INTERCEPTORS.get(interf);
            if (interceptors == null) continue;
            for (final F3<Object, Object, Method, Object[]> interceptor : interceptors) {
                if (interceptor == null || done.contains(interceptor)) continue;
                Log.debug((String)"Creating proxy", (String)"target", instance, (String)"interface", (Object)interf, (String)"interceptor", interceptor);
                final T target = instance;
                InvocationHandler handler = new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        return interceptor.execute(target, (Object)method, (Object)args);
                    }
                };
                instance = Proxies.implement(instance, (InvocationHandler)handler, (Class[])new Class[]{interf});
                done.add(interceptor);
            }
        }
        return instance;
    }

    public static <T, B extends Builder<T>> B builder(Class<B> builderClass, Class<T> builtClass, final Class<? extends T> implClass) {
        final Map properties = U.map();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().equals(Builder.class)) {
                    return Wire.inject(Cls.newInstance((Class)implClass, (Map)properties), properties);
                }
                U.must((args.length == 1 ? 1 : 0) != 0, (String)"expected 1 argument!");
                properties.put(method.getName(), args[0]);
                return proxy;
            }
        };
        Builder builder = (Builder)Proxies.implement((InvocationHandler)handler, (Class[])new Class[]{builderClass});
        return (B)builder;
    }

    public static synchronized List<Field> getSessionFields(Object target) {
        return SESSION_FIELDS.get(target.getClass());
    }

    public static synchronized List<Field> getLocalFields(Object target) {
        return LOCAL_FIELDS.get(target.getClass());
    }
}

