/*
 * Decompiled with CFR 0.152.
 */
package junit.org.rapidpm.lang.cache.generic;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import junit.org.rapidpm.lang.cache.generic.book.Book;
import org.rapidpm.lang.cache.generic.Cache;
import org.rapidpm.lang.cache.generic.CacheFinder;
import org.rapidpm.lang.cache.generic.GenericCacheThreadsave;

public class GenericCacheTest
extends TestCase {
    private List<Book> bookList;
    private Cache<Book> bookCache = new GenericCacheThreadsave(Book.class);

    protected void setUp() throws Exception {
        this.bookList = this.createBookList();
        this.bookCache.fillCache(this.bookList);
    }

    public void testFillCache() {
        GenericCacheTest.assertEquals((int)10, (int)this.bookCache.getAllFromCache().size());
    }

    public void testGetBook4KeyWords() {
        ArrayList<String> keyWordList = new ArrayList<String>();
        keyWordList.add("q");
        keyWordList.add("g");
        CacheFinder keyWordFinder = this.bookCache.createCacheFinder("keyWords");
        Collection books4KeyWords = keyWordFinder.findForKeys(keyWordList);
        GenericCacheTest.assertTrue((boolean)books4KeyWords.contains(this.bookList.get(2)));
        GenericCacheTest.assertTrue((boolean)books4KeyWords.contains(this.bookList.get(3)));
        GenericCacheTest.assertTrue((boolean)books4KeyWords.contains(this.bookList.get(7)));
        GenericCacheTest.assertTrue((boolean)books4KeyWords.contains(this.bookList.get(8)));
        GenericCacheTest.assertTrue((boolean)books4KeyWords.contains(this.bookList.get(9)));
        GenericCacheTest.assertEquals((int)5, (int)books4KeyWords.size());
    }

    public void testGetBook4Month() {
        CacheFinder monthFinder = this.bookCache.createCacheFinder("month");
        Collection books4Month = monthFinder.findForKey((Object)"200503");
        GenericCacheTest.assertTrue((boolean)books4Month.contains(this.bookList.get(8)));
        GenericCacheTest.assertTrue((boolean)books4Month.contains(this.bookList.get(9)));
        GenericCacheTest.assertEquals((int)2, (int)books4Month.size());
    }

    public void testGetBook4Cw() {
        CacheFinder cwFinder = this.bookCache.createCacheFinder("cw");
        Collection books4Month = cwFinder.findForKey((Object)"2005KW5");
        GenericCacheTest.assertTrue((boolean)books4Month.contains(this.bookList.get(4)));
        GenericCacheTest.assertEquals((int)1, (int)books4Month.size());
    }

    public void testGetBook4Date() {
        CacheFinder dateFinder = this.bookCache.createCacheFinder("date");
        Collection books4Date = dateFinder.findForKey((Object)"20050215");
        GenericCacheTest.assertTrue((boolean)books4Date.contains(this.bookList.get(6)));
        GenericCacheTest.assertEquals((int)1, (int)books4Date.size());
    }

    public void testRemoveFromCache() throws IllegalAccessException, InvocationTargetException {
        ArrayList<Book> bookListClone = new ArrayList<Book>();
        bookListClone.addAll(this.bookList);
        ArrayList<String> keyWordList = new ArrayList<String>();
        keyWordList.add("q");
        keyWordList.add("g");
        CacheFinder keyWordFinder = this.bookCache.createCacheFinder("keyWords");
        Collection books4KeyWords = keyWordFinder.findForKeys(keyWordList);
        this.bookCache.removeFromCache(books4KeyWords);
        Collection allBooks = this.bookCache.getAllFromCache();
        GenericCacheTest.assertEquals((int)5, (int)allBooks.size());
        books4KeyWords = keyWordFinder.findForKeys(keyWordList);
        GenericCacheTest.assertEquals((int)0, (int)books4KeyWords.size());
        GenericCacheTest.assertTrue((boolean)allBooks.contains(bookListClone.get(0)));
        GenericCacheTest.assertTrue((boolean)allBooks.contains(bookListClone.get(1)));
        GenericCacheTest.assertTrue((boolean)allBooks.contains(bookListClone.get(4)));
        GenericCacheTest.assertTrue((boolean)allBooks.contains(bookListClone.get(5)));
        GenericCacheTest.assertTrue((boolean)allBooks.contains(bookListClone.get(6)));
    }

    private List<Book> createBookList() {
        ArrayList<Book> bookList = new ArrayList<Book>();
        Book book = new Book("a", "a", "a", "2005KW1", "20050101", "200501", this.createKeyWordList("a", "b", "c"));
        bookList.add(book);
        book = new Book("b", "b", "b", "2005KW1", "20050106", "200501", this.createKeyWordList("c", "d", "e"));
        bookList.add(book);
        book = new Book("c", "c", "c", "2005KW3", "20050115", "200501", this.createKeyWordList("e", "f", "g"));
        bookList.add(book);
        book = new Book("d", "d", "d", "2005KW4", "20050122", "200501", this.createKeyWordList("g", "h", "i"));
        bookList.add(book);
        book = new Book("e", "e", "e", "2005KW5", "20050201", "200502", this.createKeyWordList("i", "j", "k"));
        bookList.add(book);
        book = new Book("f", "f", "f", "2005KW6", "20050208", "200502", this.createKeyWordList("k", "l", "m"));
        bookList.add(book);
        book = new Book("g", "g", "g", "2005KW7", "20050215", "200502", this.createKeyWordList("m", "n", "o"));
        bookList.add(book);
        book = new Book("h", "h", "h", "2005KW8", "20050222", "200502", this.createKeyWordList("o", "p", "q"));
        bookList.add(book);
        book = new Book("i", "i", "i", "2005KW9", "20050301", "200503", this.createKeyWordList("q", "r", "s"));
        bookList.add(book);
        book = new Book("k", "k", "k", "2005KW10", "20050308", "200503", this.createKeyWordList("q", "r", "s"));
        bookList.add(book);
        return bookList;
    }

    private List<String> createKeyWordList(String s, String s1, String s2) {
        ArrayList<String> keyWordList = new ArrayList<String>();
        keyWordList.add(s);
        keyWordList.add(s1);
        keyWordList.add(s2);
        return keyWordList;
    }
}

