/*
 * Decompiled with CFR 0.152.
 */
package junit.org.rapidpm.lang.cache.generic.book;

import java.util.List;
import java.util.Objects;
import org.rapidpm.lang.cache.generic.Cacheable;

@Cacheable(primaryKeyAttributeName="isbn")
public class Book {
    private final String title;
    private final String author;
    private final String isbn;
    private final String cw;
    private final String date;
    private final String month;
    private final List<String> keyWords;

    public Book(String title, String author, String isbn, String cw, String date, String month, List<String> keyWords) {
        this.title = title;
        this.author = author;
        this.isbn = isbn;
        this.cw = cw;
        this.date = date;
        this.month = month;
        this.keyWords = keyWords;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getIsbn() {
        return this.isbn;
    }

    public String getMonth() {
        return this.month;
    }

    public String getCw() {
        return this.cw;
    }

    public String getDate() {
        return this.date;
    }

    public List<String> getKeyWords() {
        return this.keyWords;
    }

    public String toString() {
        return "book{title='" + this.title + '\'' + ", author='" + this.author + '\'' + ", isbn='" + this.isbn + '\'' + ", month='" + this.month + '\'' + ", cw='" + this.cw + '\'' + ", date='" + this.date + '\'' + ", keyWords=" + this.keyWords + '}';
    }

    public int hashCode() {
        return Objects.hash(this.isbn);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Book other = (Book)obj;
        return Objects.equals(this.isbn, other.isbn);
    }
}

