/*
 * Decompiled with CFR 0.152.
 */
package junit.org.rapidpm.lang.cache.generic.book;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import junit.org.rapidpm.lang.cache.generic.book.Book;
import org.rapidpm.lang.cache.generic.Cache;
import org.rapidpm.lang.cache.generic.CacheFinder;
import org.rapidpm.lang.cache.generic.GenericCacheThreadsave;

public class BookCacheWrapper {
    private final Cache<Book> bookCache = new GenericCacheThreadsave(Book.class, true);
    private final CacheFinder<Book, String> monthFinder = this.bookCache.createCacheFinder("month");
    private final CacheFinder<Book, String> cwFinder = this.bookCache.createCacheFinder("cw");
    private final CacheFinder<Book, String> dateFinder = this.bookCache.createCacheFinder("date");
    private final CacheFinder<Book, String> keyWordFinder = this.bookCache.createCacheFinder("keyWords");

    public void put2Cache(List<Book> bookList) throws IllegalAccessException, InvocationTargetException {
        for (Book book : bookList) {
            this.put2Cache(book);
        }
    }

    public void put2Cache(Book book) throws IllegalAccessException, InvocationTargetException {
        this.bookCache.fillCache((Object)book);
    }

    public Collection<Book> getBooks4Month(String month) {
        return this.monthFinder.findForKey((Object)month);
    }

    public Collection<Book> getBooks4Cw(String cw) {
        return this.cwFinder.findForKey((Object)cw);
    }

    public Collection<Book> getBooks4Date(String date) {
        return this.dateFinder.findForKey((Object)date);
    }

    public Collection<Book> getBooks4KeyWords(Collection<String> keyWords) {
        return this.keyWordFinder.findForKeys(keyWords);
    }

    public void removeBook(Book book) throws IllegalAccessException, InvocationTargetException {
        this.bookCache.removeFromCache((Object)book);
    }

    public void removeBook(Collection<Book> books) throws IllegalAccessException, InvocationTargetException {
        this.bookCache.removeFromCache(books);
    }

    public Collection<Book> getAllBooks() {
        return this.bookCache.getAllFromCache();
    }
}

