/*
 * Decompiled with CFR 0.152.
 */
package junit.org.rapidpm.lang.cache.generic.person;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import junit.org.rapidpm.lang.cache.generic.person.Person;
import org.rapidpm.lang.cache.generic.Cache;
import org.rapidpm.lang.cache.generic.CacheFinder;
import org.rapidpm.lang.cache.generic.GenericCacheThreadsave;

public class PersonCacheWrapper {
    private final Cache<Person> personCache = new GenericCacheThreadsave(Person.class, true);
    private final CacheFinder<Person, String> firstNameFinder = this.personCache.createCacheFinder("firstName");
    private final CacheFinder<Person, String> lastNameFinder = this.personCache.createCacheFinder("lastName");
    private final CacheFinder<Person, Date> birthFinder = this.personCache.createCacheFinder("birth");
    private final CacheFinder<Person, Integer> employeeNoFinder = this.personCache.createCacheFinder("employeeNo");

    public void put2Cache(List<Person> personList) throws IllegalAccessException, InvocationTargetException {
        for (Person person : personList) {
            this.put2Cache(person);
        }
    }

    public void put2Cache(Person person) throws IllegalAccessException, InvocationTargetException {
        this.personCache.fillCache((Object)person);
    }

    public Collection<Person> getPersons4FirstName(String name) {
        return this.firstNameFinder.findForKey((Object)name);
    }

    public Collection<Person> getPersons4LastName(String name) {
        return this.lastNameFinder.findForKey((Object)name);
    }

    public Collection<Person> getPersons4Birth(Date birth) {
        return this.birthFinder.findForKey((Object)birth);
    }

    public Collection<Person> getPersons4EmployeeNo(int employeeNo) {
        return this.employeeNoFinder.findForKey((Object)employeeNo);
    }

    public void removePerson(Person person) throws IllegalAccessException, InvocationTargetException {
        this.personCache.removeFromCache((Object)person);
    }

    public void removePerson(Collection<Person> persons) throws IllegalAccessException, InvocationTargetException {
        this.personCache.removeFromCache(persons);
    }

    public Collection<Person> getAllPersons() {
        return this.personCache.getAllFromCache();
    }
}

