/*
 * Decompiled with CFR 0.152.
 */
package junit.org.rapidpm.lang.cache.generic.person;

import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import junit.org.rapidpm.lang.cache.generic.person.Person;
import junit.org.rapidpm.lang.cache.generic.person.PersonCacheWrapper;

public class PersonCacheWrapperThreadTest
extends TestCase {
    private List<Person> persons;
    private PersonCacheWrapper personCache = new PersonCacheWrapper();
    private static final int READING_THREAD_COUNT = 40;
    private static final int WRITING_THREAD_COUNT = 5;
    private static final int LOOPS = 1000;
    private static final int OUTPUT = 1;
    private static final int READ_DELAY = 32;
    private static final int WRITE_DELAY = 1;
    boolean writersFinished = false;
    boolean readersFinished = true;

    protected void setUp() throws Exception {
        this.persons = PersonCacheWrapperThreadTest.createPersonList();
        this.personCache.put2Cache(this.persons);
    }

    public void testFillCache() {
        PersonCacheWrapperThreadTest.assertEquals((int)3, (int)this.personCache.getAllPersons().size());
    }

    public void testGetAndPutWithThreads() {
        int i;
        for (i = 0; i < 5; ++i) {
            new Thread("write-thread " + i){

                @Override
                public void run() {
                    for (int loop = 0; loop < 1000; ++loop) {
                        try {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
                            Person person = new Person("1name" + loop, "2name" + loop, dateFormat.parse("04.04.1974"), loop);
                            PersonCacheWrapperThreadTest.this.personCache.put2Cache(person);
                            System.out.println(this.getName() + " : " + person);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            1.sleep(1L);
                            continue;
                        }
                        catch (Exception e) {
                            System.out.println("abort " + this.getName());
                        }
                    }
                    if (this.getName().equals("write-thread 4")) {
                        PersonCacheWrapperThreadTest.this.writersFinished = true;
                    }
                }
            }.start();
        }
        for (i = 0; i < 40; ++i) {
            new Thread("read-thread " + i){

                @Override
                public void run() {
                    for (int loop = 0; loop < 1000; ++loop) {
                        Collection<Person> foundPersons = PersonCacheWrapperThreadTest.this.personCache.getPersons4FirstName("1name" + loop);
                        for (Person person : foundPersons) {
                            System.out.println(this.getName() + " : " + person);
                        }
                        try {
                            2.sleep(32L);
                            continue;
                        }
                        catch (Exception e) {
                            System.out.println("abort " + this.getName());
                        }
                    }
                }
            }.start();
            if (!this.getName().equals("read-thread 39")) continue;
            this.readersFinished = true;
        }
        while (!this.writersFinished || !this.readersFinished) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    public void testGetPersons4FirstName() {
        Collection<Person> persons4FirstName = this.personCache.getPersons4FirstName("Ingo");
        PersonCacheWrapperThreadTest.assertTrue((boolean)persons4FirstName.contains(this.persons.get(0)));
        PersonCacheWrapperThreadTest.assertEquals((int)1, (int)persons4FirstName.size());
        persons4FirstName = this.personCache.getPersons4Birth(null);
        PersonCacheWrapperThreadTest.assertTrue((boolean)persons4FirstName.contains(this.persons.get(2)));
        PersonCacheWrapperThreadTest.assertEquals((int)1, (int)persons4FirstName.size());
    }

    public void testGetPersons4LastName() {
        Collection<Person> persons4LastName = this.personCache.getPersons4LastName("Gerberding");
        PersonCacheWrapperThreadTest.assertTrue((boolean)persons4LastName.contains(this.persons.get(1)));
        PersonCacheWrapperThreadTest.assertEquals((int)1, (int)persons4LastName.size());
    }

    public void testGetPersons4Birth() throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        Date birth = dateFormat.parse("04.04.1974");
        Collection<Person> persons4Birth = this.personCache.getPersons4Birth(birth);
        PersonCacheWrapperThreadTest.assertTrue((boolean)persons4Birth.contains(this.persons.get(0)));
        PersonCacheWrapperThreadTest.assertEquals((int)1, (int)persons4Birth.size());
    }

    public void testGetPersons4EmployeeNo() {
        Collection<Person> persons4EmployeeNo = this.personCache.getPersons4EmployeeNo(6);
        PersonCacheWrapperThreadTest.assertTrue((boolean)persons4EmployeeNo.contains(this.persons.get(1)));
        PersonCacheWrapperThreadTest.assertEquals((int)1, (int)persons4EmployeeNo.size());
    }

    public void testRemoveFromCache() throws IllegalAccessException, InvocationTargetException {
        ArrayList<Person> personListClone = new ArrayList<Person>();
        personListClone.addAll(this.persons);
        Collection<Person> persons4FirstName = this.personCache.getPersons4FirstName("Ingo");
        this.personCache.removePerson(persons4FirstName);
        Collection<Person> allPersons = this.personCache.getAllPersons();
        PersonCacheWrapperThreadTest.assertEquals((int)2, (int)allPersons.size());
        persons4FirstName = this.personCache.getPersons4FirstName("Ingo");
        PersonCacheWrapperThreadTest.assertEquals((int)0, (int)persons4FirstName.size());
        PersonCacheWrapperThreadTest.assertTrue((boolean)allPersons.contains(personListClone.get(1)));
    }

    private static List<Person> createPersonList() throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        ArrayList<Person> personList = new ArrayList<Person>();
        Person person = new Person("Ingo", "Goldbeck", dateFormat.parse("04.04.1974"), 25);
        personList.add(person);
        person = new Person("Frank", "Gerberding", dateFormat.parse("03.03.1969"), 6);
        personList.add(person);
        person = new Person(null, null, null, 0);
        personList.add(person);
        return personList;
    }
}

