/*
 * Decompiled with CFR 0.152.
 */
package perf.org.rapidpm.lang.cache.generic.book;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import junit.org.rapidpm.lang.cache.generic.book.Book;
import junit.org.rapidpm.lang.cache.generic.book.BookCacheWrapper;

public class BookCacheWrapperPerformanceTest
extends TestCase {
    private List<Book> bookList;
    private BookCacheWrapper bookCache = new BookCacheWrapper();
    private static final int ROUNDTRIP = 100000;

    protected void setUp() throws Exception {
        this.bookList = this.createBookList();
        long milliStart = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            this.bookCache.put2Cache(this.bookList);
        }
        long milliEnd = System.currentTimeMillis();
        System.out.println("put2cache time: " + (milliEnd - milliStart));
    }

    public void testFillCache() {
        BookCacheWrapperPerformanceTest.assertEquals((int)10, (int)this.bookCache.getAllBooks().size());
    }

    public void testGetBook4KeyWords() {
        ArrayList<String> keyWordList = new ArrayList<String>();
        keyWordList.add("q");
        keyWordList.add("g");
        long milliStart = System.currentTimeMillis();
        for (int i = 0; i < 10000000; ++i) {
            Collection<Book> books4KeyWords = this.bookCache.getBooks4KeyWords(keyWordList);
            BookCacheWrapperPerformanceTest.assertTrue((boolean)books4KeyWords.contains(this.bookList.get(2)));
            BookCacheWrapperPerformanceTest.assertTrue((boolean)books4KeyWords.contains(this.bookList.get(3)));
            BookCacheWrapperPerformanceTest.assertTrue((boolean)books4KeyWords.contains(this.bookList.get(7)));
            BookCacheWrapperPerformanceTest.assertTrue((boolean)books4KeyWords.contains(this.bookList.get(8)));
            BookCacheWrapperPerformanceTest.assertTrue((boolean)books4KeyWords.contains(this.bookList.get(9)));
            BookCacheWrapperPerformanceTest.assertEquals((int)5, (int)books4KeyWords.size());
        }
        long milliEnd = System.currentTimeMillis();
        System.out.println("getBook4KeyWords time: " + (milliEnd - milliStart));
    }

    public void testGetBook4Month() {
        long milliStart = System.currentTimeMillis();
        for (int i = 0; i < 10000000; ++i) {
            Collection<Book> books4Month = this.bookCache.getBooks4Month("200503");
            BookCacheWrapperPerformanceTest.assertTrue((boolean)books4Month.contains(this.bookList.get(8)));
            BookCacheWrapperPerformanceTest.assertTrue((boolean)books4Month.contains(this.bookList.get(9)));
            BookCacheWrapperPerformanceTest.assertEquals((int)2, (int)books4Month.size());
        }
        long milliEnd = System.currentTimeMillis();
        System.out.println("getBooks4Month time: " + (milliEnd - milliStart));
    }

    public void testGetBook4Cw() {
        Collection<Book> books4Month = this.bookCache.getBooks4Cw("2005KW5");
        BookCacheWrapperPerformanceTest.assertTrue((boolean)books4Month.contains(this.bookList.get(4)));
        BookCacheWrapperPerformanceTest.assertEquals((int)1, (int)books4Month.size());
    }

    public void testGetBook4Date() {
        Collection<Book> books4Date = this.bookCache.getBooks4Date("20050215");
        BookCacheWrapperPerformanceTest.assertTrue((boolean)books4Date.contains(this.bookList.get(6)));
        BookCacheWrapperPerformanceTest.assertEquals((int)1, (int)books4Date.size());
    }

    public void testRemoveFromCache() throws IllegalAccessException, InvocationTargetException {
        ArrayList<Book> bookListClone = new ArrayList<Book>();
        bookListClone.addAll(this.bookList);
        ArrayList<String> keyWordList = new ArrayList<String>();
        keyWordList.add("q");
        keyWordList.add("g");
        long milliStart = System.currentTimeMillis();
        for (int i = 0; i < 10000000; ++i) {
            Collection<Book> books4KeyWords = this.bookCache.getBooks4KeyWords(keyWordList);
            this.bookCache.removeBook(books4KeyWords);
            Collection<Book> allBooks = this.bookCache.getAllBooks();
            BookCacheWrapperPerformanceTest.assertEquals((int)5, (int)allBooks.size());
            books4KeyWords = this.bookCache.getBooks4KeyWords(keyWordList);
            BookCacheWrapperPerformanceTest.assertEquals((int)0, (int)books4KeyWords.size());
            BookCacheWrapperPerformanceTest.assertTrue((boolean)allBooks.contains(bookListClone.get(0)));
            BookCacheWrapperPerformanceTest.assertTrue((boolean)allBooks.contains(bookListClone.get(1)));
            BookCacheWrapperPerformanceTest.assertTrue((boolean)allBooks.contains(bookListClone.get(4)));
            BookCacheWrapperPerformanceTest.assertTrue((boolean)allBooks.contains(bookListClone.get(5)));
            BookCacheWrapperPerformanceTest.assertTrue((boolean)allBooks.contains(bookListClone.get(6)));
        }
        long milliEnd = System.currentTimeMillis();
        System.out.println("RemoveFromCache time: " + (milliEnd - milliStart));
    }

    private List<Book> createBookList() {
        ArrayList<Book> bookList = new ArrayList<Book>();
        Book book = new Book("a", "a", "a", "2005KW1", "20050101", "200501", this.createKeyWordList("a", "b", "c"));
        bookList.add(book);
        book = new Book("b", "b", "b", "2005KW1", "20050106", "200501", this.createKeyWordList("c", "d", "e"));
        bookList.add(book);
        book = new Book("c", "c", "c", "2005KW3", "20050115", "200501", this.createKeyWordList("e", "f", "g"));
        bookList.add(book);
        book = new Book("d", "d", "d", "2005KW4", "20050122", "200501", this.createKeyWordList("g", "h", "i"));
        bookList.add(book);
        book = new Book("e", "e", "e", "2005KW5", "20050201", "200502", this.createKeyWordList("i", "j", "k"));
        bookList.add(book);
        book = new Book("f", "f", "f", "2005KW6", "20050208", "200502", this.createKeyWordList("k", "l", "m"));
        bookList.add(book);
        book = new Book("g", "g", "g", "2005KW7", "20050215", "200502", this.createKeyWordList("m", "n", "o"));
        bookList.add(book);
        book = new Book("h", "h", "h", "2005KW8", "20050222", "200502", this.createKeyWordList("o", "p", "q"));
        bookList.add(book);
        book = new Book("i", "i", "i", "2005KW9", "20050301", "200503", this.createKeyWordList("q", "r", "s"));
        bookList.add(book);
        book = new Book("k", "k", "k", "2005KW10", "20050308", "200503", this.createKeyWordList("q", "r", "s"));
        bookList.add(book);
        return bookList;
    }

    private List<String> createKeyWordList(String s, String s1, String s2) {
        ArrayList<String> keyWordList = new ArrayList<String>();
        keyWordList.add(s);
        keyWordList.add(s1);
        keyWordList.add(s2);
        return keyWordList;
    }
}

