/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.lang.cache.generic;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.rapidpm.lang.cache.generic.Cache;
import org.rapidpm.lang.cache.generic.CacheFinder;
import org.rapidpm.lang.cache.generic.Cacheable;
import org.rapidpm.lang.cache.generic.ReferenceSet;
import org.rapidpm.module.se.commons.logger.Logger;

public class GenericCacheThreadsave<T>
implements Cache<T>,
Serializable {
    private static final Logger logger = Logger.getLogger(GenericCacheThreadsave.class);
    private final Map<String, Index<T>> attribName2Index = new HashMap<String, Index<T>>();
    private final Map<String, Method> attribName2Method = new HashMap<String, Method>();
    private String primaryKeyAttributeName;
    private final boolean weakRefs;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public GenericCacheThreadsave(Class<T> clazz, boolean weakRefs) {
        this.weakRefs = weakRefs;
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method readMethod = propertyDescriptor.getReadMethod();
                if (readMethod == null) continue;
                String name = propertyDescriptor.getName();
                this.attribName2Method.put(name, readMethod);
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    public GenericCacheThreadsave(Class<T> clazz) {
        this(clazz, true);
    }

    @Override
    public void fillCache(List<T> cacheables) throws IllegalAccessException, InvocationTargetException {
        for (T cacheable : cacheables) {
            this.fillCache(cacheable);
        }
    }

    @Override
    public void fillCache(T cacheable) throws IllegalAccessException, InvocationTargetException {
        boolean annotationPresent = cacheable.getClass().isAnnotationPresent(Cacheable.class);
        if (annotationPresent) {
            Cacheable annotation = cacheable.getClass().getAnnotation(Cacheable.class);
            this.primaryKeyAttributeName = annotation.primaryKeyAttributeName();
            for (Map.Entry<String, Method> attribute : this.attribName2Method.entrySet()) {
                String attribName = attribute.getKey();
                Index<T> index = this.attribName2Index.get(attribName);
                if (index == null) {
                    index = new Index();
                    this.attribName2Index.put(attribName, index);
                }
                Method readMethod = attribute.getValue();
                Object key = readMethod.invoke(cacheable, new Object[0]);
                index.putSingleOrMultiple(key, cacheable);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"Class has no Annotation Cacheable");
        }
    }

    @Override
    public void removeFromCache(Collection<T> cacheables) throws IllegalAccessException, InvocationTargetException {
        for (T cacheable : cacheables) {
            this.removeFromCache(cacheable);
        }
    }

    @Override
    public void removeFromCache(T cacheable2Remove) throws IllegalAccessException, InvocationTargetException {
        for (Map.Entry<String, Method> entry : this.attribName2Method.entrySet()) {
            String attrName = entry.getKey();
            Method readMethod = entry.getValue();
            Object key = readMethod.invoke(cacheable2Remove, new Object[0]);
            Index<T> index = this.attribName2Index.get(attrName);
            index.remove(key, cacheable2Remove);
        }
    }

    @Override
    public Collection<T> findForKey(String attributeName, Object key) {
        Index<T> index = this.attribName2Index.get(attributeName);
        return index == null ? new ArrayList() : index.get(key);
    }

    @Override
    public Collection<T> findForKeys(String attributeName, Collection<? extends Object> keys) {
        Index<T> index = this.attribName2Index.get(attributeName);
        if (index == null) {
            return Collections.emptyList();
        }
        HashSet<T> result = new HashSet<T>();
        for (Object object : keys) {
            result.addAll(index.get(object));
        }
        return result;
    }

    @Override
    public Collection<T> getAllFromCache() {
        if (this.primaryKeyAttributeName == null) {
            return Collections.emptyList();
        }
        Index<T> index = this.attribName2Index.get(this.primaryKeyAttributeName);
        return index.getAllValues();
    }

    @Override
    public <C> CacheFinder<T, C> createCacheFinder(String attributeName) {
        assert (attributeName != null) : "attributeName must not be null";
        return new CacheFinder(this, attributeName);
    }

    private class Index<T> {
        private final Map<Object, ReferenceSet<T>> indexMap = new HashMap<Object, ReferenceSet<T>>();

        private Index() {
        }

        public void put(Object key, T value) {
            ReferenceSet<T> referenceSet = this.indexMap.get(key);
            if (referenceSet == null) {
                referenceSet = new ReferenceSet(GenericCacheThreadsave.this.weakRefs, GenericCacheThreadsave.this.lock);
                this.indexMap.put(key, referenceSet);
            }
            referenceSet.add(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putSingleOrMultiple(Object key, T value) {
            try {
                GenericCacheThreadsave.this.lock.writeLock().lock();
                if (key instanceof Iterable) {
                    Collection keys = (Collection)key;
                    for (Object singleKey : keys) {
                        this.put(singleKey, value);
                    }
                } else {
                    this.put(key, value);
                }
            }
            finally {
                GenericCacheThreadsave.this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(Object key, T value) {
            try {
                GenericCacheThreadsave.this.lock.writeLock().lock();
                if (key instanceof Iterable) {
                    Collection keys = (Collection)key;
                    for (Object singleKey : keys) {
                        ReferenceSet<T> referenceSet = this.indexMap.get(singleKey);
                        referenceSet.remove(value);
                        if (!referenceSet.isEmpty()) continue;
                        this.indexMap.remove(singleKey);
                    }
                } else {
                    ReferenceSet<T> referenceSet = this.indexMap.get(key);
                    referenceSet.remove(value);
                    if (referenceSet.isEmpty()) {
                        this.indexMap.remove(key);
                    }
                }
            }
            finally {
                GenericCacheThreadsave.this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<T> get(Object key) {
            try {
                GenericCacheThreadsave.this.lock.readLock().lock();
                ReferenceSet<T> result = this.indexMap.get(key);
                if (result == null) {
                    List list = Collections.emptyList();
                    return list;
                }
                if (result.isEmpty()) {
                    try {
                        GenericCacheThreadsave.this.lock.readLock().unlock();
                        GenericCacheThreadsave.this.lock.writeLock().lock();
                        this.indexMap.remove(key);
                        GenericCacheThreadsave.this.lock.readLock().lock();
                    }
                    finally {
                        GenericCacheThreadsave.this.lock.writeLock().unlock();
                    }
                }
                Collection<T> collection = result.toReferents();
                return collection;
            }
            finally {
                GenericCacheThreadsave.this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<T> getAllValues() {
            try {
                GenericCacheThreadsave.this.lock.readLock().lock();
                HashSet<T> result = new HashSet<T>();
                for (ReferenceSet<T> values : this.indexMap.values()) {
                    result.addAll(values.toReferents());
                }
                HashSet<T> hashSet = result;
                return hashSet;
            }
            finally {
                GenericCacheThreadsave.this.lock.readLock().unlock();
            }
        }
    }
}

