/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.lang.cache.generic;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import org.rapidpm.lang.cache.generic.GcHardRef;
import org.rapidpm.lang.cache.generic.GcReference;
import org.rapidpm.lang.cache.generic.GcSoftRef;

public class ReferenceSet<T>
implements Serializable {
    private final boolean weakRefs;
    private final Set<GcReference<T>> set = new HashSet<GcReference<T>>();
    private final ReferenceQueue<T> queue = new ReferenceQueue();
    private final ReadWriteLock lock;

    public ReferenceSet(boolean weakRefs, ReadWriteLock lock) {
        this.weakRefs = weakRefs;
        this.lock = lock;
    }

    public ReferenceSet(boolean weakRefs) {
        this(weakRefs, null);
    }

    public void add(T object) {
        this.set.add(this.createReference(object));
    }

    public void addAll(ReferenceSet<T> set2Add) {
        this.set.addAll(set2Add.set);
    }

    public void remove(T toRemove) {
        GcReference<T> ref = this.createReference(toRemove);
        this.set.remove(ref);
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public Collection<T> toReferents() {
        this.expungeStaleEntries();
        HashSet<T> result = new HashSet<T>();
        for (GcReference<T> ref : this.set) {
            T referent = ref.get();
            if (referent == null) continue;
            result.add(referent);
        }
        return result;
    }

    private void expungeStaleEntries() {
        Reference<T> removed = this.queue.poll();
        while (removed != null) {
            if (this.lock != null) {
                try {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    this.set.remove(removed);
                    this.lock.readLock().lock();
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            } else {
                this.set.remove(removed);
            }
            removed = this.queue.poll();
        }
    }

    private GcReference<T> createReference(T object) {
        return this.weakRefs ? new GcSoftRef<T>(object, this.queue) : new GcHardRef<T>(object);
    }
}

